/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test;

import javax.ws.rs.core.Application;
import org.glassfish.jersey.server.ResourceConfig;

public class DeploymentContext {
    private final ResourceConfig resourceConfig;
    private final String contextPath;

    public static Builder builder(Application application) {
        return new Builder(application);
    }

    public static Builder builder(Class<? extends Application> applicationClass) {
        return new Builder(applicationClass);
    }

    public static DeploymentContext newInstance(Application application) {
        return new Builder(application).build();
    }

    public static DeploymentContext newInstance(Class<? extends Application> applicationClass) {
        return new Builder(applicationClass).build();
    }

    protected DeploymentContext(Builder b) {
        this.contextPath = b.contextPath;
        this.resourceConfig = b.resourceConfig;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public final String getContextPath() {
        return this.contextPath;
    }

    public static class Builder {
        private static final String DEFAULT_CONTEXT_PATH = "";
        private final ResourceConfig resourceConfig;
        private String contextPath = "";

        protected Builder() {
            this.resourceConfig = null;
        }

        protected Builder(Application app) {
            if (app == null) {
                throw new NullPointerException("Application must not be null.");
            }
            this.resourceConfig = ResourceConfig.forApplication((Application)app);
        }

        protected Builder(Class<? extends Application> appClass) {
            if (appClass == null) {
                throw new NullPointerException("Application class must not be null.");
            }
            this.resourceConfig = ResourceConfig.forApplicationClass(appClass);
        }

        public Builder contextPath(String contextPath) {
            if (contextPath == null) {
                throw new NullPointerException("The context path must not be null");
            }
            this.contextPath = contextPath;
            return this;
        }

        public DeploymentContext build() {
            DeploymentContext lld = new DeploymentContext(this);
            this.reset();
            return lld;
        }

        protected void reset() {
            this.contextPath = DEFAULT_CONTEXT_PATH;
        }
    }
}

