ace.define("ace/mode/terraform_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(n,d,p){"use strict";var m=n("../lib/oop"),u=n("./text_highlight_rules").TextHighlightRules,o=function(){this.$rules={start:[{token:["storage.function.terraform"],regex:"\\b(output|resource|data|variable|module|export)\\b"},{token:"variable.terraform",regex:"\\$\\s",push:[{token:"keyword.terraform",regex:"(-var-file|-var)"},{token:"variable.terraform",regex:"\\n|$",next:"pop"},{include:"strings"},{include:"variables"},{include:"operators"},{defaultToken:"text"}]},{token:"language.support.class",regex:"\\b(timeouts|provider|connection|provisioner|lifecycleprovider|atlas)\\b"},{token:"singleline.comment.terraform",regex:"#.*$"},{token:"singleline.comment.terraform",regex:"//.*$"},{token:"multiline.comment.begin.terraform",regex:/\/\*/,push:"blockComment"},{token:"storage.function.terraform",regex:"^\\s*(locals|terraform)\\s*{"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{include:"constants"},{include:"strings"},{include:"operators"},{include:"variables"}],blockComment:[{regex:/\*\//,token:"multiline.comment.end.terraform",next:"pop"},{defaultToken:"comment"}],constants:[{token:"constant.language.terraform",regex:"\\b(true|false|yes|no|on|off|EOF)\\b"},{token:"constant.numeric.terraform",regex:"(\\b([0-9]+)([kKmMgG]b?)?\\b)|(\\b(0x[0-9A-Fa-f]+)([kKmMgG]b?)?\\b)"}],variables:[{token:["variable.assignment.terraform","keyword.operator"],regex:"\\b([a-zA-Z_]+)(\\s*=)"}],interpolated_variables:[{token:"variable.terraform",regex:"\\b(var|self|count|path|local)\\b(?:\\.*[a-zA-Z_-]*)?"}],strings:[{token:"punctuation.quote.terraform",regex:"'",push:[{token:"punctuation.quote.terraform",regex:"'",next:"pop"},{include:"escaped_chars"},{defaultToken:"string"}]},{token:"punctuation.quote.terraform",regex:'"',push:[{token:"punctuation.quote.terraform",regex:'"',next:"pop"},{include:"interpolation"},{include:"escaped_chars"},{defaultToken:"string"}]}],escaped_chars:[{token:"constant.escaped_char.terraform",regex:"\\\\."}],operators:[{token:"keyword.operator",regex:"\\?|:|==|!=|>|<|>=|<=|&&|\\|\\||!|%|&|\\*|\\+|\\-|/|="}],interpolation:[{token:"punctuation.interpolated.begin.terraform",regex:"\\$?\\$\\{",push:[{token:"punctuation.interpolated.end.terraform",regex:"\\}",next:"pop"},{include:"interpolated_variables"},{include:"operators"},{include:"constants"},{include:"strings"},{include:"functions"},{include:"parenthesis"},{defaultToken:"punctuation"}]}],functions:[{token:"keyword.function.terraform",regex:"\\b(abs|basename|base64decode|base64encode|base64gzip|base64sha256|base64sha512|bcrypt|ceil|chomp|chunklist|cidrhost|cidrnetmask|cidrsubnet|coalesce|coalescelist|compact|concat|contains|dirname|distinct|element|file|floor|flatten|format|formatlist|indent|index|join|jsonencode|keys|length|list|log|lookup|lower|map|matchkeys|max|merge|min|md5|pathexpand|pow|replace|rsadecrypt|sha1|sha256|sha512|signum|slice|sort|split|substr|timestamp|timeadd|title|transpose|trimspace|upper|urlencode|uuid|values|zipmap)\\b"}],parenthesis:[{token:"paren.lparen",regex:"\\["},{token:"paren.rparen",regex:"\\]"}]},this.normalizeRules()};m.inherits(o,u),d.TerraformHighlightRules=o}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(n,d,p){"use strict";var m=n("../../lib/oop"),u=n("../../range").Range,o=n("./fold_mode").FoldMode,s=d.FoldMode=function(e){e&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end)))};m.inherits(s,o),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(e,r,t){var i=e.getLine(t);if(this.singleLineBlockCommentRe.test(i)&&!this.startRegionRe.test(i)&&!this.tripleStarBlockCommentRe.test(i))return"";var l=this._getFoldWidgetBase(e,r,t);return!l&&this.startRegionRe.test(i)?"start":l},this.getFoldWidgetRange=function(e,r,t,i){var a,l=e.getLine(t);if(this.startRegionRe.test(l))return this.getCommentRegionBlock(e,l,t);if(a=l.match(this.foldingStartMarker)){var g=a.index;if(a[1])return this.openingBracketBlock(e,a[1],t,g);var c=e.getCommentFoldRange(t,g+a[0].length,1);return c&&!c.isMultiLine()&&(i?c=this.getSectionRange(e,t):"all"!=r&&(c=null)),c}return"markbegin"!==r&&(a=l.match(this.foldingStopMarker))?(g=a.index+a[0].length,a[1]?this.closingBracketBlock(e,a[1],t,g):e.getCommentFoldRange(t,g,-1)):void 0},this.getSectionRange=function(e,r){for(var t=e.getLine(r),i=t.search(/\S/),l=r,g=t.length,c=r+=1,a=e.getLength();++r<a;){var f=(t=e.getLine(r)).search(/\S/);if(-1!==f){if(i>f)break;var h=this.getFoldWidgetRange(e,"all",r);if(h){if(h.start.row<=l)break;if(h.isMultiLine())r=h.end.row;else if(i==f)break}c=r}}return new u(l,g,c,e.getLine(c).length)},this.getCommentRegionBlock=function(e,r,t){for(var i=r.search(/\s*$/),l=e.getLength(),g=t,c=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,a=1;++t<l;){r=e.getLine(t);var f=c.exec(r);if(f&&(f[1]?a--:a++,!a))break}if(t>g)return new u(g,i,t,r.length)}}.call(s.prototype)}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(n,d,p){"use strict";var m=n("../range").Range,u=function(){};(function(){this.checkOutdent=function(o,s){return!!/^\s+$/.test(o)&&/^\s*\}/.test(s)},this.autoOutdent=function(o,s){var r=o.getLine(s).match(/^(\s*\})/);if(!r)return 0;var t=r[1].length,i=o.findMatchingBracket({row:s,column:t});if(!i||i.row==s)return 0;var l=this.$getIndent(o.getLine(i.row));o.replace(new m(s,0,s,t-1),l)},this.$getIndent=function(o){return o.match(/^\s*/)[0]}}).call(u.prototype),d.MatchingBraceOutdent=u}),ace.define("ace/mode/terraform",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/terraform_highlight_rules","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle","ace/mode/matching_brace_outdent"],function(n,d,p){"use strict";var m=n("../lib/oop"),u=n("./text").Mode,o=n("./terraform_highlight_rules").TerraformHighlightRules,s=n("./behaviour/cstyle").CstyleBehaviour,e=n("./folding/cstyle").FoldMode,r=n("./matching_brace_outdent").MatchingBraceOutdent,t=function(){u.call(this),this.HighlightRules=o,this.$outdent=new r,this.$behaviour=new s,this.foldingRules=new e};m.inherits(t,u),function(){this.lineCommentStart=["#","//"],this.blockComment={start:"/*",end:"*/"},this.$id="ace/mode/terraform"}.call(t.prototype),d.Mode=t}),ace.require(["ace/mode/terraform"],function(n){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=n)});