/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.json.cluster;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterTopology {
    @JsonProperty(value="id")
    private final String clusterId;
    @JsonProperty(value="zones")
    private List<Zone> zones;
    @JsonProperty(value="allInstances")
    private Set<String> allInstances;

    public ClusterTopology(String clusterId, List<Zone> zones, Set<String> allInstances) {
        this.clusterId = clusterId;
        this.zones = zones;
        this.allInstances = allInstances;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public List<Zone> getZones() {
        return this.zones;
    }

    public Set<String> getAllInstances() {
        return this.allInstances;
    }

    public Map<String, Set<String>> toZoneMapping() {
        HashMap<String, Set<String>> zoneMapping = new HashMap<String, Set<String>>();
        if (this.zones == null) {
            return Collections.emptyMap();
        }
        for (Zone zone : this.zones) {
            zoneMapping.put(zone.getId(), new HashSet());
            if (zone.getInstances() == null) continue;
            for (Instance instance : zone.getInstances()) {
                ((Set)zoneMapping.get(zone.getId())).add(instance.getId());
            }
        }
        return zoneMapping;
    }

    public static final class Instance {
        @JsonProperty(value="id")
        private final String id;

        public Instance(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    public static final class Zone {
        @JsonProperty(value="id")
        private final String id;
        @JsonProperty(value="instances")
        private List<Instance> instances;

        public Zone(String id) {
            this.id = id;
        }

        public Zone(String id, List<Instance> instances) {
            this.id = id;
            this.instances = instances;
        }

        public List<Instance> getInstances() {
            return this.instances;
        }

        public void setInstances(List<Instance> instances) {
            this.instances = instances;
        }

        public String getId() {
            return this.id;
        }
    }
}

