/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.model.ClusterConstraints;
import org.apache.helix.model.builder.ConstraintItemBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintItem {
    private static Logger LOG = LoggerFactory.getLogger(ConstraintItem.class);
    final Map<ClusterConstraints.ConstraintAttribute, String> _attributes;
    final String _constraintValue;

    public ConstraintItem(Map<String, String> attributes) {
        ConstraintItemBuilder builder = new ConstraintItemBuilder();
        builder.addConstraintAttributes(attributes);
        this._attributes = builder.getAttributes();
        this._constraintValue = builder.getConstraintValue();
    }

    public ConstraintItem(Map<ClusterConstraints.ConstraintAttribute, String> attributes, String constraintValue) {
        this._attributes = attributes;
        this._constraintValue = constraintValue;
    }

    public boolean match(Map<ClusterConstraints.ConstraintAttribute, String> attributes) {
        for (ClusterConstraints.ConstraintAttribute key : this._attributes.keySet()) {
            if (!attributes.containsKey((Object)key)) {
                return false;
            }
            if (attributes.get((Object)key).matches(this._attributes.get((Object)key))) continue;
            return false;
        }
        return true;
    }

    public Map<ClusterConstraints.ConstraintAttribute, String> filter(Map<ClusterConstraints.ConstraintAttribute, String> attributes) {
        HashMap<ClusterConstraints.ConstraintAttribute, String> ret = new HashMap<ClusterConstraints.ConstraintAttribute, String>();
        for (ClusterConstraints.ConstraintAttribute key : this._attributes.keySet()) {
            ret.put(key, attributes.get((Object)key));
        }
        return ret;
    }

    public String getConstraintValue() {
        return this._constraintValue;
    }

    public Map<ClusterConstraints.ConstraintAttribute, String> getAttributes() {
        return this._attributes;
    }

    public String getAttributeValue(ClusterConstraints.ConstraintAttribute attr) {
        return this._attributes.get((Object)attr);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._attributes + ":" + this._constraintValue);
        return sb.toString();
    }
}

