/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import org.apache.helix.PropertyKey;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentStateResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(CurrentStateResource.class);

    public CurrentStateResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation presentation = null;
        try {
            String clusterName = (String)this.getRequest().getAttributes().get("clusterName");
            String instanceName = (String)this.getRequest().getAttributes().get("instanceName");
            String resourceGroup = (String)this.getRequest().getAttributes().get("resourceName");
            presentation = this.getInstanceCurrentStateRepresentation(clusterName, instanceName, resourceGroup);
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("", (Throwable)e);
        }
        return presentation;
    }

    StringRepresentation getInstanceCurrentStateRepresentation(String clusterName, String instanceName, String resourceGroup) throws JsonGenerationException, JsonMappingException, IOException {
        ZkClient zkClient = (ZkClient)this.getRequest().getAttributes().get("zkClient");
        String instanceSessionId = ClusterRepresentationUtil.getInstanceSessionId(zkClient, clusterName, instanceName);
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(clusterName);
        String message = ClusterRepresentationUtil.getInstancePropertyAsString(zkClient, clusterName, keyBuilder.currentState(instanceName, instanceSessionId, resourceGroup), MediaType.APPLICATION_JSON);
        StringRepresentation representation = new StringRepresentation((CharSequence)message, MediaType.APPLICATION_JSON);
        return representation;
    }
}

