/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.api.config.StateTransitionTimeoutConfig;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.common.ResourcesStateMap;
import org.apache.helix.controller.dataproviders.BaseControllerDataProvider;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.ClusterEventType;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.controller.stages.MessageOutput;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.util.HelixUtil;
import org.apache.helix.util.MessageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageGenerationPhase
extends AbstractBaseStage {
    private static final String NO_DESIRED_STATE = "NoDesiredState";
    public static final long DEFAULT_OBSELETE_MSG_PURGE_DELAY = HelixUtil.getSystemPropertyAsLong("helix.controller.stages.MessageGenerationPhase.messagePurgeDelay", 60000L);
    private static final String PENDING_MESSAGE = "pending message";
    private static final String STALE_MESSAGE = "stale message";
    private static Logger logger = LoggerFactory.getLogger(MessageGenerationPhase.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        BestPossibleStateOutput bestPossibleStateOutput = (BestPossibleStateOutput)event.getAttribute(AttributeName.BEST_POSSIBLE_STATE.name());
        this._eventId = event.getEventId();
        HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        BaseControllerDataProvider cache = (BaseControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES_TO_REBALANCE.name());
        CurrentStateOutput currentStateOutput = (CurrentStateOutput)event.getAttribute(AttributeName.CURRENT_STATE.name());
        HashMap<String, Map<String, Message>> messagesToCleanUp = new HashMap<String, Map<String, Message>>();
        if (manager == null || cache == null || resourceMap == null || currentStateOutput == null || bestPossibleStateOutput == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires HelixManager|DataCache|RESOURCES|CURRENT_STATE|BESTPOSSIBLE_STATE");
        }
        Map<String, LiveInstance> liveInstances = cache.getLiveInstances();
        HashMap<String, String> sessionIdMap = new HashMap<String, String>();
        for (LiveInstance liveInstance : liveInstances.values()) {
            sessionIdMap.put(liveInstance.getInstanceName(), liveInstance.getEphemeralOwner());
        }
        MessageOutput output = new MessageOutput();
        for (Resource resource : resourceMap.values()) {
            try {
                this.generateMessage(resource, cache, bestPossibleStateOutput, currentStateOutput, manager, sessionIdMap, event.getEventType(), output, messagesToCleanUp);
            }
            catch (HelixException ex) {
                LogUtil.logError(logger, this._eventId, "Failed to generate message for resource " + resource.getResourceName(), ex);
            }
        }
        if (!messagesToCleanUp.isEmpty()) {
            this.schedulePendingMessageCleanUp(messagesToCleanUp, cache.getAsyncTasksThreadPool(), manager.getHelixDataAccessor());
        }
        event.addAttribute(AttributeName.MESSAGES_ALL.name(), output);
    }

    private void generateMessage(Resource resource, BaseControllerDataProvider cache, ResourcesStateMap resourcesStateMap, CurrentStateOutput currentStateOutput, HelixManager manager, Map<String, String> sessionIdMap, ClusterEventType eventType, MessageOutput output, Map<String, Map<String, Message>> messagesToCleanUp) {
        String resourceName = resource.getResourceName();
        StateModelDefinition stateModelDef = cache.getStateModelDef(resource.getStateModelDefRef());
        if (stateModelDef == null) {
            LogUtil.logError(logger, this._eventId, "State Model Definition null, skip generating messages for resource: " + resourceName);
            return;
        }
        for (Partition partition : resource.getPartitions()) {
            HashMap<String, String> instanceStateMap = new HashMap<String, String>(resourcesStateMap.getInstanceStateMap(resourceName, partition));
            Map<String, String> pendingStateMap = currentStateOutput.getPendingStateMap(resourceName, partition);
            for (String string : pendingStateMap.keySet()) {
                if (instanceStateMap.containsKey(string)) continue;
                instanceStateMap.put(string, NO_DESIRED_STATE);
            }
            HashMap<String, List<Message>> messageMap = new HashMap<String, List<Message>>();
            for (String instanceName : instanceStateMap.keySet()) {
                Set<Message> staleMessages = cache.getStaleMessagesByInstance(instanceName);
                String desiredState = (String)instanceStateMap.get(instanceName);
                String currentState = currentStateOutput.getCurrentState(resourceName, partition, instanceName);
                Message pendingMessage = currentStateOutput.getPendingMessage(resourceName, partition, instanceName);
                boolean isCancellationEnabled = cache.getClusterConfig().isStateTransitionCancelEnabled();
                Message cancellationMessage = currentStateOutput.getCancellationMessage(resourceName, partition, instanceName);
                String nextState = stateModelDef.getNextStateForTransition(currentState, desiredState);
                Message message = null;
                if (currentState == null) {
                    currentState = stateModelDef.getInitialState();
                    nextState = stateModelDef.getNextStateForTransition(currentState, desiredState);
                    if (desiredState.equals(HelixDefinedState.DROPPED.name())) {
                        LogUtil.logDebug(logger, this._eventId, String.format("No current state for partition %s in resource %s, skip the drop message", partition.getPartitionName(), resourceName));
                        message = this.generateCancellationMessageForPendingMessage(desiredState, currentState, nextState, pendingMessage, manager, resource, partition, sessionIdMap, instanceName, stateModelDef, cancellationMessage, isCancellationEnabled);
                        this.addGeneratedMessageToMap(message, messageMap, eventType, cache, desiredState, resourceName, partition, currentState, nextState);
                        if (!(cache instanceof ResourceControllerDataProvider)) continue;
                        ((ResourceControllerDataProvider)cache).invalidateCachedIdealStateMapping(resourceName);
                        continue;
                    }
                }
                if (this.shouldCleanUpPendingMessage(pendingMessage, sessionIdMap, instanceName, currentState, currentStateOutput.getEndTime(resourceName, partition, instanceName))) {
                    this.logAndAddToCleanUp(messagesToCleanUp, pendingMessage, instanceName, resourceName, partition, currentState, PENDING_MESSAGE);
                }
                for (Message staleMessage : staleMessages) {
                    if (System.currentTimeMillis() - currentStateOutput.getEndTime(resourceName, partition, instanceName) <= DEFAULT_OBSELETE_MSG_PURGE_DELAY || !staleMessage.getResourceName().equals(resourceName) || !sessionIdMap.containsKey(instanceName) || !staleMessage.getPartitionName().equals(partition.getPartitionName()) && (!staleMessage.getBatchMessageMode() || !staleMessage.getPartitionNames().contains(partition.getPartitionName()))) continue;
                    this.logAndAddToCleanUp(messagesToCleanUp, staleMessage, instanceName, resourceName, partition, currentState, STALE_MESSAGE);
                }
                if (desiredState.equals(NO_DESIRED_STATE) || desiredState.equalsIgnoreCase(currentState)) {
                    if (this.shouldCreateSTCancellation(pendingMessage, desiredState, stateModelDef.getInitialState())) {
                        message = MessageUtil.createStateTransitionCancellationMessage(manager.getInstanceName(), manager.getSessionId(), resource, partition.getPartitionName(), instanceName, sessionIdMap.get(instanceName), stateModelDef.getId(), pendingMessage.getFromState(), pendingMessage.getToState(), null, cancellationMessage, isCancellationEnabled, currentState);
                    }
                } else {
                    if (nextState == null) {
                        LogUtil.logError(logger, this._eventId, "Unable to find a next state for resource: " + resource.getResourceName() + " partition: " + partition.getPartitionName() + " from stateModelDefinition" + stateModelDef.getClass() + " from:" + currentState + " to:" + desiredState);
                        continue;
                    }
                    if (pendingMessage != null) {
                        message = this.generateCancellationMessageForPendingMessage(desiredState, currentState, nextState, pendingMessage, manager, resource, partition, sessionIdMap, instanceName, stateModelDef, cancellationMessage, isCancellationEnabled);
                    } else {
                        message = MessageUtil.createStateTransitionMessage(manager.getInstanceName(), manager.getSessionId(), resource, partition.getPartitionName(), instanceName, currentState, nextState, sessionIdMap.get(instanceName), stateModelDef.getId());
                        if (logger.isDebugEnabled()) {
                            LogUtil.logDebug(logger, this._eventId, String.format("Resource %s partition %s for instance %s with currentState %s and nextState %s", resource.getResourceName(), partition.getPartitionName(), instanceName, currentState, nextState));
                        }
                    }
                }
                this.addGeneratedMessageToMap(message, messageMap, eventType, cache, desiredState, resourceName, partition, currentState, nextState);
            }
            List<String> list = stateModelDef.getStatesPriorityList();
            for (String state : list) {
                if (!messageMap.containsKey(state)) continue;
                for (Message message : (List)messageMap.get(state)) {
                    if (!message.isValid()) {
                        LogUtil.logError(logger, this._eventId, String.format("An invalid message was generated! Discarding this message. sessionIdMap: %s, CurrentStateMap: %s, InstanceStateMap: %s, AllInstances: %s, LiveInstances: %s, Message: %s", sessionIdMap, currentStateOutput.getCurrentStateMap(resourceName, partition), instanceStateMap, cache.getAllInstances(), cache.getLiveInstances().keySet(), message));
                        continue;
                    }
                    output.addMessage(resourceName, partition, message);
                }
            }
        }
    }

    private boolean shouldCreateSTCancellation(Message pendingMessage, String desiredState, String initialState) {
        if (pendingMessage == null) {
            return false;
        }
        if (NO_DESIRED_STATE.equals(desiredState)) {
            return true;
        }
        return !desiredState.equalsIgnoreCase(pendingMessage.getToState()) && (!HelixDefinedState.ERROR.name().equals(pendingMessage.getFromState()) || !initialState.equals(pendingMessage.getToState()));
    }

    private void logAndAddToCleanUp(Map<String, Map<String, Message>> messagesToCleanUp, Message message, String instanceName, String resourceName, Partition partition, String currentState, String cleanUpMessageType) {
        String logMsg = String.format("Adding %s %s on instance %s to clean up. Msg: %s->%s, current state of resource %s:%s is %s", cleanUpMessageType, message.getMsgId(), instanceName, message.getFromState(), message.getToState(), resourceName, partition, currentState);
        LogUtil.logInfo(logger, this._eventId, logMsg);
        if (!messagesToCleanUp.containsKey(instanceName)) {
            messagesToCleanUp.put(instanceName, new HashMap());
        }
        messagesToCleanUp.get(instanceName).put(message.getMsgId(), message);
    }

    private Message generateCancellationMessageForPendingMessage(String desiredState, String currentState, String nextState, Message pendingMessage, HelixManager manager, Resource resource, Partition partition, Map<String, String> sessionIdMap, String instanceName, StateModelDefinition stateModelDef, Message cancellationMessage, boolean isCancellationEnabled) {
        Message message = null;
        if (pendingMessage != null) {
            String pendingState = pendingMessage.getToState();
            if (nextState.equalsIgnoreCase(pendingState)) {
                LogUtil.logInfo(logger, this._eventId, "Message already exists for " + instanceName + " to transit " + resource.getResourceName() + "." + partition.getPartitionName() + " from " + currentState + " to " + nextState + ", isRelay: " + pendingMessage.isRelayMessage());
            } else if (currentState.equalsIgnoreCase(pendingState)) {
                LogUtil.logDebug(logger, this._eventId, "Message hasn't been removed for " + instanceName + " to transit " + resource.getResourceName() + "." + partition.getPartitionName() + " to " + pendingState + ", desiredState: " + desiredState + ", isRelay: " + pendingMessage.isRelayMessage());
            } else {
                LogUtil.logDebug(logger, this._eventId, "IdealState changed before state transition completes for " + resource.getResourceName() + "." + partition.getPartitionName() + " on " + instanceName + ", pendingState: " + pendingState + ", currentState: " + currentState + ", nextState: " + nextState + ", isRelay: " + pendingMessage.isRelayMessage());
                message = MessageUtil.createStateTransitionCancellationMessage(manager.getInstanceName(), manager.getSessionId(), resource, partition.getPartitionName(), instanceName, sessionIdMap.get(instanceName), stateModelDef.getId(), pendingMessage.getFromState(), pendingState, nextState, cancellationMessage, isCancellationEnabled, currentState);
            }
        }
        return message;
    }

    private void addGeneratedMessageToMap(Message message, Map<String, List<Message>> messageMap, ClusterEventType eventType, BaseControllerDataProvider cache, String desiredState, String resourceName, Partition partition, String currentState, String nextState) {
        if (message != null) {
            int timeout;
            IdealState idealState = cache.getIdealState(resourceName);
            if (idealState != null && idealState.getStateModelDefRef().equalsIgnoreCase("SchedulerTaskQueue") && idealState.getRecord().getMapField(partition.getPartitionName()) != null) {
                message.getRecord().setMapField(Message.Attributes.INNER_MESSAGE.toString(), idealState.getRecord().getMapField(partition.getPartitionName()));
            }
            if ((timeout = this.getTimeOut(cache.getClusterConfig(), cache.getResourceConfig(resourceName), currentState, nextState, idealState, partition)) > 0) {
                message.setExecutionTimeout(timeout);
            }
            message.setAttribute(Message.Attributes.ClusterEventName, eventType.name());
            if (!messageMap.containsKey(desiredState)) {
                messageMap.put(desiredState, new ArrayList());
            }
            messageMap.get(desiredState).add(message);
        }
    }

    private void schedulePendingMessageCleanUp(final Map<String, Map<String, Message>> pendingMessagesToPurge, ExecutorService workerPool, final HelixDataAccessor accessor) {
        workerPool.submit(new Callable<Object>(){

            @Override
            public Object call() {
                for (Map.Entry entry : pendingMessagesToPurge.entrySet()) {
                    String instanceName = (String)entry.getKey();
                    for (Message msg : ((Map)entry.getValue()).values()) {
                        if (!accessor.removeProperty(msg.getKey(accessor.keyBuilder(), instanceName))) continue;
                        LogUtil.logInfo(logger, MessageGenerationPhase.this._eventId, String.format("Deleted message %s from instance %s", msg.getMsgId(), instanceName));
                    }
                }
                return null;
            }
        });
    }

    private boolean shouldCleanUpPendingMessage(Message pendingMsg, Map<String, String> sessionIdMap, String instanceName, String currentState, Long currentStateTransitionEndTime) {
        if (pendingMsg == null || !sessionIdMap.containsKey(instanceName)) {
            return false;
        }
        if (currentState.equalsIgnoreCase(pendingMsg.getToState())) {
            return System.currentTimeMillis() - currentStateTransitionEndTime > DEFAULT_OBSELETE_MSG_PURGE_DELAY;
        }
        return !currentState.equalsIgnoreCase(pendingMsg.getFromState());
    }

    private int getTimeOut(ClusterConfig clusterConfig, ResourceConfig resourceConfig, String currentState, String nextState, IdealState idealState, Partition partition) {
        StateTransitionTimeoutConfig stateTransitionTimeoutConfig = clusterConfig.getStateTransitionTimeoutConfig();
        int timeout = stateTransitionTimeoutConfig != null ? stateTransitionTimeoutConfig.getStateTransitionTimeout(currentState, nextState) : -1;
        String timeOutStr = null;
        if (idealState != null) {
            String stateTransition = currentState + "-" + nextState + "_" + Message.Attributes.TIMEOUT;
            timeOutStr = idealState.getRecord().getSimpleField(stateTransition);
            if (timeOutStr == null && idealState.getStateModelDefRef().equalsIgnoreCase("SchedulerTaskQueue") && idealState.getRecord().getMapField(partition.getPartitionName()) != null) {
                timeOutStr = idealState.getRecord().getMapField(partition.getPartitionName()).get(Message.Attributes.TIMEOUT.toString());
            }
        }
        if (timeOutStr != null) {
            try {
                timeout = Integer.parseInt(timeOutStr);
            }
            catch (Exception e) {
                LogUtil.logError(logger, this._eventId, "", e);
            }
        }
        if (resourceConfig != null) {
            stateTransitionTimeoutConfig = resourceConfig.getStateTransitionTimeoutConfig();
            timeout = stateTransitionTimeoutConfig != null ? stateTransitionTimeoutConfig.getStateTransitionTimeout(currentState, nextState) : -1;
        }
        return timeout;
    }
}

