/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class CustomizedStateConfig
extends HelixProperty {
    public static final String CUSTOMIZED_STATE_CONFIG_KW = "CustomizedStateConfig";

    public CustomizedStateConfig() {
        super(CUSTOMIZED_STATE_CONFIG_KW);
    }

    public CustomizedStateConfig(ZNRecord record) {
        super(CUSTOMIZED_STATE_CONFIG_KW);
        this._record.setSimpleFields(record.getSimpleFields());
        this._record.setListFields(record.getListFields());
        this._record.setMapFields(record.getMapFields());
    }

    public void setAggregationEnabledTypes(List<String> aggregationEnabledTypes) {
        this._record.setListField(CustomizedStateProperty.AGGREGATION_ENABLED_TYPES.name(), aggregationEnabledTypes);
    }

    public List<String> getAggregationEnabledTypes() {
        return this._record.getListField(CustomizedStateProperty.AGGREGATION_ENABLED_TYPES.name());
    }

    public static class Builder {
        private ZNRecord _record;

        public CustomizedStateConfig build() {
            return new CustomizedStateConfig(this._record);
        }

        public Builder() {
            this._record = new ZNRecord(CustomizedStateConfig.CUSTOMIZED_STATE_CONFIG_KW);
        }

        public Builder(ZNRecord record) {
            this._record = record;
        }

        public Builder(CustomizedStateConfig customizedStateConfig) {
            this._record = customizedStateConfig.getRecord();
        }

        public Builder setAggregationEnabledTypes(List<String> aggregationEnabledTypes) {
            this._record.setListField(CustomizedStateProperty.AGGREGATION_ENABLED_TYPES.name(), aggregationEnabledTypes);
            return this;
        }

        public Builder addAggregationEnabledType(String type) {
            if (this._record.getListField(CustomizedStateProperty.AGGREGATION_ENABLED_TYPES.name()) == null) {
                this._record.setListField(CustomizedStateProperty.AGGREGATION_ENABLED_TYPES.name(), new ArrayList<String>());
            }
            List<String> aggregationEnabledTypes = this._record.getListField(CustomizedStateProperty.AGGREGATION_ENABLED_TYPES.name());
            aggregationEnabledTypes.add(type);
            this._record.setListField(CustomizedStateProperty.AGGREGATION_ENABLED_TYPES.name(), aggregationEnabledTypes);
            return this;
        }

        public Builder removeAggregationEnabledType(String type) {
            if (!this._record.getListField(CustomizedStateProperty.AGGREGATION_ENABLED_TYPES.name()).contains(type)) {
                throw new HelixException("Type " + type + " is missing from the CustomizedStateConfig");
            }
            this._record.getListField(CustomizedStateProperty.AGGREGATION_ENABLED_TYPES.name()).remove(type);
            return this;
        }

        public List<String> getAggregationEnabledTypes() {
            return this._record.getListField(CustomizedStateProperty.AGGREGATION_ENABLED_TYPES.name());
        }
    }

    public static enum CustomizedStateProperty {
        AGGREGATION_ENABLED_TYPES;

    }
}

