/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import org.apache.helix.PropertyKey;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerStatusUpdateResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(ControllerStatusUpdateResource.class);

    public ControllerStatusUpdateResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation presentation = null;
        try {
            String zkServer = (String)this.getContext().getAttributes().get("zkSvr");
            String clusterName = (String)this.getRequest().getAttributes().get("clusterName");
            String messageType = (String)this.getRequest().getAttributes().get("MessageType");
            String messageId = (String)this.getRequest().getAttributes().get("MessageId");
            String sessionId = (String)this.getRequest().getAttributes().get("SessionId");
            presentation = this.getControllerStatusUpdateRepresentation(zkServer, clusterName, sessionId, messageType, messageId);
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("", (Throwable)e);
        }
        return presentation;
    }

    StringRepresentation getControllerStatusUpdateRepresentation(String zkServerAddress, String clusterName, String sessionId, String messageType, String messageId) throws JsonGenerationException, JsonMappingException, IOException {
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(clusterName);
        ZkClient zkClient = (ZkClient)this.getContext().getAttributes().get("zkClient");
        String message = ClusterRepresentationUtil.getPropertyAsString(zkClient, clusterName, keyBuilder.controllerTaskStatus(messageType, messageId), MediaType.APPLICATION_JSON);
        StringRepresentation representation = new StringRepresentation((CharSequence)message, MediaType.APPLICATION_JSON);
        return representation;
    }
}

