/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.changedetector.trimmer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.apache.helix.controller.changedetector.trimmer.HelixPropertyTrimmer;
import org.apache.helix.model.InstanceConfig;

public class InstanceConfigTrimmer
extends HelixPropertyTrimmer<InstanceConfig> {
    private static final InstanceConfigTrimmer _instanceConfigTrimmer = new InstanceConfigTrimmer();
    private static final Map<HelixPropertyTrimmer.FieldType, Set<String>> STATIC_TOPOLOGY_RELATED_FIELD_MAP = ImmutableMap.of((Object)((Object)HelixPropertyTrimmer.FieldType.SIMPLE_FIELD), (Object)ImmutableSet.of((Object)InstanceConfig.InstanceConfigProperty.HELIX_HOST.name(), (Object)InstanceConfig.InstanceConfigProperty.HELIX_PORT.name(), (Object)InstanceConfig.InstanceConfigProperty.HELIX_ZONE_ID.name(), (Object)InstanceConfig.InstanceConfigProperty.INSTANCE_WEIGHT.name(), (Object)InstanceConfig.InstanceConfigProperty.DOMAIN.name()), (Object)((Object)HelixPropertyTrimmer.FieldType.LIST_FIELD), (Object)ImmutableSet.of((Object)InstanceConfig.InstanceConfigProperty.TAG_LIST.name()), (Object)((Object)HelixPropertyTrimmer.FieldType.MAP_FIELD), (Object)ImmutableSet.of((Object)InstanceConfig.InstanceConfigProperty.INSTANCE_CAPACITY_MAP.name()));

    private InstanceConfigTrimmer() {
    }

    @Override
    protected Map<HelixPropertyTrimmer.FieldType, Set<String>> getNonTrimmableFields(InstanceConfig instanceConfig) {
        return STATIC_TOPOLOGY_RELATED_FIELD_MAP;
    }

    @Override
    public InstanceConfig trimProperty(InstanceConfig property) {
        return new InstanceConfig(this.doTrim(property));
    }

    public static InstanceConfigTrimmer getInstance() {
        return _instanceConfigTrimmer;
    }
}

