/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixManager;

public class NotificationContext {
    private Map<String, Object> _map;
    private HelixManager _manager;
    private Type _type;
    private HelixConstants.ChangeType _changeType;
    private String _pathChanged;
    private String _eventName;
    private long _creationTime;
    private boolean _isChildChange;

    public String getEventName() {
        return this._eventName;
    }

    public void setEventName(String eventName) {
        this._eventName = eventName;
    }

    public NotificationContext(HelixManager manager) {
        this._manager = manager;
        this._map = new HashMap<String, Object>();
        this._creationTime = System.currentTimeMillis();
    }

    public NotificationContext clone() {
        NotificationContext copy = new NotificationContext(this._manager);
        copy.setType(this._type);
        copy.setChangeType(this._changeType);
        copy.setPathChanged(this._pathChanged);
        copy.setEventName(this._eventName);
        copy.setCreationTime(this._creationTime);
        copy._map.putAll(this._map);
        return copy;
    }

    public HelixManager getManager() {
        return this._manager;
    }

    public Map<String, Object> getMap() {
        return this._map;
    }

    public Type getType() {
        return this._type;
    }

    public void setManager(HelixManager manager) {
        this._manager = manager;
    }

    public long getCreationTime() {
        return this._creationTime;
    }

    public void setCreationTime(long creationTime) {
        this._creationTime = creationTime;
    }

    public void add(String key, Object value) {
        this._map.put(key, value);
    }

    public void setMap(Map<String, Object> map) {
        this._map = map;
    }

    public void setType(Type type) {
        this._type = type;
    }

    public Object get(String key) {
        return this._map.get(key);
    }

    public String getPathChanged() {
        return this._pathChanged;
    }

    public void setPathChanged(String pathChanged) {
        this._pathChanged = pathChanged;
    }

    public HelixConstants.ChangeType getChangeType() {
        return this._changeType;
    }

    public void setChangeType(HelixConstants.ChangeType changeType) {
        this._changeType = changeType;
    }

    public boolean getIsChildChange() {
        return this._isChildChange;
    }

    public void setIsChildChange(boolean isChildChange) {
        this._isChildChange = isChildChange;
    }

    public static enum Type {
        INIT,
        CALLBACK,
        PERIODIC_REFRESH,
        FINALIZE;

    }

    public static enum MapKey {
        TASK_EXECUTOR,
        CURRENT_STATE_UPDATE,
        HELIX_TASK_RESULT;

    }
}

