/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.util;

public class JenkinsHash {
    private static final long MAX_VALUE = 0xFFFFFFFFL;
    private static final long CRUSH_HASH_SEED = 1315423911L;

    private static long byteToLong(byte b) {
        long val = b & 0x7F;
        if ((b & 0x80) != 0) {
            val += 128L;
        }
        return val;
    }

    private static long add(long val, long add) {
        return val + add & 0xFFFFFFFFL;
    }

    private static long subtract(long val, long subtract) {
        return val - subtract & 0xFFFFFFFFL;
    }

    private static long xor(long val, long xor) {
        return (val ^ xor) & 0xFFFFFFFFL;
    }

    private static long leftShift(long val, int shift) {
        return val << shift & 0xFFFFFFFFL;
    }

    private static long fourByteToLong(byte[] bytes, int offset) {
        return JenkinsHash.byteToLong(bytes[offset + 0]) + (JenkinsHash.byteToLong(bytes[offset + 1]) << 8) + (JenkinsHash.byteToLong(bytes[offset + 2]) << 16) + (JenkinsHash.byteToLong(bytes[offset + 3]) << 24);
    }

    private static Triple hashMix(Triple t) {
        long a = t.a;
        long b = t.b;
        long c = t.c;
        a = JenkinsHash.subtract(a, b);
        a = JenkinsHash.subtract(a, c);
        a = JenkinsHash.xor(a, c >> 13);
        b = JenkinsHash.subtract(b, c);
        b = JenkinsHash.subtract(b, a);
        b = JenkinsHash.xor(b, JenkinsHash.leftShift(a, 8));
        c = JenkinsHash.subtract(c, a);
        c = JenkinsHash.subtract(c, b);
        c = JenkinsHash.xor(c, b >> 13);
        a = JenkinsHash.subtract(a, b);
        a = JenkinsHash.subtract(a, c);
        a = JenkinsHash.xor(a, c >> 12);
        b = JenkinsHash.subtract(b, c);
        b = JenkinsHash.subtract(b, a);
        b = JenkinsHash.xor(b, JenkinsHash.leftShift(a, 16));
        c = JenkinsHash.subtract(c, a);
        c = JenkinsHash.subtract(c, b);
        c = JenkinsHash.xor(c, b >> 5);
        a = JenkinsHash.subtract(a, b);
        a = JenkinsHash.subtract(a, c);
        a = JenkinsHash.xor(a, c >> 3);
        b = JenkinsHash.subtract(b, c);
        b = JenkinsHash.subtract(b, a);
        b = JenkinsHash.xor(b, JenkinsHash.leftShift(a, 10));
        c = JenkinsHash.subtract(c, a);
        c = JenkinsHash.subtract(c, b);
        c = JenkinsHash.xor(c, b >> 15);
        return new Triple(a, b, c);
    }

    public long hash(long a) {
        long hash = JenkinsHash.xor(1315423911L, a);
        long b = a;
        long x = 231232L;
        long y = 1232L;
        Triple val = JenkinsHash.hashMix(new Triple(b, x, hash));
        b = val.a;
        x = val.b;
        hash = val.c;
        val = JenkinsHash.hashMix(new Triple(y, a, hash));
        hash = val.c;
        return hash;
    }

    public long hash(long a, long b) {
        long hash = JenkinsHash.xor(JenkinsHash.xor(1315423911L, a), b);
        long x = 231232L;
        long y = 1232L;
        Triple val = JenkinsHash.hashMix(new Triple(a, b, hash));
        a = val.a;
        b = val.b;
        hash = val.c;
        val = JenkinsHash.hashMix(new Triple(x, a, hash));
        x = val.a;
        a = val.b;
        hash = val.c;
        val = JenkinsHash.hashMix(new Triple(b, y, hash));
        hash = val.c;
        return hash;
    }

    public long hash(long a, long b, long c) {
        long hash = JenkinsHash.xor(JenkinsHash.xor(JenkinsHash.xor(1315423911L, a), b), c);
        long x = 231232L;
        long y = 1232L;
        Triple val = JenkinsHash.hashMix(new Triple(a, b, hash));
        a = val.a;
        b = val.b;
        hash = val.c;
        val = JenkinsHash.hashMix(new Triple(c, x, hash));
        c = val.a;
        x = val.b;
        hash = val.c;
        val = JenkinsHash.hashMix(new Triple(y, a, hash));
        y = val.a;
        a = val.b;
        hash = val.c;
        val = JenkinsHash.hashMix(new Triple(b, x, hash));
        b = val.a;
        x = val.b;
        hash = val.c;
        val = JenkinsHash.hashMix(new Triple(y, c, hash));
        hash = val.c;
        return hash;
    }

    private static class Triple {
        long a;
        long b;
        long c;

        public Triple(long a, long b, long c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }
    }
}

