/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class RESTConfig
extends HelixProperty {
    public RESTConfig(ZNRecord record) {
        super(record);
    }

    public RESTConfig(String id) {
        super(id);
    }

    public void set(SimpleFields property, String value) {
        this._record.setSimpleField(property.name(), value);
    }

    public String get(SimpleFields property) {
        return this._record.getSimpleField(property.name());
    }

    public String getBaseUrl(String instance) {
        String baseUrl = this.get(SimpleFields.CUSTOMIZED_HEALTH_URL);
        if (baseUrl == null || !baseUrl.contains("*")) {
            throw new HelixException("Invalid CUSTOMIZED_HEALTH_URL in REST config: " + baseUrl);
        }
        String instanceVip = instance;
        if (instance.contains("_")) {
            instanceVip = instance.substring(0, instance.indexOf(95));
        }
        return baseUrl.replace("*", instanceVip);
    }

    public static enum SimpleFields {
        CUSTOMIZED_HEALTH_URL;

    }
}

