/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.cloud.event.helix;

import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.cloud.event.helix.HelixEventHandlingUtil;
import org.apache.helix.constants.InstanceConstants;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.util.InstanceUtil;
import org.apache.helix.util.InstanceValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCloudEventCallbackImpl {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCloudEventCallbackImpl.class);
    private final String _instanceReason = "Cloud event in DefaultCloudEventCallback at %s";
    private final String _emmReason = "Cloud event EMM in DefaultCloudEventCallback by %s at %s";

    public void disableInstance(HelixManager manager, Object eventInfo) {
        String message = String.format("Cloud event in DefaultCloudEventCallback at %s", System.currentTimeMillis());
        LOG.info("DefaultCloudEventCallbackImpl disable Instance {}", (Object)manager.getInstanceName());
        if (InstanceValidationUtil.isEnabled(manager.getHelixDataAccessor(), manager.getInstanceName())) {
            InstanceUtil.setInstanceOperation(manager.getConfigAccessor(), manager.getHelixDataAccessor().getBaseDataAccessor(), manager.getClusterName(), manager.getInstanceName(), new InstanceConfig.InstanceOperation.Builder().setOperation(InstanceConstants.InstanceOperation.DISABLE).setSource(InstanceConstants.InstanceOperationSource.AUTOMATION).setReason(message).build());
        }
        HelixEventHandlingUtil.updateCloudEventOperationInClusterConfig(manager.getClusterName(), manager.getInstanceName(), manager.getHelixDataAccessor().getBaseDataAccessor(), false, message);
    }

    public void enableInstance(HelixManager manager, Object eventInfo) {
        LOG.info("DefaultCloudEventCallbackImpl enable Instance {}", (Object)manager.getInstanceName());
        String instanceName = manager.getInstanceName();
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        String message = String.format("Cloud event in DefaultCloudEventCallback at %s", System.currentTimeMillis());
        HelixEventHandlingUtil.updateCloudEventOperationInClusterConfig(manager.getClusterName(), instanceName, manager.getHelixDataAccessor().getBaseDataAccessor(), true, message);
        InstanceUtil.setInstanceOperation(manager.getConfigAccessor(), manager.getHelixDataAccessor().getBaseDataAccessor(), manager.getClusterName(), manager.getInstanceName(), new InstanceConfig.InstanceOperation.Builder().setOperation(InstanceConstants.InstanceOperation.ENABLE).setSource(InstanceConstants.InstanceOperationSource.AUTOMATION).setReason(message).build());
    }

    public void enterMaintenanceMode(HelixManager manager, Object eventInfo) {
        if (!manager.getClusterManagmentTool().isInMaintenanceMode(manager.getClusterName())) {
            LOG.info("DefaultCloudEventCallbackImpl enterMaintenanceMode by {}", (Object)manager.getInstanceName());
            manager.getClusterManagmentTool().manuallyEnableMaintenanceMode(manager.getClusterName(), true, String.format("Cloud event EMM in DefaultCloudEventCallback by %s at %s", manager.getInstanceName(), System.currentTimeMillis()), null);
        }
    }

    public void exitMaintenanceMode(HelixManager manager, Object eventInfo) {
        ClusterConfig clusterConfig = (ClusterConfig)manager.getHelixDataAccessor().getProperty(manager.getHelixDataAccessor().keyBuilder().clusterConfig());
        if (HelixEventHandlingUtil.checkNoInstanceUnderCloudEvent(clusterConfig)) {
            LOG.info("DefaultCloudEventCallbackImpl exitMaintenanceMode by {}", (Object)manager.getInstanceName());
            manager.getClusterManagmentTool().manuallyEnableMaintenanceMode(manager.getClusterName(), false, String.format("Cloud event EMM in DefaultCloudEventCallback by %s at %s", manager.getInstanceName(), System.currentTimeMillis()), null);
        } else {
            LOG.info("DefaultCloudEventCallbackImpl will not exitMaintenanceMode as there are {} instances under cloud event", (Object)clusterConfig.getDisabledInstancesWithInfo().keySet().size());
        }
    }
}

