/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.constraint;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.api.rebalancer.constraint.AbstractRebalanceHardConstraint;
import org.apache.helix.api.rebalancer.constraint.dataprovider.CapacityProvider;
import org.apache.helix.api.rebalancer.constraint.dataprovider.PartitionWeightProvider;
import org.apache.helix.controller.common.ResourcesStateMap;
import org.apache.helix.controller.rebalancer.util.ResourceUsageCalculator;

public class TotalCapacityConstraint
extends AbstractRebalanceHardConstraint {
    private final PartitionWeightProvider _partitionWeightProvider;
    private final CapacityProvider _capacityProvider;
    private final Map<String, Integer> _pendingUsage;

    public TotalCapacityConstraint(PartitionWeightProvider partitionWeightProvider, CapacityProvider capacityProvider) {
        this._partitionWeightProvider = partitionWeightProvider;
        this._capacityProvider = capacityProvider;
        this._pendingUsage = new HashMap<String, Integer>();
    }

    private boolean validate(String resource, String partition, String participant) {
        int usage = this._capacityProvider.getParticipantUsage(participant) + (this._pendingUsage.containsKey(participant) ? this._pendingUsage.get(participant) : 0);
        return this._partitionWeightProvider.getPartitionWeight(resource, partition) + usage <= this._capacityProvider.getParticipantCapacity(participant);
    }

    @Override
    public Map<String, boolean[]> isValid(String resource, Map<String, String[]> proposedAssignment) {
        HashMap<String, boolean[]> result = new HashMap<String, boolean[]>();
        for (String partition : proposedAssignment.keySet()) {
            String[] participants = proposedAssignment.get(partition);
            boolean[] validateResults = new boolean[participants.length];
            for (int i = 0; i < participants.length; ++i) {
                validateResults[i] = this.validate(resource, partition, participants[i]);
            }
            result.put(partition, validateResults);
        }
        return result;
    }

    @Override
    public void updateAssignment(ResourcesStateMap pendingAssignment) {
        Map<String, Integer> newParticipantUsage = ResourceUsageCalculator.getResourceUsage(pendingAssignment, this._partitionWeightProvider);
        for (String participant : newParticipantUsage.keySet()) {
            if (!this._pendingUsage.containsKey(participant)) {
                this._pendingUsage.put(participant, 0);
            }
            this._pendingUsage.put(participant, this._pendingUsage.get(participant) + newParticipantUsage.get(participant));
        }
    }
}

