/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSwitchMapMaybe<T, R>
extends Flowable<R> {
    final Flowable<T> source;
    final Function<? super T, ? extends MaybeSource<? extends R>> mapper;
    final boolean delayErrors;

    public FlowableSwitchMapMaybe(Flowable<T> source, Function<? super T, ? extends MaybeSource<? extends R>> mapper, boolean delayErrors) {
        this.source = source;
        this.mapper = mapper;
        this.delayErrors = delayErrors;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new SwitchMapMaybeSubscriber<T, R>(s, this.mapper, this.delayErrors));
    }

    static final class SwitchMapMaybeSubscriber<T, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -5402190102429853762L;
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends MaybeSource<? extends R>> mapper;
        final boolean delayErrors;
        final AtomicThrowable errors;
        final AtomicLong requested;
        final AtomicReference<SwitchMapMaybeObserver<R>> inner;
        static final SwitchMapMaybeObserver<Object> INNER_DISPOSED = new SwitchMapMaybeObserver(null);
        Subscription upstream;
        volatile boolean done;
        volatile boolean cancelled;
        long emitted;

        SwitchMapMaybeSubscriber(Subscriber<? super R> downstream, Function<? super T, ? extends MaybeSource<? extends R>> mapper, boolean delayErrors) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
            this.requested = new AtomicLong();
            this.inner = new AtomicReference();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            MaybeSource<R> ms;
            SwitchMapMaybeObserver<R> current = this.inner.get();
            if (current != null) {
                current.dispose();
            }
            try {
                ms = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null MaybeSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.upstream.cancel();
                this.inner.getAndSet(INNER_DISPOSED);
                this.onError(ex);
                return;
            }
            SwitchMapMaybeObserver observer = new SwitchMapMaybeObserver(this);
            while ((current = this.inner.get()) != INNER_DISPOSED) {
                if (!this.inner.compareAndSet(current, observer)) continue;
                ms.subscribe(observer);
                break;
            }
        }

        public void onError(Throwable t) {
            if (this.errors.tryAddThrowableOrReport(t)) {
                if (!this.delayErrors) {
                    this.disposeInner();
                }
                this.done = true;
                this.drain();
            }
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void disposeInner() {
            SwitchMapMaybeObserver<Object> current = this.inner.getAndSet(INNER_DISPOSED);
            if (current != null && current != INNER_DISPOSED) {
                current.dispose();
            }
        }

        public void request(long n) {
            BackpressureHelper.add(this.requested, n);
            this.drain();
        }

        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            this.disposeInner();
            this.errors.tryTerminateAndReport();
        }

        void innerError(SwitchMapMaybeObserver<R> sender, Throwable ex) {
            if (this.inner.compareAndSet(sender, null)) {
                if (this.errors.tryAddThrowableOrReport(ex)) {
                    if (!this.delayErrors) {
                        this.upstream.cancel();
                        this.disposeInner();
                    }
                    this.drain();
                }
            } else {
                RxJavaPlugins.onError(ex);
            }
        }

        void innerComplete(SwitchMapMaybeObserver<R> sender) {
            if (this.inner.compareAndSet(sender, null)) {
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<? super R> downstream = this.downstream;
            AtomicThrowable errors = this.errors;
            AtomicReference<SwitchMapMaybeObserver<R>> inner = this.inner;
            AtomicLong requested = this.requested;
            long emitted = this.emitted;
            while (true) {
                boolean empty;
                if (this.cancelled) {
                    return;
                }
                if (errors.get() != null && !this.delayErrors) {
                    errors.tryTerminateConsumer(downstream);
                    return;
                }
                boolean d = this.done;
                SwitchMapMaybeObserver<R> current = inner.get();
                boolean bl = empty = current == null;
                if (d && empty) {
                    errors.tryTerminateConsumer(downstream);
                    return;
                }
                if (!empty && current.item != null && emitted != requested.get()) {
                    inner.compareAndSet(current, null);
                    downstream.onNext(current.item);
                    ++emitted;
                    continue;
                }
                this.emitted = emitted;
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        static final class SwitchMapMaybeObserver<R>
        extends AtomicReference<Disposable>
        implements MaybeObserver<R> {
            private static final long serialVersionUID = 8042919737683345351L;
            final SwitchMapMaybeSubscriber<?, R> parent;
            volatile R item;

            SwitchMapMaybeObserver(SwitchMapMaybeSubscriber<?, R> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onSuccess(R t) {
                this.item = t;
                this.parent.drain();
            }

            @Override
            public void onError(Throwable e) {
                this.parent.innerError(this, e);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete(this);
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

