/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.exporters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metrics.MetricProvider;
import org.apache.ignite.internal.metrics.exporters.BasicMetricExporter;
import org.apache.ignite.internal.metrics.exporters.configuration.ExporterView;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.IgniteUtils;

public abstract class PushMetricExporter<CfgT extends ExporterView>
extends BasicMetricExporter<CfgT> {
    protected final IgniteLogger log = Loggers.forClass(this.getClass());
    private ScheduledFuture<?> fut;
    private ScheduledExecutorService scheduler;

    @Override
    public synchronized void start(MetricProvider metricProvider, CfgT conf) {
        super.start(metricProvider, conf);
        this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("metrics-exporter-" + this.name(), this.log));
        this.fut = this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.report();
            }
            catch (Throwable th) {
                this.log.error("Metrics export error. This exporter will be stopped [class=" + this.getClass() + ",name=" + this.name() + "]", th);
                throw th;
            }
        }, this.period(), this.period(), TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void stop() {
        if (this.fut != null) {
            this.fut.cancel(false);
        }
        if (this.scheduler != null) {
            IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.scheduler, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    protected abstract long period();

    public abstract void report();
}

