/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binarytuple;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.binarytuple.BinaryTupleParser;

public class BinaryTupleReader
extends BinaryTupleParser
implements BinaryTupleParser.Sink {
    private int begin = 0;
    private int end = 0;

    public BinaryTupleReader(int numElements, byte[] bytes) {
        this(numElements, ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN));
    }

    public BinaryTupleReader(int numElements, ByteBuffer buffer) {
        super(numElements, buffer);
    }

    @Override
    public final void nextElement(int index, int begin, int end) {
        this.begin = begin;
        this.end = end;
    }

    public boolean hasNullValue(int index) {
        this.seek(index);
        return this.begin == 0;
    }

    public byte byteValue(int index) {
        this.seek(index);
        return this.byteValue(this.begin, this.end);
    }

    public Byte byteValueBoxed(int index) {
        this.seek(index);
        return this.begin == 0 ? null : Byte.valueOf(this.byteValue(this.begin, this.end));
    }

    public short shortValue(int index) {
        this.seek(index);
        return this.shortValue(this.begin, this.end);
    }

    public Short shortValueBoxed(int index) {
        this.seek(index);
        return this.begin == 0 ? null : Short.valueOf(this.shortValue(this.begin, this.end));
    }

    public int intValue(int index) {
        this.seek(index);
        return this.intValue(this.begin, this.end);
    }

    public Integer intValueBoxed(int index) {
        this.seek(index);
        return this.begin == 0 ? null : Integer.valueOf(this.intValue(this.begin, this.end));
    }

    public long longValue(int index) {
        this.seek(index);
        return this.longValue(this.begin, this.end);
    }

    public Long longValueBoxed(int index) {
        this.seek(index);
        return this.begin == 0 ? null : Long.valueOf(this.longValue(this.begin, this.end));
    }

    public float floatValue(int index) {
        this.seek(index);
        return this.floatValue(this.begin, this.end);
    }

    public Float floatValueBoxed(int index) {
        this.seek(index);
        return this.begin == 0 ? null : Float.valueOf(this.floatValue(this.begin, this.end));
    }

    public double doubleValue(int index) {
        this.seek(index);
        return this.doubleValue(this.begin, this.end);
    }

    public Double doubleValueBoxed(int index) {
        this.seek(index);
        return this.begin == 0 ? null : Double.valueOf(this.doubleValue(this.begin, this.end));
    }

    public BigInteger numberValue(int index) {
        this.seek(index);
        return this.begin == 0 ? null : this.numberValue(this.begin, this.end);
    }

    public BigDecimal decimalValue(int index, int scale) {
        this.seek(index);
        return this.begin == 0 ? null : new BigDecimal(this.numberValue(this.begin, this.end), scale);
    }

    public String stringValue(int index) {
        this.seek(index);
        return this.begin == 0 ? null : this.stringValue(this.begin, this.end);
    }

    public byte[] bytesValue(int index) {
        this.seek(index);
        return this.begin == 0 ? null : this.bytesValue(this.begin, this.end);
    }

    public UUID uuidValue(int index) {
        this.seek(index);
        return this.begin == 0 ? null : this.uuidValue(this.begin, this.end);
    }

    public BitSet bitmaskValue(int index) {
        this.seek(index);
        return this.begin == 0 ? null : this.bitmaskValue(this.begin, this.end);
    }

    public LocalDate dateValue(int index) {
        this.seek(index);
        return this.begin == 0 ? null : this.dateValue(this.begin, this.end);
    }

    public LocalTime timeValue(int index) {
        this.seek(index);
        return this.begin == 0 ? null : this.timeValue(this.begin, this.end);
    }

    public LocalDateTime dateTimeValue(int index) {
        this.seek(index);
        return this.begin == 0 ? null : this.dateTimeValue(this.begin, this.end);
    }

    public Instant timestampValue(int index) {
        this.seek(index);
        return this.begin == 0 ? null : this.timestampValue(this.begin, this.end);
    }

    public Duration durationValue(int index) {
        this.seek(index);
        return this.begin == 0 ? null : this.durationValue(this.begin, this.end);
    }

    public Period periodValue(int index) {
        this.seek(index);
        return this.begin == 0 ? null : this.periodValue(this.begin, this.end);
    }

    private void seek(int index) {
        this.fetch(index, this);
    }
}

