/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel.agg;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteSingleAggregateBase;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteSortAggregateBase;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;

public class IgniteSingleSortAggregate
extends IgniteSingleAggregateBase
implements IgniteSortAggregateBase {
    private final RelCollation collation;

    public IgniteSingleSortAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traitSet, input, groupSet, groupSets, aggCalls);
        assert (!TraitUtils.collation(traitSet).isDefault());
        assert (!groupSet.isEmpty() && groupSets.size() == 1);
        this.collation = TraitUtils.collation(traitSet);
    }

    public IgniteSingleSortAggregate(RelInput input) {
        super(input);
        this.collation = input.getCollation();
        assert (Objects.nonNull(this.collation));
        assert (!this.collation.isDefault());
    }

    public Aggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        return new IgniteSingleSortAggregate(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteSingleSortAggregate(cluster, this.getTraitSet().replace((RelTrait)this.collation), (RelNode)IgniteSingleSortAggregate.sole(inputs), this.getGroupSet(), (List<ImmutableBitSet>)this.getGroupSets(), this.getAggCallList());
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("collation", (Object)this.collation);
    }

    @Override
    public RelCollation collation() {
        assert (this.collation.equals(super.collation()));
        return this.collation;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return this.computeSelfCostSort(planner, mq);
    }
}

