/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.marshaller.BinaryMode;
import org.apache.ignite.internal.marshaller.MarshallerColumn;
import org.apache.ignite.internal.marshaller.MarshallerException;
import org.apache.ignite.internal.marshaller.MarshallerReader;
import org.apache.ignite.internal.marshaller.MarshallerUtil;
import org.apache.ignite.internal.marshaller.MarshallerWriter;

abstract class FieldAccessor {
    protected final VarHandle varHandle;
    protected final BinaryMode mode;
    protected final int colIdx;
    protected final int scale;

    public Object get(Object obj) {
        return this.varHandle.get(obj);
    }

    public void set(Object obj, Object val) {
        this.varHandle.set(obj, val);
    }

    static FieldAccessor noopAccessor(MarshallerColumn col) {
        return new UnmappedFieldAccessor(col);
    }

    static FieldAccessor create(Class<?> type, String fldName, MarshallerColumn col, int colIdx) {
        try {
            Field field = type.getDeclaredField(fldName);
            BinaryMode mode = MarshallerUtil.mode(field.getType());
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(type, MethodHandles.lookup());
            VarHandle varHandle = lookup.unreflectVarHandle(field);
            assert (mode != null) : "Invalid mode for type: " + field.getType();
            switch (mode) {
                case P_BYTE: {
                    return new BytePrimitiveAccessor(varHandle, colIdx);
                }
                case P_SHORT: {
                    return new ShortPrimitiveAccessor(varHandle, colIdx);
                }
                case P_INT: {
                    return new IntPrimitiveAccessor(varHandle, colIdx);
                }
                case P_LONG: {
                    return new LongPrimitiveAccessor(varHandle, colIdx);
                }
                case P_FLOAT: {
                    return new FloatPrimitiveAccessor(varHandle, colIdx);
                }
                case P_DOUBLE: {
                    return new DoublePrimitiveAccessor(varHandle, colIdx);
                }
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case STRING: 
                case UUID: 
                case BYTE_ARR: 
                case BITSET: 
                case NUMBER: 
                case DECIMAL: 
                case TIME: 
                case DATE: 
                case DATETIME: 
                case TIMESTAMP: {
                    return new ReferenceFieldAccessor(varHandle, colIdx, mode, col.scale());
                }
            }
            assert (false) : "Invalid mode " + mode;
            throw new IllegalArgumentException("Failed to create accessor for field [name=" + field.getName() + "]");
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static FieldAccessor createIdentityAccessor(String col, int colIdx, BinaryMode mode) {
        switch (mode) {
            case P_BYTE: 
            case P_SHORT: 
            case P_INT: 
            case P_LONG: 
            case P_FLOAT: 
            case P_DOUBLE: {
                throw new IllegalArgumentException("Primitive key/value types are not possible by API contract.");
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case UUID: 
            case BYTE_ARR: 
            case BITSET: 
            case NUMBER: 
            case DECIMAL: 
            case TIME: 
            case DATE: 
            case DATETIME: 
            case TIMESTAMP: {
                return new IdentityAccessor(colIdx, mode);
            }
        }
        assert (false) : "Invalid mode " + mode;
        throw new IllegalArgumentException("Failed to create accessor for column [name=" + col + "]");
    }

    private static Object readRefValue(MarshallerReader reader, int colIdx, BinaryMode mode, int scale) {
        assert (reader != null);
        assert (colIdx >= 0);
        Object val = null;
        switch (mode) {
            case BYTE: {
                val = reader.readByteBoxed();
                break;
            }
            case SHORT: {
                val = reader.readShortBoxed();
                break;
            }
            case INT: {
                val = reader.readIntBoxed();
                break;
            }
            case LONG: {
                val = reader.readLongBoxed();
                break;
            }
            case FLOAT: {
                val = reader.readFloatBoxed();
                break;
            }
            case DOUBLE: {
                val = reader.readDoubleBoxed();
                break;
            }
            case STRING: {
                val = reader.readString();
                break;
            }
            case UUID: {
                val = reader.readUuid();
                break;
            }
            case BYTE_ARR: {
                val = reader.readBytes();
                break;
            }
            case BITSET: {
                val = reader.readBitSet();
                break;
            }
            case NUMBER: {
                val = reader.readBigInt();
                break;
            }
            case DECIMAL: {
                val = reader.readBigDecimal(scale);
                break;
            }
            case DATE: {
                val = reader.readDate();
                break;
            }
            case TIME: {
                val = reader.readTime();
                break;
            }
            case TIMESTAMP: {
                val = reader.readTimestamp();
                break;
            }
            case DATETIME: {
                val = reader.readDateTime();
                break;
            }
            default: {
                assert (false) : "Invalid mode: " + mode;
                break;
            }
        }
        return val;
    }

    private static void writeRefObject(Object val, MarshallerWriter writer, BinaryMode mode, int scale) {
        assert (writer != null);
        if (val == null) {
            writer.writeNull();
            return;
        }
        switch (mode) {
            case BYTE: {
                writer.writeByte((Byte)val);
                break;
            }
            case SHORT: {
                writer.writeShort((Short)val);
                break;
            }
            case INT: {
                writer.writeInt((Integer)val);
                break;
            }
            case LONG: {
                writer.writeLong((Long)val);
                break;
            }
            case FLOAT: {
                writer.writeFloat(((Float)val).floatValue());
                break;
            }
            case DOUBLE: {
                writer.writeDouble((Double)val);
                break;
            }
            case STRING: {
                writer.writeString((String)val);
                break;
            }
            case UUID: {
                writer.writeUuid((UUID)val);
                break;
            }
            case BYTE_ARR: {
                writer.writeBytes((byte[])val);
                break;
            }
            case BITSET: {
                writer.writeBitSet((BitSet)val);
                break;
            }
            case NUMBER: {
                writer.writeBigInt((BigInteger)val);
                break;
            }
            case DECIMAL: {
                writer.writeBigDecimal((BigDecimal)val, scale);
                break;
            }
            case DATE: {
                writer.writeDate((LocalDate)val);
                break;
            }
            case TIME: {
                writer.writeTime((LocalTime)val);
                break;
            }
            case TIMESTAMP: {
                writer.writeTimestamp((Instant)val);
                break;
            }
            case DATETIME: {
                writer.writeDateTime((LocalDateTime)val);
                break;
            }
            default: {
                assert (false) : "Invalid mode: " + mode;
                break;
            }
        }
    }

    protected FieldAccessor(VarHandle varHandle, int colIdx, BinaryMode mode, int scale) {
        assert (colIdx >= 0);
        this.colIdx = colIdx;
        this.mode = Objects.requireNonNull(mode);
        this.varHandle = Objects.requireNonNull(varHandle);
        this.scale = scale;
    }

    protected FieldAccessor(VarHandle varHandle, int colIdx, BinaryMode mode) {
        this(varHandle, colIdx, mode, 0);
    }

    private FieldAccessor(int colIdx, BinaryMode mode) {
        assert (colIdx >= 0);
        this.colIdx = colIdx;
        this.mode = mode;
        this.varHandle = null;
        this.scale = 0;
    }

    public void write(MarshallerWriter writer, Object obj) throws MarshallerException {
        try {
            this.write0(writer, obj);
        }
        catch (Exception ex) {
            throw new MarshallerException("Failed to write field [id=" + this.colIdx + "]", ex);
        }
    }

    protected abstract void write0(MarshallerWriter var1, Object var2) throws Exception;

    public void read(MarshallerReader reader, Object obj) throws MarshallerException {
        try {
            this.read0(reader, obj);
        }
        catch (Exception ex) {
            throw new MarshallerException("Failed to read field [id=" + this.colIdx + "]", ex);
        }
    }

    public Object read(MarshallerReader reader) {
        throw new UnsupportedOperationException();
    }

    protected abstract void read0(MarshallerReader var1, Object var2) throws Exception;

    Object value(Object obj) {
        return this.varHandle.get(Objects.requireNonNull(obj));
    }

    private static class ReferenceFieldAccessor
    extends FieldAccessor {
        ReferenceFieldAccessor(VarHandle varHandle, int colIdx, BinaryMode mode, int scale) {
            super(Objects.requireNonNull(varHandle), colIdx, mode, scale);
        }

        @Override
        protected void write0(MarshallerWriter writer, Object obj) {
            assert (obj != null);
            assert (writer != null);
            Object val = this.varHandle.get(obj);
            if (val == null) {
                writer.writeNull();
                return;
            }
            FieldAccessor.writeRefObject(val, writer, this.mode, this.scale);
        }

        @Override
        public void read0(MarshallerReader reader, Object obj) {
            Object val = FieldAccessor.readRefValue(reader, this.colIdx, this.mode, this.scale);
            this.varHandle.set(obj, val);
        }
    }

    private static class DoublePrimitiveAccessor
    extends FieldAccessor {
        DoublePrimitiveAccessor(VarHandle varHandle, int colIdx) {
            super(Objects.requireNonNull(varHandle), colIdx, BinaryMode.P_DOUBLE);
        }

        @Override
        protected void write0(MarshallerWriter writer, Object obj) {
            double val = this.varHandle.get(obj);
            writer.writeDouble(val);
        }

        @Override
        protected void read0(MarshallerReader reader, Object obj) {
            double val = reader.readDouble();
            this.varHandle.set(obj, val);
        }
    }

    private static class FloatPrimitiveAccessor
    extends FieldAccessor {
        FloatPrimitiveAccessor(VarHandle varHandle, int colIdx) {
            super(Objects.requireNonNull(varHandle), colIdx, BinaryMode.P_FLOAT);
        }

        @Override
        protected void write0(MarshallerWriter writer, Object obj) {
            float val = this.varHandle.get(obj);
            writer.writeFloat(val);
        }

        @Override
        protected void read0(MarshallerReader reader, Object obj) {
            float val = reader.readFloat();
            this.varHandle.set(obj, val);
        }
    }

    private static class LongPrimitiveAccessor
    extends FieldAccessor {
        LongPrimitiveAccessor(VarHandle varHandle, int colIdx) {
            super(Objects.requireNonNull(varHandle), colIdx, BinaryMode.P_LONG);
        }

        @Override
        protected void write0(MarshallerWriter writer, Object obj) {
            long val = this.varHandle.get(obj);
            writer.writeLong(val);
        }

        @Override
        protected void read0(MarshallerReader reader, Object obj) {
            long val = reader.readLong();
            this.varHandle.set(obj, val);
        }
    }

    private static class IntPrimitiveAccessor
    extends FieldAccessor {
        IntPrimitiveAccessor(VarHandle varHandle, int colIdx) {
            super(Objects.requireNonNull(varHandle), colIdx, BinaryMode.P_INT);
        }

        @Override
        protected void write0(MarshallerWriter writer, Object obj) {
            int val = this.varHandle.get(obj);
            writer.writeInt(val);
        }

        @Override
        protected void read0(MarshallerReader reader, Object obj) {
            int val = reader.readInt();
            this.varHandle.set(obj, val);
        }
    }

    private static class ShortPrimitiveAccessor
    extends FieldAccessor {
        ShortPrimitiveAccessor(VarHandle varHandle, int colIdx) {
            super(Objects.requireNonNull(varHandle), colIdx, BinaryMode.P_SHORT);
        }

        @Override
        protected void write0(MarshallerWriter writer, Object obj) {
            short val = this.varHandle.get(obj);
            writer.writeShort(val);
        }

        @Override
        protected void read0(MarshallerReader reader, Object obj) {
            short val = reader.readShort();
            this.varHandle.set(obj, val);
        }
    }

    private static class BytePrimitiveAccessor
    extends FieldAccessor {
        BytePrimitiveAccessor(VarHandle varHandle, int colIdx) {
            super(Objects.requireNonNull(varHandle), colIdx, BinaryMode.P_BYTE);
        }

        @Override
        protected void write0(MarshallerWriter writer, Object obj) {
            byte val = this.varHandle.get(obj);
            writer.writeByte(val);
        }

        @Override
        protected void read0(MarshallerReader reader, Object obj) {
            byte val = reader.readByte();
            this.varHandle.set(obj, val);
        }
    }

    private static class IdentityAccessor
    extends FieldAccessor {
        IdentityAccessor(int colIdx, BinaryMode mode) {
            super(colIdx, mode);
        }

        @Override
        protected void write0(MarshallerWriter writer, Object obj) {
            FieldAccessor.writeRefObject(obj, writer, this.mode, this.scale);
        }

        @Override
        protected void read0(MarshallerReader reader, Object obj) {
            throw new UnsupportedOperationException("Called identity accessor for object field.");
        }

        @Override
        public Object read(MarshallerReader reader) {
            return FieldAccessor.readRefValue(reader, this.colIdx, this.mode, this.scale);
        }

        @Override
        Object value(Object obj) {
            return obj;
        }
    }

    private static class UnmappedFieldAccessor
    extends FieldAccessor {
        private final MarshallerColumn col;

        UnmappedFieldAccessor(MarshallerColumn col) {
            super(0, null);
            this.col = col;
        }

        @Override
        protected void read0(MarshallerReader reader, Object obj) {
            reader.skipValue();
        }

        @Override
        protected void write0(MarshallerWriter writer, Object obj) {
            writer.writeAbsentValue();
        }

        @Override
        Object value(Object obj) {
            return this.col.defaultValue();
        }
    }
}

