/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BooleanSupplier;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.pagememory.FullPageId;
import org.apache.ignite.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite.internal.pagememory.persistence.PartitionMetaManager;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite.internal.pagememory.persistence.WriteDirtyPage;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointMetricsTracker;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointPagesWriter;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgressImpl;
import org.apache.ignite.internal.util.IgniteConcurrentMultiPairQueue;

public class CheckpointPagesWriterFactory {
    private final IgniteLogger log;
    private final ThreadLocal<ByteBuffer> threadBuf;
    private final WriteDirtyPage dirtyPageWriter;
    private final PageIoRegistry ioRegistry;
    private final PartitionMetaManager partitionMetaManager;

    CheckpointPagesWriterFactory(IgniteLogger log, WriteDirtyPage dirtyPageWriter, PageIoRegistry ioRegistry, PartitionMetaManager partitionMetaManager, int pageSize) {
        this.log = log;
        this.dirtyPageWriter = dirtyPageWriter;
        this.ioRegistry = ioRegistry;
        this.partitionMetaManager = partitionMetaManager;
        this.threadBuf = ThreadLocal.withInitial(() -> {
            ByteBuffer tmpWriteBuf = ByteBuffer.allocateDirect(pageSize);
            tmpWriteBuf.order(ByteOrder.nativeOrder());
            return tmpWriteBuf;
        });
    }

    CheckpointPagesWriter build(CheckpointMetricsTracker tracker, IgniteConcurrentMultiPairQueue<PersistentPageMemory, FullPageId> dirtyPageIdQueue, ConcurrentMap<GroupPartitionId, LongAdder> updatedPartitions, CompletableFuture<?> doneWriteFut, Runnable updateHeartbeat, CheckpointProgressImpl checkpointProgress, BooleanSupplier shutdownNow) {
        return new CheckpointPagesWriter(this.log, tracker, dirtyPageIdQueue, updatedPartitions, doneWriteFut, updateHeartbeat, this.threadBuf, checkpointProgress, this.dirtyPageWriter, this.ioRegistry, this.partitionMetaManager, shutdownNow);
    }
}

