/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.index;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.internal.index.ColumnCollation;
import org.apache.ignite.internal.index.IndexDescriptor;
import org.jetbrains.annotations.Nullable;

public class SortedIndexDescriptor
extends IndexDescriptor {
    private final Map<String, ColumnCollation> collations;

    public SortedIndexDescriptor(String name, List<String> columns, List<ColumnCollation> collations) {
        super(name, columns);
        Objects.requireNonNull(collations, "collations");
        if (collations.size() != columns.size()) {
            throw new IllegalArgumentException("Both collection of columns and collations should have the same size");
        }
        HashMap<String, ColumnCollation> tmp = new HashMap<String, ColumnCollation>();
        for (int i = 0; i < this.columns().size(); ++i) {
            ColumnCollation prev = tmp.putIfAbsent(this.columns().get(i), collations.get(i));
            assert (prev == null);
        }
        this.collations = Map.copyOf(tmp);
    }

    @Nullable
    public ColumnCollation collation(String columnName) {
        return this.collations.get(columnName);
    }
}

