/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.util.AnyNodeConfigurationVisitor;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.configuration.util.KeysTrackingConfigurationVisitor;
import org.apache.ignite.internal.configuration.validation.MemberKey;
import org.apache.ignite.internal.configuration.validation.ValidationContextImpl;
import org.apache.ignite.lang.IgniteInternalException;
import org.jetbrains.annotations.Nullable;

public class ValidationUtil {
    public static List<ValidationIssue> validate(final SuperRoot oldRoots, final SuperRoot newRoots, final Function<RootKey<?, ?>, InnerNode> otherRoots, final Map<MemberKey, Annotation[]> memberAnnotationsCache, final Map<Class<? extends Annotation>, Set<Validator<?, ?>>> validators) {
        final ArrayList<ValidationIssue> issues = new ArrayList<ValidationIssue>();
        newRoots.traverseChildren(new KeysTrackingConfigurationVisitor<Object>(){

            @Override
            protected Object doVisitInnerNode(String key, final InnerNode innerNode) {
                assert (innerNode != null);
                innerNode.traverseChildren(new AnyNodeConfigurationVisitor<Void>(){

                    @Override
                    protected Void visitNode(String key, Object node) {
                        this.validate(innerNode, key, node);
                        return null;
                    }
                }, true);
                return super.doVisitInnerNode(key, innerNode);
            }

            private void validate(InnerNode lastInnerNode, String fieldName, Object val) {
                if (val == null) {
                    String message = "'" + this.currentKey() + fieldName + "' configuration value is not initialized.";
                    issues.add(new ValidationIssue(this.currentKey(), message));
                    return;
                }
                MemberKey memberKey = new MemberKey(lastInnerNode.schemaType(), fieldName);
                Annotation[] fieldAnnotations = memberAnnotationsCache.computeIfAbsent(memberKey, k -> {
                    try {
                        Field field = ValidationUtil.findSchemaField(lastInnerNode, fieldName);
                        assert (field != null) : memberKey;
                        return field.getDeclaredAnnotations();
                    }
                    catch (Exception e) {
                        throw new IgniteInternalException((Throwable)e);
                    }
                });
                if (fieldAnnotations.length == 0) {
                    return;
                }
                String currentKey = this.currentKey() + fieldName;
                List<String> currentPath = ConfigurationUtil.appendKey(this.currentPath(), fieldName);
                for (Annotation annotation : fieldAnnotations) {
                    for (Validator validator : validators.getOrDefault(annotation.annotationType(), Collections.emptySet())) {
                        assert (ValidationUtil.assertValidatorTypesCoherence(validator.getClass(), annotation.annotationType(), val)) : "Validator coherence is violated [class=" + lastInnerNode.getClass().getCanonicalName() + ", field=" + fieldName + ", annotation=" + annotation.annotationType().getCanonicalName() + ", validator=" + validator.getClass().getName() + "]";
                        ValidationContextImpl<Object> ctx = new ValidationContextImpl<Object>(oldRoots, newRoots, otherRoots, val, currentKey, currentPath, issues);
                        validator.validate(annotation, ctx);
                    }
                }
            }
        }, true);
        return issues;
    }

    private static boolean assertValidatorTypesCoherence(Class<?> validatorClass, Class<? extends Annotation> annotationType, Object val) {
        if (!Arrays.asList(validatorClass.getInterfaces()).contains(Validator.class)) {
            return ValidationUtil.assertValidatorTypesCoherence(validatorClass.getSuperclass(), annotationType, val);
        }
        Type genericSuperClass = Arrays.stream(validatorClass.getGenericInterfaces()).filter(i -> i instanceof ParameterizedType && ((ParameterizedType)i).getRawType() == Validator.class).findAny().get();
        if (!(genericSuperClass instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedSuperClass = (ParameterizedType)genericSuperClass;
        Type[] actualTypeParameters = parameterizedSuperClass.getActualTypeArguments();
        if (actualTypeParameters.length != 2) {
            return false;
        }
        if (actualTypeParameters[0] != annotationType) {
            return false;
        }
        Type sndParam = actualTypeParameters[1];
        if (sndParam instanceof ParameterizedType) {
            sndParam = ((ParameterizedType)sndParam).getRawType();
        }
        return sndParam instanceof Class && (val == null || ((Class)sndParam).isInstance(val));
    }

    @Nullable
    private static Field findSchemaField(InnerNode innerNode, String schemaFieldName) throws NoSuchFieldException {
        Class<?> schemaType = innerNode.schemaType();
        if (innerNode.isPolymorphic() || innerNode.extendsAbstractConfiguration()) {
            for (Field field : schemaType.getDeclaredFields()) {
                if (!field.getName().equals(schemaFieldName)) continue;
                return field;
            }
            schemaType = schemaType.getSuperclass();
        } else if (innerNode.internalSchemaTypes() != null) {
            for (Class<?> internalSchemaType : innerNode.internalSchemaTypes()) {
                for (Field field : internalSchemaType.getDeclaredFields()) {
                    if (!field.getName().equals(schemaFieldName)) continue;
                    return field;
                }
            }
        }
        return schemaType.getDeclaredField(schemaFieldName);
    }
}

