/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.common.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.ignite.lang.ByteArray;
import org.apache.ignite.raft.client.ReadCommand;
import org.jetbrains.annotations.NotNull;

public final class GetAllCommand
implements ReadCommand {
    @NotNull
    private final List<byte[]> keys;
    private long revUpperBound;

    public GetAllCommand(@NotNull Set<ByteArray> keys) {
        assert (!keys.isEmpty());
        this.keys = new ArrayList<byte[]>(keys.size());
        for (ByteArray key : keys) {
            this.keys.add(key.bytes());
        }
    }

    public GetAllCommand(@NotNull Set<ByteArray> keys, long revUpperBound) {
        this(keys);
        assert (revUpperBound > 0L);
        this.revUpperBound = revUpperBound;
    }

    @NotNull
    public List<byte[]> keys() {
        return this.keys;
    }

    public long revision() {
        return this.revUpperBound;
    }
}

