/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.snapshot.local;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.option.SnapshotCopierOptions;
import org.apache.ignite.raft.jraft.storage.SnapshotStorage;
import org.apache.ignite.raft.jraft.storage.SnapshotThrottle;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotCopier;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotReader;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotWriter;
import org.apache.ignite.raft.jraft.storage.snapshot.local.LocalSnapshotCopier;
import org.apache.ignite.raft.jraft.storage.snapshot.local.LocalSnapshotReader;
import org.apache.ignite.raft.jraft.storage.snapshot.local.LocalSnapshotWriter;
import org.apache.ignite.raft.jraft.util.Endpoint;
import org.apache.ignite.raft.jraft.util.Requires;
import org.apache.ignite.raft.jraft.util.Utils;

public class LocalSnapshotStorage
implements SnapshotStorage {
    private static final IgniteLogger LOG = Loggers.forClass(LocalSnapshotStorage.class);
    private static final String TEMP_PATH = "temp";
    private final ConcurrentMap<Long, AtomicInteger> refMap = new ConcurrentHashMap<Long, AtomicInteger>();
    private final String path;
    private Endpoint addr;
    private boolean filterBeforeCopyRemote;
    private long lastSnapshotIndex;
    private final Lock lock;
    private final RaftOptions raftOptions;
    private SnapshotThrottle snapshotThrottle;

    @Override
    public void setSnapshotThrottle(SnapshotThrottle snapshotThrottle) {
        this.snapshotThrottle = snapshotThrottle;
    }

    public boolean hasServerAddr() {
        return this.addr != null;
    }

    public void setServerAddr(Endpoint addr) {
        this.addr = addr;
    }

    public LocalSnapshotStorage(String path, RaftOptions raftOptions) {
        this.path = path;
        this.lastSnapshotIndex = 0L;
        this.raftOptions = raftOptions;
        this.lock = new ReentrantLock();
    }

    public long getLastSnapshotIndex() {
        this.lock.lock();
        try {
            long l = this.lastSnapshotIndex;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean init(Void v) {
        Path tempSnapshotPath;
        File dir = new File(this.path);
        if (!Utils.mkdir(dir)) {
            LOG.error("Fail to create directory {}.", new Object[]{this.path});
            return false;
        }
        if (!this.filterBeforeCopyRemote && !IgniteUtils.deleteIfExists((Path)(tempSnapshotPath = Paths.get(this.path, TEMP_PATH)))) {
            LOG.error("Fail to delete temp snapshot path {}.", new Object[]{tempSnapshotPath});
            return false;
        }
        ArrayList<Long> snapshots = new ArrayList<Long>();
        File[] oldFiles = dir.listFiles();
        if (oldFiles != null) {
            for (File sFile : oldFiles) {
                String name = sFile.getName();
                if (!name.startsWith("snapshot_")) continue;
                long index = Long.parseLong(name.substring("snapshot_".length()));
                snapshots.add(index);
            }
        }
        if (!snapshots.isEmpty()) {
            Collections.sort(snapshots);
            int snapshotCount = snapshots.size();
            for (int i = 0; i < snapshotCount - 1; ++i) {
                long index = (Long)snapshots.get(i);
                String snapshotPath = this.getSnapshotPath(index);
                if (this.destroySnapshot(snapshotPath)) continue;
                return false;
            }
            this.lastSnapshotIndex = (Long)snapshots.get(snapshotCount - 1);
            this.ref(this.lastSnapshotIndex);
        }
        return true;
    }

    private String getSnapshotPath(long index) {
        return this.path + File.separator + "snapshot_" + index;
    }

    void ref(long index) {
        AtomicInteger refs = this.getRefs(index);
        refs.incrementAndGet();
    }

    private boolean destroySnapshot(String path) {
        LOG.info("Deleting snapshot {}.", new Object[]{path});
        Path file = Paths.get(path, new String[0]);
        if (!IgniteUtils.deleteIfExists((Path)file)) {
            LOG.error("Fail to destroy snapshot {}.", new Object[]{path});
            return false;
        }
        return true;
    }

    void unref(long index) {
        AtomicInteger refs = this.getRefs(index);
        if (refs.decrementAndGet() == 0 && this.refMap.remove(index, refs)) {
            this.destroySnapshot(this.getSnapshotPath(index));
        }
    }

    AtomicInteger getRefs(long index) {
        AtomicInteger refs = (AtomicInteger)this.refMap.get(index);
        if (refs == null) {
            refs = new AtomicInteger(0);
            AtomicInteger eRefs = this.refMap.putIfAbsent(index, refs);
            if (eRefs != null) {
                refs = eRefs;
            }
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(LocalSnapshotWriter writer, boolean keepDataOnError) throws IOException {
        IOException ioe;
        int ret;
        block18: {
            ret = writer.getCode();
            ioe = null;
            if (ret == 0) {
                long newIndex;
                block16: {
                    try {
                        if (!writer.sync()) {
                            ret = RaftError.EIO.getNumber();
                        }
                        break block16;
                    }
                    catch (IOException e) {
                        LOG.error("Fail to sync writer {}.", new Object[]{writer.getPath()});
                        ret = RaftError.EIO.getNumber();
                        ioe = e;
                    }
                    break block18;
                }
                long oldIndex = this.getLastSnapshotIndex();
                if (oldIndex == (newIndex = writer.getSnapshotIndex())) {
                    ret = RaftError.EEXISTS.getNumber();
                } else {
                    String tempPath = this.path + File.separator + TEMP_PATH;
                    String newPath = this.getSnapshotPath(newIndex);
                    if (!this.destroySnapshot(newPath)) {
                        LOG.warn("Delete new snapshot path failed, path is {}.", new Object[]{newPath});
                        ret = RaftError.EIO.getNumber();
                        ioe = new IOException("Fail to delete new snapshot path: " + newPath);
                    } else {
                        LOG.info("Renaming {} to {}.", new Object[]{tempPath, newPath});
                        if (!new File(tempPath).renameTo(new File(newPath))) {
                            LOG.error("Renamed temp snapshot failed, from path {} to path {}.", new Object[]{tempPath, newPath});
                            ret = RaftError.EIO.getNumber();
                            ioe = new IOException("Fail to rename temp snapshot from: " + tempPath + " to: " + newPath);
                        } else {
                            this.ref(newIndex);
                            this.lock.lock();
                            try {
                                Requires.requireTrue(oldIndex == this.lastSnapshotIndex);
                                this.lastSnapshotIndex = newIndex;
                            }
                            finally {
                                this.lock.unlock();
                            }
                            this.unref(oldIndex);
                        }
                    }
                }
            }
        }
        if (ret != 0) {
            LOG.warn("Close snapshot writer {} with exit code: {}.", new Object[]{writer.getPath(), ret});
            if (!keepDataOnError) {
                this.destroySnapshot(writer.getPath());
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean setFilterBeforeCopyRemote() {
        this.filterBeforeCopyRemote = true;
        return true;
    }

    @Override
    public SnapshotWriter create() {
        return this.create(true);
    }

    public SnapshotWriter create(boolean fromEmpty) {
        LocalSnapshotWriter writer;
        block0: {
            writer = null;
            String snapshotPath = this.path + File.separator + TEMP_PATH;
            if (new File(snapshotPath).exists() && fromEmpty && !this.destroySnapshot(snapshotPath) || (writer = new LocalSnapshotWriter(snapshotPath, this, this.raftOptions)).init(null)) break block0;
            LOG.error("Fail to init snapshot writer.", new Object[0]);
            writer = null;
        }
        return writer;
    }

    @Override
    public SnapshotReader open() {
        long lsIndex = 0L;
        this.lock.lock();
        try {
            if (this.lastSnapshotIndex != 0L) {
                lsIndex = this.lastSnapshotIndex;
                this.ref(lsIndex);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (lsIndex == 0L) {
            LOG.warn("No data for snapshot reader {}.", new Object[]{this.path});
            return null;
        }
        String snapshotPath = this.getSnapshotPath(lsIndex);
        LocalSnapshotReader reader = new LocalSnapshotReader(this, this.snapshotThrottle, this.addr, this.raftOptions, snapshotPath);
        if (!reader.init(null)) {
            LOG.error("Fail to init reader for path {}.", new Object[]{snapshotPath});
            this.unref(lsIndex);
            return null;
        }
        return reader;
    }

    @Override
    public SnapshotReader copyFrom(String uri, SnapshotCopierOptions opts) {
        SnapshotCopier copier = this.startToCopyFrom(uri, opts);
        if (copier == null) {
            return null;
        }
        try {
            copier.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Join on snapshot copier was interrupted.", new Object[0]);
            return null;
        }
        SnapshotReader reader = copier.getReader();
        Utils.closeQuietly(copier);
        return reader;
    }

    @Override
    public SnapshotCopier startToCopyFrom(String uri, SnapshotCopierOptions opts) {
        LocalSnapshotCopier copier = new LocalSnapshotCopier();
        copier.setStorage(this);
        copier.setSnapshotThrottle(this.snapshotThrottle);
        copier.setFilterBeforeCopyRemote(this.filterBeforeCopyRemote);
        if (!copier.init(uri, opts)) {
            LOG.error("Fail to init copier to {}.", new Object[]{uri});
            return null;
        }
        copier.start();
        return copier;
    }
}

