/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.util;

import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagememory.util.PageLockListener;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

public interface PageHandler<X, R> {
    public static final PageHandler<Void, Boolean> NO_OP;

    public R run(int var1, long var2, long var4, long var6, PageIo var8, X var9, int var10, IoStatisticsHolder var11) throws IgniteInternalCheckedException;

    default public boolean releaseAfterWrite(int groupId, long pageId, long page, long pageAddr, X arg, int intArg) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X, R> R readPage(PageMemory pageMem, int groupId, long pageId, PageLockListener lsnr, PageHandler<X, R> h, X arg, int intArg, R lockFailed, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        long page = pageMem.acquirePage(groupId, pageId, statHolder);
        try {
            R r = PageHandler.readPage(pageMem, groupId, pageId, page, lsnr, h, arg, intArg, lockFailed, statHolder);
            return r;
        }
        finally {
            pageMem.releasePage(groupId, pageId, page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X, R> R readPage(PageMemory pageMem, int groupId, long pageId, long page, PageLockListener lsnr, PageHandler<X, R> h, X arg, int intArg, R lockFailed, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        long pageAddr = 0L;
        try {
            pageAddr = PageHandler.readLock(pageMem, groupId, pageId, page, lsnr);
            if (pageAddr == 0L) {
                R r = lockFailed;
                return r;
            }
            Object io = pageMem.ioRegistry().resolve(pageAddr);
            R r = h.run(groupId, pageId, page, pageAddr, (PageIo)io, arg, intArg, statHolder);
            return r;
        }
        finally {
            if (pageAddr != 0L) {
                PageHandler.readUnlock(pageMem, groupId, pageId, page, pageAddr, lsnr);
            }
        }
    }

    public static long readLock(PageMemory pageMem, int groupId, long pageId, long page, PageLockListener lsnr) {
        lsnr.onBeforeReadLock(groupId, pageId, page);
        long pageAddr = pageMem.readLock(groupId, pageId, page);
        lsnr.onReadLock(groupId, pageId, page, pageAddr);
        return pageAddr;
    }

    public static void readUnlock(PageMemory pageMem, int groupId, long pageId, long page, long pageAddr, PageLockListener lsnr) {
        lsnr.onReadUnlock(groupId, pageId, page, pageAddr);
        pageMem.readUnlock(groupId, pageId, page);
    }

    public static void initPage(PageMemory pageMem, int groupId, long pageId, PageIo init, PageLockListener lsnr, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        Boolean res = PageHandler.writePage(pageMem, groupId, pageId, lsnr, NO_OP, init, null, 0, Boolean.FALSE, statHolder);
        if (!1.$assertionsDisabled && res == Boolean.FALSE) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X, R> R writePage(PageMemory pageMem, int groupId, long pageId, PageLockListener lsnr, PageHandler<X, R> h, @Nullable PageIo init, X arg, int intArg, R lockFailed, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        boolean releaseAfterWrite = true;
        long page = pageMem.acquirePage(groupId, pageId, statHolder);
        try {
            R r;
            long pageAddr = PageHandler.writeLock(pageMem, groupId, pageId, page, lsnr, false);
            if (pageAddr == 0L) {
                R r2 = lockFailed;
                return r2;
            }
            boolean ok = false;
            try {
                if (init != null) {
                    PageHandler.doInitPage(pageMem, groupId, pageId, pageAddr, init);
                } else {
                    init = pageMem.ioRegistry().resolve(pageAddr);
                }
                R res = h.run(groupId, pageId, page, pageAddr, init, arg, intArg, statHolder);
                ok = true;
                r = res;
            }
            catch (Throwable throwable) {
                if (!1.$assertionsDisabled && PageIo.getCrc(pageAddr) != 0) {
                    throw new AssertionError();
                }
                releaseAfterWrite = h.releaseAfterWrite(groupId, pageId, page, pageAddr, arg, intArg);
                if (releaseAfterWrite) {
                    PageHandler.writeUnlock(pageMem, groupId, pageId, page, pageAddr, lsnr, ok);
                }
                throw throwable;
            }
            if (!1.$assertionsDisabled && PageIo.getCrc(pageAddr) != 0) {
                throw new AssertionError();
            }
            releaseAfterWrite = h.releaseAfterWrite(groupId, pageId, page, pageAddr, arg, intArg);
            if (releaseAfterWrite) {
                PageHandler.writeUnlock(pageMem, groupId, pageId, page, pageAddr, lsnr, ok);
            }
            return r;
        }
        finally {
            if (releaseAfterWrite) {
                pageMem.releasePage(groupId, pageId, page);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X, R> R writePage(PageMemory pageMem, int groupId, long pageId, long page, PageLockListener lsnr, PageHandler<X, R> h, PageIo init, X arg, int intArg, R lockFailed, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        long pageAddr = PageHandler.writeLock(pageMem, groupId, pageId, page, lsnr, false);
        if (pageAddr == 0L) {
            return lockFailed;
        }
        boolean ok = false;
        try {
            if (init != null) {
                PageHandler.doInitPage(pageMem, groupId, pageId, pageAddr, init);
            } else {
                init = pageMem.ioRegistry().resolve(pageAddr);
            }
            R res = h.run(groupId, pageId, page, pageAddr, init, arg, intArg, statHolder);
            ok = true;
            R r = res;
            return r;
        }
        finally {
            if (!1.$assertionsDisabled && PageIo.getCrc(pageAddr) != 0) {
                throw new AssertionError();
            }
            if (h.releaseAfterWrite(groupId, pageId, page, pageAddr, arg, intArg)) {
                PageHandler.writeUnlock(pageMem, groupId, pageId, page, pageAddr, lsnr, ok);
            }
        }
    }

    public static long writeLock(PageMemory pageMem, int groupId, long pageId, long page, PageLockListener lsnr, boolean tryLock) {
        lsnr.onBeforeWriteLock(groupId, pageId, page);
        long pageAddr = tryLock ? pageMem.tryWriteLock(groupId, pageId, page) : pageMem.writeLock(groupId, pageId, page);
        lsnr.onWriteLock(groupId, pageId, page, pageAddr);
        return pageAddr;
    }

    public static void writeUnlock(PageMemory pageMem, int groupId, long pageId, long page, long pageAddr, PageLockListener lsnr, boolean dirty) {
        lsnr.onWriteUnlock(groupId, pageId, page, pageAddr);
        pageMem.writeUnlock(groupId, pageId, page, dirty);
    }

    private static void doInitPage(PageMemory pageMem, int groupId, long pageId, long pageAddr, PageIo init) throws IgniteInternalCheckedException {
        if (!1.$assertionsDisabled && PageIo.getCrc(pageAddr) != 0) {
            throw new AssertionError();
        }
        init.initNewPage(pageAddr, pageId, pageMem.realPageSize(groupId));
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        NO_OP = (groupId, pageId, page, pageAddr, io, arg, intArg, statHolder) -> Boolean.TRUE;
    }
}

