/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.raft.commands;

import java.util.Objects;
import org.apache.ignite.internal.cluster.management.raft.commands.ClusterNodeMessage;
import org.apache.ignite.internal.cluster.management.raft.commands.ClusterNodeMessageBuilder;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ClusterNodeMessageImpl
implements ClusterNodeMessage {
    public static final short GROUP_TYPE = 7;
    public static final short TYPE = 60;
    @IgniteToStringInclude
    private final String host;
    @IgniteToStringInclude
    private final String id;
    @IgniteToStringInclude
    private final String name;
    @IgniteToStringInclude
    private final int port;

    private ClusterNodeMessageImpl(String host, String id, String name, int port) {
        this.host = host;
        this.id = id;
        this.name = name;
        this.port = port;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int port() {
        return this.port;
    }

    public short groupType() {
        return 7;
    }

    public String toString() {
        return S.toString(ClusterNodeMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 60;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClusterNodeMessageImpl otherMessage = (ClusterNodeMessageImpl)other;
        return Objects.equals(this.host, otherMessage.host) && Objects.equals(this.id, otherMessage.id) && Objects.equals(this.name, otherMessage.name) && this.port == otherMessage.port;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.port, this.host, this.id, this.name);
        return result;
    }

    public static ClusterNodeMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements ClusterNodeMessageBuilder {
        private String host;
        private String id;
        private String name;
        private int port;

        private Builder() {
        }

        @Override
        public ClusterNodeMessageBuilder host(String host) {
            this.host = host;
            return this;
        }

        @Override
        public ClusterNodeMessageBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public ClusterNodeMessageBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public ClusterNodeMessageBuilder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public String host() {
            return this.host;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public int port() {
            return this.port;
        }

        @Override
        public ClusterNodeMessage build() {
            return new ClusterNodeMessageImpl(this.host, this.id, this.name, this.port);
        }
    }
}

