/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.descriptors.ConsistencyMode;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CreateTableEventParameters;
import org.apache.ignite.internal.catalog.events.DropTableEventParameters;
import org.apache.ignite.internal.catalog.events.RenameTableEventParameters;
import org.apache.ignite.internal.causality.CompletionListener;
import org.apache.ignite.internal.causality.IncrementalVersionedValue;
import org.apache.ignite.internal.causality.RevisionListenerRegistry;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.components.LogSyncer;
import org.apache.ignite.internal.configuration.SystemDistributedConfiguration;
import org.apache.ignite.internal.configuration.utils.SystemDistributedConfigurationPropertyHolder;
import org.apache.ignite.internal.distributionzones.DistributionZoneManager;
import org.apache.ignite.internal.distributionzones.rebalance.PartitionMover;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceRaftGroupEventsListener;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.lowwatermark.event.ChangeLowWatermarkEventParameters;
import org.apache.ignite.internal.lowwatermark.event.LowWatermarkEvent;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.marshaller.MarshallersProvider;
import org.apache.ignite.internal.marshaller.ReflectionMarshallersProvider;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.Revisions;
import org.apache.ignite.internal.metastorage.WatchEvent;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.metastorage.dsl.SimpleCondition;
import org.apache.ignite.internal.network.ClusterNodeResolver;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.network.serialization.MessageSerializationRegistry;
import org.apache.ignite.internal.partition.replicator.LocalPartitionReplicaEvent;
import org.apache.ignite.internal.partition.replicator.LocalPartitionReplicaEventParameters;
import org.apache.ignite.internal.partition.replicator.PartitionReplicaLifecycleManager;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.replication.ChangePeersAndLearnersAsyncReplicaRequest;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.partitiondistribution.AssignmentsChain;
import org.apache.ignite.internal.partitiondistribution.PartitionDistributionUtils;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.ReplicaMeta;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEvent;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEventParameters;
import org.apache.ignite.internal.raft.ExecutorInclinedRaftCommandRunner;
import org.apache.ignite.internal.raft.PeersAndLearners;
import org.apache.ignite.internal.raft.RaftGroupEventsListener;
import org.apache.ignite.internal.raft.service.RaftCommandRunner;
import org.apache.ignite.internal.raft.service.RaftGroupListener;
import org.apache.ignite.internal.raft.service.RaftGroupService;
import org.apache.ignite.internal.raft.storage.SnapshotStorageFactory;
import org.apache.ignite.internal.replicator.Replica;
import org.apache.ignite.internal.replicator.ReplicaManager;
import org.apache.ignite.internal.replicator.ReplicaService;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.replicator.listener.ReplicaListener;
import org.apache.ignite.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.internal.schema.SchemaManager;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.SchemaSyncService;
import org.apache.ignite.internal.schema.configuration.GcConfiguration;
import org.apache.ignite.internal.schema.configuration.StorageUpdateConfiguration;
import org.apache.ignite.internal.storage.DataStorageManager;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.engine.MvTableStorage;
import org.apache.ignite.internal.storage.engine.StorageEngine;
import org.apache.ignite.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptorSupplier;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.LongPriorityQueue;
import org.apache.ignite.internal.table.StreamerReceiverRunner;
import org.apache.ignite.internal.table.TableImpl;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.table.distributed.BitSetPartitionSet;
import org.apache.ignite.internal.table.distributed.CatalogStorageIndexDescriptorSupplier;
import org.apache.ignite.internal.table.distributed.DroppedTableInfo;
import org.apache.ignite.internal.table.distributed.PartitionReplicatorNodeRecovery;
import org.apache.ignite.internal.table.distributed.PartitionSet;
import org.apache.ignite.internal.table.distributed.PartitionUpdateHandlers;
import org.apache.ignite.internal.table.distributed.StorageUpdateHandler;
import org.apache.ignite.internal.table.distributed.TableIndexStoragesSupplier;
import org.apache.ignite.internal.table.distributed.TableSchemaAwareIndexStorage;
import org.apache.ignite.internal.table.distributed.TableUtils;
import org.apache.ignite.internal.table.distributed.gc.GcUpdateHandler;
import org.apache.ignite.internal.table.distributed.gc.MvGc;
import org.apache.ignite.internal.table.distributed.index.IndexMetaStorage;
import org.apache.ignite.internal.table.distributed.index.IndexUpdateHandler;
import org.apache.ignite.internal.table.distributed.index.IndexUtils;
import org.apache.ignite.internal.table.distributed.raft.MinimumRequiredTimeCollectorService;
import org.apache.ignite.internal.table.distributed.raft.PartitionDataStorage;
import org.apache.ignite.internal.table.distributed.raft.PartitionListener;
import org.apache.ignite.internal.table.distributed.raft.snapshot.FullStateTransferIndexChooser;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionAccessImpl;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionKey;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionSnapshotStorageFactory;
import org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing.OutgoingSnapshotsManager;
import org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing.SnapshotAwarePartitionDataStorage;
import org.apache.ignite.internal.table.distributed.replicator.PartitionReplicaListener;
import org.apache.ignite.internal.table.distributed.replicator.TransactionStateResolver;
import org.apache.ignite.internal.table.distributed.schema.CatalogValidationSchemasSource;
import org.apache.ignite.internal.table.distributed.schema.ExecutorInclinedSchemaSyncService;
import org.apache.ignite.internal.table.distributed.schema.SchemaVersions;
import org.apache.ignite.internal.table.distributed.schema.SchemaVersionsImpl;
import org.apache.ignite.internal.table.distributed.storage.InternalTableImpl;
import org.apache.ignite.internal.table.distributed.storage.NullStorageEngine;
import org.apache.ignite.internal.table.distributed.storage.PartitionStorages;
import org.apache.ignite.internal.table.distributed.wrappers.ExecutorInclinedPlacementDriver;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.tx.LockManager;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.configuration.TransactionConfiguration;
import org.apache.ignite.internal.tx.impl.RemotelyTriggeredResourceRegistry;
import org.apache.ignite.internal.tx.impl.TransactionInflights;
import org.apache.ignite.internal.tx.impl.TxMessageSender;
import org.apache.ignite.internal.tx.storage.state.ThreadAssertingTxStateTableStorage;
import org.apache.ignite.internal.tx.storage.state.TxStateStorage;
import org.apache.ignite.internal.tx.storage.state.TxStateTableStorage;
import org.apache.ignite.internal.tx.storage.state.rocksdb.TxStateRocksDbSharedStorage;
import org.apache.ignite.internal.tx.storage.state.rocksdb.TxStateRocksDbTableStorage;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.Lazy;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.apache.ignite.internal.util.SafeTimeValuesTracker;
import org.apache.ignite.internal.utils.RebalanceUtilEx;
import org.apache.ignite.internal.worker.ThreadAssertions;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.table.Table;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TableManager
implements IgniteTablesInternal,
IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(TableManager.class);
    private static final String TX_STATE_DIR = "tx-state";
    private static final int TX_STATE_STORAGE_FLUSH_DELAY = 100;
    private static final IntSupplier TX_STATE_STORAGE_FLUSH_DELAY_SUPPLIER = () -> 100;
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private static final PartitionReplicationMessagesFactory TABLE_MESSAGES_FACTORY = new PartitionReplicationMessagesFactory();
    private final TopologyService topologyService;
    private final ReplicaManager replicaMgr;
    private final LockManager lockMgr;
    private final ReplicaService replicaSvc;
    private final TxManager txManager;
    private final MetaStorageManager metaStorageMgr;
    private final DataStorageManager dataStorageMgr;
    private final TransactionStateResolver transactionStateResolver;
    private final IncrementalVersionedValue<Void> tablesVv;
    private final IncrementalVersionedValue<Void> localPartitionsVv;
    private final IncrementalVersionedValue<Void> assignmentsUpdatedVv;
    private final Map<Integer, TableImpl> tables = new ConcurrentHashMap<Integer, TableImpl>();
    private final Map<Integer, TableImpl> startedTables = new ConcurrentHashMap<Integer, TableImpl>();
    private final LongPriorityQueue<DestroyTableEvent> destructionEventsQueue = new LongPriorityQueue<DestroyTableEvent>(DestroyTableEvent::catalogVersion);
    private final Map<Integer, PartitionSet> localPartsByTableId = new ConcurrentHashMap<Integer, PartitionSet>();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean beforeStopGuard = new AtomicBoolean();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final SchemaManager schemaManager;
    private final TxStateRocksDbSharedStorage sharedTxStateStorage;
    private final ExecutorService scanRequestExecutor;
    private final ExecutorService ioExecutor;
    private final ClockService clockService;
    private final OutgoingSnapshotsManager outgoingSnapshotsManager;
    private final DistributionZoneManager distributionZoneManager;
    private final SchemaSyncService executorInclinedSchemaSyncService;
    private final CatalogService catalogService;
    private final ExecutorService incomingSnapshotsExecutor;
    private final WatchListener pendingAssignmentsRebalanceListener;
    private final WatchListener stableAssignmentsRebalanceListener;
    private final WatchListener assignmentsSwitchRebalanceListener;
    private final MvGc mvGc;
    private final LowWatermark lowWatermark;
    private final HybridTimestampTracker observableTimestampTracker;
    private final PlacementDriver executorInclinedPlacementDriver;
    private final Supplier<IgniteSql> sql;
    private final SchemaVersions schemaVersions;
    private final PartitionReplicatorNodeRecovery partitionReplicatorNodeRecovery;
    private final IncrementalVersionedValue<Void> startVv;
    private final CompletableFuture<Void> stopManagerFuture = new CompletableFuture();
    private final StorageUpdateConfiguration storageUpdateConfig;
    private final Executor partitionOperationsExecutor;
    private final ScheduledExecutorService rebalanceScheduler;
    private final ReflectionMarshallersProvider marshallers = new ReflectionMarshallersProvider();
    private final FullStateTransferIndexChooser fullStateTransferIndexChooser;
    private final RemotelyTriggeredResourceRegistry remotelyTriggeredResourceRegistry;
    private final TransactionInflights transactionInflights;
    private final TransactionConfiguration txCfg;
    private final String nodeName;
    private final PartitionReplicaLifecycleManager partitionReplicaLifecycleManager;
    private long implicitTransactionTimeout;
    private int attemptsObtainLock;
    @Nullable
    private ScheduledExecutorService streamerFlushExecutor;
    private final IndexMetaStorage indexMetaStorage;
    private final Predicate<Assignment> isLocalNodeAssignment = assignment -> assignment.consistentId().equals(this.localNode().name());
    private final MinimumRequiredTimeCollectorService minTimeCollectorService;
    @Nullable
    private StreamerReceiverRunner streamerReceiverRunner;
    private final CompletableFuture<Void> readyToProcessTableStarts = new CompletableFuture();
    private final Map<Integer, Set<TableImpl>> tablesPerZone = new ConcurrentHashMap<Integer, Set<TableImpl>>();
    private final CompletableFuture<Void> recoveryFuture = new CompletableFuture();
    private final SystemDistributedConfigurationPropertyHolder<Integer> rebalanceRetryDelayConfiguration;

    public TableManager(String nodeName, RevisionListenerRegistry registry, GcConfiguration gcConfig, TransactionConfiguration txCfg, StorageUpdateConfiguration storageUpdateConfig, MessagingService messagingService, TopologyService topologyService, MessageSerializationRegistry messageSerializationRegistry, ReplicaManager replicaMgr, LockManager lockMgr, ReplicaService replicaSvc, TxManager txManager, DataStorageManager dataStorageMgr, Path storagePath, MetaStorageManager metaStorageMgr, SchemaManager schemaManager, ExecutorService ioExecutor, Executor partitionOperationsExecutor, ScheduledExecutorService rebalanceScheduler, ScheduledExecutorService commonScheduler, ClockService clockService, OutgoingSnapshotsManager outgoingSnapshotsManager, DistributionZoneManager distributionZoneManager, SchemaSyncService schemaSyncService, CatalogService catalogService, HybridTimestampTracker observableTimestampTracker, PlacementDriver placementDriver, Supplier<IgniteSql> sql, RemotelyTriggeredResourceRegistry remotelyTriggeredResourceRegistry, LowWatermark lowWatermark, TransactionInflights transactionInflights, IndexMetaStorage indexMetaStorage, LogSyncer logSyncer, PartitionReplicaLifecycleManager partitionReplicaLifecycleManager, MinimumRequiredTimeCollectorService minTimeCollectorService, SystemDistributedConfiguration systemDistributedConfiguration) {
        this.topologyService = topologyService;
        this.replicaMgr = replicaMgr;
        this.lockMgr = lockMgr;
        this.replicaSvc = replicaSvc;
        this.txManager = txManager;
        this.dataStorageMgr = dataStorageMgr;
        this.metaStorageMgr = metaStorageMgr;
        this.schemaManager = schemaManager;
        this.ioExecutor = ioExecutor;
        this.partitionOperationsExecutor = partitionOperationsExecutor;
        this.rebalanceScheduler = rebalanceScheduler;
        this.clockService = clockService;
        this.outgoingSnapshotsManager = outgoingSnapshotsManager;
        this.distributionZoneManager = distributionZoneManager;
        this.catalogService = catalogService;
        this.observableTimestampTracker = observableTimestampTracker;
        this.sql = sql;
        this.storageUpdateConfig = storageUpdateConfig;
        this.remotelyTriggeredResourceRegistry = remotelyTriggeredResourceRegistry;
        this.lowWatermark = lowWatermark;
        this.transactionInflights = transactionInflights;
        this.txCfg = txCfg;
        this.nodeName = nodeName;
        this.indexMetaStorage = indexMetaStorage;
        this.partitionReplicaLifecycleManager = partitionReplicaLifecycleManager;
        this.minTimeCollectorService = minTimeCollectorService;
        this.executorInclinedSchemaSyncService = new ExecutorInclinedSchemaSyncService(schemaSyncService, partitionOperationsExecutor);
        this.executorInclinedPlacementDriver = new ExecutorInclinedPlacementDriver(placementDriver, partitionOperationsExecutor);
        TxMessageSender txMessageSender = new TxMessageSender(messagingService, replicaSvc, clockService, txCfg);
        this.transactionStateResolver = new TransactionStateResolver(txManager, clockService, (ClusterNodeResolver)topologyService, messagingService, this.executorInclinedPlacementDriver, txMessageSender);
        this.schemaVersions = new SchemaVersionsImpl(this.executorInclinedSchemaSyncService, catalogService, clockService);
        this.tablesVv = new IncrementalVersionedValue(registry);
        this.localPartitionsVv = new IncrementalVersionedValue(IncrementalVersionedValue.dependingOn(this.tablesVv));
        this.assignmentsUpdatedVv = new IncrementalVersionedValue(IncrementalVersionedValue.dependingOn(this.localPartitionsVv));
        this.scanRequestExecutor = Executors.newSingleThreadExecutor(IgniteThreadFactory.create((String)nodeName, (String)"scan-query-executor", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[]{ThreadOperation.STORAGE_READ}));
        int cpus = Runtime.getRuntime().availableProcessors();
        this.incomingSnapshotsExecutor = new ThreadPoolExecutor(cpus, cpus, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), IgniteThreadFactory.create((String)nodeName, (String)"incoming-raft-snapshot", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[]{ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE}));
        this.pendingAssignmentsRebalanceListener = this.createPendingAssignmentsRebalanceListener();
        this.stableAssignmentsRebalanceListener = this.createStableAssignmentsRebalanceListener();
        this.assignmentsSwitchRebalanceListener = this.createAssignmentsSwitchRebalanceListener();
        this.mvGc = new MvGc(nodeName, gcConfig, lowWatermark);
        this.partitionReplicatorNodeRecovery = new PartitionReplicatorNodeRecovery(metaStorageMgr, messagingService, topologyService, partitionOperationsExecutor, tableId -> this.tablesById().get(tableId));
        this.startVv = new IncrementalVersionedValue(registry);
        this.sharedTxStateStorage = new TxStateRocksDbSharedStorage(storagePath.resolve(TX_STATE_DIR), commonScheduler, ioExecutor, logSyncer, TX_STATE_STORAGE_FLUSH_DELAY_SUPPLIER);
        this.fullStateTransferIndexChooser = new FullStateTransferIndexChooser(catalogService, lowWatermark, indexMetaStorage);
        partitionReplicaLifecycleManager.listen((Event)LocalPartitionReplicaEvent.AFTER_REPLICA_STARTED, this::onZoneReplicaCreated);
        partitionReplicaLifecycleManager.listen((Event)LocalPartitionReplicaEvent.AFTER_REPLICA_STOPPED, this::onZoneReplicaStopped);
        this.rebalanceRetryDelayConfiguration = new SystemDistributedConfigurationPropertyHolder(systemDistributedConfiguration, (v, r) -> {}, "rebalanceRetryDelay", (Object)200, Integer::parseInt);
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            this.mvGc.start();
            this.transactionStateResolver.start();
            this.fullStateTransferIndexChooser.start();
            CompletableFuture recoveryFinishFuture = this.metaStorageMgr.recoveryFinishedFuture();
            assert (recoveryFinishFuture.isDone());
            this.rebalanceRetryDelayConfiguration.init();
            long recoveryRevision = ((Revisions)recoveryFinishFuture.join()).revision();
            this.cleanUpResourcesForDroppedTablesOnRecoveryBusy();
            this.sharedTxStateStorage.start();
            this.readyToProcessTableStarts.complete(null);
            this.startTables(recoveryRevision, this.lowWatermark.getLowWatermark());
            this.processAssignmentsOnRecovery(recoveryRevision);
            this.metaStorageMgr.registerPrefixWatch(new ByteArray(RebalanceUtil.PENDING_ASSIGNMENTS_PREFIX_BYTES), this.pendingAssignmentsRebalanceListener);
            this.metaStorageMgr.registerPrefixWatch(new ByteArray(RebalanceUtil.STABLE_ASSIGNMENTS_PREFIX_BYTES), this.stableAssignmentsRebalanceListener);
            this.metaStorageMgr.registerPrefixWatch(new ByteArray(RebalanceUtil.ASSIGNMENTS_SWITCH_REDUCE_PREFIX_BYTES), this.assignmentsSwitchRebalanceListener);
            this.catalogService.listen((Event)CatalogEvent.TABLE_CREATE, parameters -> this.onTableCreate((CreateTableEventParameters)parameters));
            this.catalogService.listen((Event)CatalogEvent.TABLE_CREATE, parameters -> this.prepareTableResourcesAndLoadToZoneReplica((CreateTableEventParameters)parameters));
            this.catalogService.listen((Event)CatalogEvent.TABLE_DROP, EventListener.fromConsumer(this::onTableDrop));
            this.catalogService.listen((Event)CatalogEvent.TABLE_ALTER, parameters -> {
                if (parameters instanceof RenameTableEventParameters) {
                    return this.onTableRename((RenameTableEventParameters)parameters).thenApply(unused -> false);
                }
                return CompletableFutures.falseCompletedFuture();
            });
            this.lowWatermark.listen((Event)LowWatermarkEvent.LOW_WATERMARK_CHANGED, parameters -> this.onLwmChanged((ChangeLowWatermarkEventParameters)parameters));
            this.partitionReplicatorNodeRecovery.start();
            this.implicitTransactionTimeout = (Long)this.txCfg.implicitTransactionTimeout().value();
            this.attemptsObtainLock = (Integer)this.txCfg.attemptsObtainLock().value();
            this.executorInclinedPlacementDriver.listen((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_EXPIRED, this::onPrimaryReplicaExpired);
            return CompletableFutures.nullCompletedFuture();
        });
    }

    @TestOnly
    public CompletableFuture<Void> recoveryFuture() {
        return this.recoveryFuture;
    }

    private CompletableFuture<Void> waitForMetadataCompleteness(long ts) {
        return this.executorInclinedSchemaSyncService.waitForMetadataCompleteness(HybridTimestamp.hybridTimestamp((long)ts));
    }

    private CompletableFuture<Boolean> onZoneReplicaCreated(LocalPartitionReplicaEventParameters parameters) {
        if (!PartitionReplicaLifecycleManager.ENABLED) {
            return CompletableFuture.completedFuture(false);
        }
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            ArrayList futs = new ArrayList();
            this.readyToProcessTableStarts.thenRun(() -> {
                Set<TableImpl> zoneTables = this.zoneTables(parameters.zonePartitionId().zoneId());
                PartitionSet singlePartitionIdSet = PartitionSet.of(parameters.zonePartitionId().partitionId());
                zoneTables.forEach(tbl -> futs.add(((CompletableFuture)IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> CompletableFuture.supplyAsync(() -> this.getOrCreatePartitionStorages((TableImpl)tbl, singlePartitionIdSet), this.ioExecutor)).thenCompose(Function.identity())).thenRunAsync(() -> IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                    this.lowWatermark.getLowWatermarkSafe(lwm -> IndexUtils.registerIndexesToTable(tbl, this.catalogService, singlePartitionIdSet, tbl.schemaView(), lwm));
                    this.preparePartitionResourcesAndLoadToZoneReplica((TableImpl)tbl, parameters.zonePartitionId().partitionId(), parameters.zonePartitionId().zoneId());
                }), this.ioExecutor)));
            });
            return CompletableFuture.allOf(futs.toArray(new CompletableFuture[0])).thenApply(unused -> false);
        });
    }

    private CompletableFuture<Boolean> onZoneReplicaStopped(LocalPartitionReplicaEventParameters parameters) {
        if (!PartitionReplicaLifecycleManager.ENABLED) {
            return CompletableFuture.completedFuture(false);
        }
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> CompletableFuture.supplyAsync(() -> {
            ArrayList futs = new ArrayList();
            Set<TableImpl> zoneTables = this.zoneTables(parameters.zonePartitionId().zoneId());
            zoneTables.forEach(table -> {
                TableManager.closePartitionTrackers(table.internalTable(), parameters.zonePartitionId().partitionId());
                TablePartitionId tablePartitionId = new TablePartitionId(table.tableId(), parameters.zonePartitionId().partitionId());
                this.mvGc.removeStorage(tablePartitionId);
                futs.add(this.destroyPartitionStorages(tablePartitionId, (TableImpl)table));
            });
            return CompletableFuture.allOf(futs.toArray(new CompletableFuture[0]));
        }, this.ioExecutor).thenCompose(Function.identity())).thenApply(unused -> false);
    }

    private CompletableFuture<Boolean> prepareTableResourcesAndLoadToZoneReplica(CreateTableEventParameters parameters) {
        if (!PartitionReplicaLifecycleManager.ENABLED) {
            return CompletableFuture.completedFuture(false);
        }
        long causalityToken = parameters.causalityToken();
        CatalogTableDescriptor tableDescriptor = parameters.tableDescriptor();
        CatalogZoneDescriptor zoneDescriptor = this.getZoneDescriptor(tableDescriptor, parameters.catalogVersion());
        return this.prepareTableResourcesAndLoadToZoneReplica(causalityToken, zoneDescriptor, tableDescriptor, false);
    }

    private CompletableFuture<Boolean> prepareTableResourcesAndLoadToZoneReplica(long causalityToken, CatalogZoneDescriptor zoneDescriptor, CatalogTableDescriptor tableDescriptor, boolean onNodeRecovery) {
        TableImpl table = this.createTableImpl(causalityToken, tableDescriptor, zoneDescriptor);
        int tableId = tableDescriptor.id();
        this.tablesVv.update(causalityToken, (ignore, e) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            if (e != null) {
                return CompletableFuture.failedFuture(e);
            }
            return this.schemaManager.schemaRegistry(causalityToken, tableId).thenAccept(table::schemaView);
        }));
        long stamp = this.partitionReplicaLifecycleManager.lockZoneForRead(zoneDescriptor.id());
        CompletableFuture localPartsUpdateFuture = this.localPartitionsVv.update(causalityToken, (ignore, throwable) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> CompletableFuture.supplyAsync(() -> {
            BitSetPartitionSet parts = new BitSetPartitionSet();
            for (int i = 0; i < zoneDescriptor.partitions(); ++i) {
                if (!this.partitionReplicaLifecycleManager.hasLocalPartition(new ZonePartitionId(zoneDescriptor.id(), i))) continue;
                parts.set(i);
            }
            return this.getOrCreatePartitionStorages(table, parts).thenRun(() -> this.localPartsByTableId.put(tableId, parts));
        }, this.ioExecutor).thenCompose(Function.identity())));
        CompletableFuture tablesByIdFuture = this.tablesVv.get(causalityToken);
        CompletableFuture createPartsFut = this.assignmentsUpdatedVv.update(causalityToken, (token, e) -> {
            if (e != null) {
                return CompletableFuture.failedFuture(e);
            }
            return CompletableFuture.allOf(localPartsUpdateFuture, tablesByIdFuture).thenRunAsync(() -> IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                if (onNodeRecovery) {
                    SchemaRegistry schemaRegistry = table.schemaView();
                    PartitionSet partitionSet = this.localPartsByTableId.get(tableId);
                    HybridTimestamp lwm = this.lowWatermark.getLowWatermark();
                    IndexUtils.registerIndexesToTable(table, this.catalogService, partitionSet, schemaRegistry, lwm);
                }
                for (int i = 0; i < zoneDescriptor.partitions(); ++i) {
                    if (!this.partitionReplicaLifecycleManager.hasLocalPartition(new ZonePartitionId(zoneDescriptor.id(), i))) continue;
                    this.preparePartitionResourcesAndLoadToZoneReplica(table, i, zoneDescriptor.id());
                }
            }), this.ioExecutor);
        });
        this.tables.put(tableId, table);
        return ((CompletableFuture)((CompletableFuture)createPartsFut.thenAccept(ignore -> this.startedTables.put(tableId, table))).whenComplete((v, th) -> {
            this.partitionReplicaLifecycleManager.unlockZoneForRead(zoneDescriptor.id(), stamp);
            if (th == null) {
                this.addTableToZone(zoneDescriptor.id(), table);
            }
        })).thenApply(unused -> false);
    }

    private void preparePartitionResourcesAndLoadToZoneReplica(TableImpl table, int partId, int zoneId) {
        int tableId = table.tableId();
        InternalTableImpl internalTbl = (InternalTableImpl)table.internalTable();
        TablePartitionId replicaGrpId = new TablePartitionId(tableId, partId);
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            PendingComparableValuesTracker safeTimeTracker = new PendingComparableValuesTracker((Comparable)HybridTimestamp.MIN_VALUE);
            PendingComparableValuesTracker storageIndexTracker = new PendingComparableValuesTracker((Comparable)Long.valueOf(0L));
            PartitionStorages partitionStorages = TableManager.getPartitionStorages(table, partId);
            PartitionDataStorage partitionDataStorage = this.partitionDataStorage(partitionStorages.getMvPartitionStorage(), internalTbl, partId);
            storageIndexTracker.update((Comparable)Long.valueOf(partitionDataStorage.lastAppliedIndex()), null);
            PartitionUpdateHandlers partitionUpdateHandlers = TableManager.createPartitionUpdateHandlers(partId, partitionDataStorage, table, (PendingComparableValuesTracker<HybridTimestamp, Void>)safeTimeTracker, this.storageUpdateConfig);
            internalTbl.updatePartitionTrackers(partId, (PendingComparableValuesTracker<HybridTimestamp, Void>)safeTimeTracker, (PendingComparableValuesTracker<Long, Void>)storageIndexTracker);
            this.mvGc.addStorage(replicaGrpId, partitionUpdateHandlers.gcUpdateHandler);
            Function<RaftCommandRunner, ReplicaListener> createListener = raftClient -> this.createReplicaListener(replicaGrpId, table, (PendingComparableValuesTracker<HybridTimestamp, Void>)safeTimeTracker, partitionStorages.getMvPartitionStorage(), partitionStorages.getTxStateStorage(), partitionUpdateHandlers, (RaftCommandRunner)raftClient);
            this.partitionReplicaLifecycleManager.loadTableListenerToZoneReplica(new ZonePartitionId(zoneId, partId), new TablePartitionId(tableId, partId), createListener);
        });
    }

    private CompletableFuture<Boolean> onPrimaryReplicaExpired(PrimaryReplicaEventParameters parameters) {
        if (this.topologyService.localMember().id().equals(parameters.leaseholderId())) {
            TablePartitionId groupId = (TablePartitionId)parameters.groupId();
            this.replicaMgr.weakStopReplica((ReplicationGroupId)groupId, ReplicaManager.WeakReplicaStopReason.PRIMARY_EXPIRED, () -> this.stopAndDestroyPartition(groupId, this.tablesVv.latestCausalityToken()));
        }
        return CompletableFutures.falseCompletedFuture();
    }

    private void processAssignmentsOnRecovery(long recoveryRevision) {
        ByteArray stableAssignmentsPrefix = new ByteArray(RebalanceUtil.STABLE_ASSIGNMENTS_PREFIX_BYTES);
        ByteArray pendingAssignmentsPrefix = new ByteArray(RebalanceUtil.PENDING_ASSIGNMENTS_PREFIX_BYTES);
        this.startVv.update(recoveryRevision, (v, e) -> this.handleAssignmentsOnRecovery(stableAssignmentsPrefix, recoveryRevision, (entry, rev) -> this.handleChangeStableAssignmentEvent((Entry)entry, (long)rev, true), "stable"));
        this.startVv.update(recoveryRevision, (v, e) -> this.handleAssignmentsOnRecovery(pendingAssignmentsPrefix, recoveryRevision, (entry, rev) -> this.handleChangePendingAssignmentEvent((Entry)entry, (long)rev, true), "pending")).whenComplete((v, th) -> {
            if (th != null) {
                this.recoveryFuture.completeExceptionally((Throwable)th);
            } else {
                this.recoveryFuture.complete(null);
            }
        });
    }

    private CompletableFuture<Void> handleAssignmentsOnRecovery(ByteArray prefix, long revision, BiFunction<Entry, Long, CompletableFuture<Void>> assignmentsEventHandler, String assignmentsType) {
        try (Cursor cursor = this.metaStorageMgr.prefixLocally(prefix, revision);){
            CompletableFuture[] futures = (CompletableFuture[])cursor.stream().map(entry -> {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Non handled {} assignments for key '{}' discovered, performing recovery", new Object[]{assignmentsType, new String(entry.key(), StandardCharsets.UTF_8)});
                }
                return (CompletableFuture)assignmentsEventHandler.apply((Entry)entry, revision);
            }).toArray(CompletableFuture[]::new);
            CompletionStage completionStage = CompletableFuture.allOf(futures).exceptionally(e -> {
                LOG.error("Error when performing assignments recovery", e);
                return null;
            });
            return completionStage;
        }
    }

    private CompletableFuture<Boolean> onTableCreate(CreateTableEventParameters parameters) {
        return this.createTableLocally(parameters.causalityToken(), parameters.catalogVersion(), parameters.tableDescriptor(), false).thenApply(unused -> false);
    }

    public CompletableFuture<List<Assignments>> writeTableAssignmentsToMetastore(int tableId, ConsistencyMode consistencyMode, CompletableFuture<List<Assignments>> assignmentsFuture) {
        return assignmentsFuture.thenCompose(newAssignments -> {
            assert (!newAssignments.isEmpty());
            boolean haMode = consistencyMode == ConsistencyMode.HIGH_AVAILABILITY;
            ArrayList<Operation> partitionAssignments = new ArrayList<Operation>(newAssignments.size());
            for (int i = 0; i < newAssignments.size(); ++i) {
                TablePartitionId tablePartitionId = new TablePartitionId(tableId, i);
                ByteArray stableAssignmentsKey = RebalanceUtil.stablePartAssignmentsKey((TablePartitionId)tablePartitionId);
                byte[] anAssignment = ((Assignments)newAssignments.get(i)).toBytes();
                Operation op = Operations.put((ByteArray)stableAssignmentsKey, (byte[])anAssignment);
                partitionAssignments.add(op);
                if (!haMode) continue;
                ByteArray assignmentsChainKey = RebalanceUtil.assignmentsChainKey((TablePartitionId)tablePartitionId);
                byte[] assignmentChain = AssignmentsChain.of((Assignments)((Assignments)newAssignments.get(i))).toBytes();
                Operation chainOp = Operations.put((ByteArray)assignmentsChainKey, (byte[])assignmentChain);
                partitionAssignments.add(chainOp);
            }
            SimpleCondition condition = Conditions.notExists((ByteArray)new ByteArray(ByteUtils.toByteArray((ByteBuffer)((Operation)partitionAssignments.get(0)).key())));
            return ((CompletableFuture)((CompletableFuture)this.metaStorageMgr.invoke((Condition)condition, partitionAssignments, Collections.emptyList()).whenComplete((invokeResult, e) -> {
                if (e != null) {
                    LOG.error("Couldn't write assignments [assignmentsList={}] to metastore during invoke.", e, new Object[]{Assignments.assignmentListToString((List)newAssignments)});
                }
            })).thenCompose(invokeResult -> {
                if (invokeResult.booleanValue()) {
                    LOG.info("Assignments calculated from data nodes are successfully written to meta storage [tableId={}, assignments={}].", new Object[]{tableId, Assignments.assignmentListToString((List)newAssignments)});
                    return CompletableFuture.completedFuture(newAssignments);
                }
                Set partKeys = IntStream.range(0, newAssignments.size()).mapToObj(p -> RebalanceUtil.stablePartAssignmentsKey((TablePartitionId)new TablePartitionId(tableId, p))).collect(Collectors.toSet());
                CompletableFuture resFuture = this.metaStorageMgr.getAll(partKeys);
                return resFuture.thenApply(metaStorageAssignments -> {
                    ArrayList<Assignments> realAssignments = new ArrayList<Assignments>();
                    for (int p = 0; p < newAssignments.size(); ++p) {
                        TablePartitionId partId = new TablePartitionId(tableId, p);
                        Entry assignmentsEntry = (Entry)metaStorageAssignments.get(RebalanceUtil.stablePartAssignmentsKey((TablePartitionId)partId));
                        assert (assignmentsEntry != null && !assignmentsEntry.empty() && !assignmentsEntry.tombstone()) : "Unexpected assignments for partition [" + String.valueOf(partId) + ", entry=" + String.valueOf(assignmentsEntry) + "].";
                        Assignments real = Assignments.fromBytes((byte[])assignmentsEntry.value());
                        realAssignments.add(real);
                    }
                    LOG.info("Assignments picked up from meta storage [tableId={}, assignments={}].", new Object[]{tableId, Assignments.assignmentListToString(realAssignments)});
                    return realAssignments;
                });
            })).whenComplete((realAssignments, e) -> {
                if (e != null) {
                    LOG.error("Couldn't get assignments from metastore for table [tableId={}].", e, new Object[]{tableId});
                }
            });
        });
    }

    private void onTableDrop(DropTableEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.destructionEventsQueue.enqueue(new DestroyTableEvent(parameters.catalogVersion(), parameters.tableId())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Boolean> onLwmChanged(ChangeLowWatermarkEventParameters parameters) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFutures.falseCompletedFuture();
        }
        try {
            int newEarliestCatalogVersion = this.catalogService.activeCatalogVersion(parameters.newLowWatermark().longValue());
            List futures = this.destructionEventsQueue.drainUpTo(newEarliestCatalogVersion).stream().map(event -> this.destroyTableLocally(event.tableId())).collect(Collectors.toList());
            CompletionStage completionStage = CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenApply(unused -> false);
            return completionStage;
        }
        catch (Throwable t) {
            CompletableFuture<Boolean> completableFuture = CompletableFuture.failedFuture(t);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private CompletableFuture<?> onTableRename(RenameTableEventParameters parameters) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> this.tablesVv.update(parameters.causalityToken(), (ignore, e) -> {
            if (e != null) {
                return CompletableFuture.failedFuture(e);
            }
            TableImpl table = this.tables.get(parameters.tableId());
            table.name(parameters.newTableName());
            return CompletableFutures.nullCompletedFuture();
        }));
    }

    private CompletableFuture<Void> startLocalPartitionsAndClients(CompletableFuture<List<Assignments>> stableAssignmentsFuture, List<@Nullable Assignments> pendingAssignmentsForPartitions, List<@Nullable AssignmentsChain> assignmentsChains, TableImpl table, boolean isRecovery, long assignmentsTimestamp) {
        int tableId = table.tableId();
        return stableAssignmentsFuture.thenCompose(stableAssignmentsForPartitions -> {
            assert (stableAssignmentsForPartitions != null) : IgniteStringFormatter.format((String)"Table [id={}] has empty assignments.", (Object[])new Object[]{tableId});
            int partitions = stableAssignmentsForPartitions.size();
            CompletableFuture[] futures = new CompletableFuture[partitions];
            for (int i = 0; i < partitions; ++i) {
                boolean shouldStartPartition;
                int partId = i;
                Assignments stableAssignments = (Assignments)stableAssignmentsForPartitions.get(i);
                Assignments pendingAssignments = (Assignments)pendingAssignmentsForPartitions.get(i);
                Assignment localMemberAssignmentInStable = this.localMemberAssignment(stableAssignments);
                if (isRecovery) {
                    AssignmentsChain assignmentsChain = (AssignmentsChain)assignmentsChains.get(i);
                    if (TableManager.lastRebalanceWasGraceful(assignmentsChain)) {
                        shouldStartPartition = localMemberAssignmentInStable != null && (pendingAssignments == null || !pendingAssignments.force());
                    } else {
                        LOG.warn("Recovery after a forced rebalance for table is not supported yet [tableId={}, partitionId={}].", new Object[]{tableId, partId});
                        shouldStartPartition = localMemberAssignmentInStable != null && (pendingAssignments == null || !pendingAssignments.force());
                    }
                } else {
                    shouldStartPartition = localMemberAssignmentInStable != null;
                }
                futures[i] = shouldStartPartition ? this.startPartitionAndStartClient(table, partId, localMemberAssignmentInStable, stableAssignments, isRecovery, assignmentsTimestamp).whenComplete((res, ex) -> {
                    if (ex != null) {
                        LOG.warn("Unable to update raft groups on the node [tableId={}, partitionId={}]", ex, new Object[]{tableId, partId});
                    }
                }) : CompletableFutures.nullCompletedFuture();
            }
            return CompletableFuture.allOf(futures);
        });
    }

    private CompletableFuture<Void> startPartitionAndStartClient(TableImpl table, int partId, Assignment localMemberAssignment, Assignments stableAssignments, boolean isRecovery, long assignmentsTimestamp) {
        int tableId = table.tableId();
        InternalTableImpl internalTbl = (InternalTableImpl)table.internalTable();
        PeersAndLearners stablePeersAndLearners = PeersAndLearners.fromAssignments((Collection)stableAssignments.nodes());
        TablePartitionId replicaGrpId = new TablePartitionId(tableId, partId);
        CompletableFuture<Boolean> shouldStartGroupFut = isRecovery ? this.partitionReplicatorNodeRecovery.initiateGroupReentryIfNeeded(replicaGrpId, internalTbl, stablePeersAndLearners, localMemberAssignment, assignmentsTimestamp) : CompletableFutures.trueCompletedFuture();
        Assignments forcedAssignments = stableAssignments.force() ? stableAssignments : null;
        Supplier<CompletableFuture> startReplicaSupplier = () -> shouldStartGroupFut.thenComposeAsync(startGroup -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            if (!startGroup.booleanValue()) {
                return CompletableFutures.falseCompletedFuture();
            }
            SafeTimeValuesTracker safeTimeTracker = new SafeTimeValuesTracker(HybridTimestamp.MIN_VALUE);
            PendingComparableValuesTracker storageIndexTracker = new PendingComparableValuesTracker((Comparable)Long.valueOf(0L));
            PartitionStorages partitionStorages = TableManager.getPartitionStorages(table, partId);
            PartitionDataStorage partitionDataStorage = this.partitionDataStorage(partitionStorages.getMvPartitionStorage(), internalTbl, partId);
            storageIndexTracker.update((Comparable)Long.valueOf(partitionDataStorage.lastAppliedIndex()), null);
            PartitionUpdateHandlers partitionUpdateHandlers = TableManager.createPartitionUpdateHandlers(partId, partitionDataStorage, table, (PendingComparableValuesTracker<HybridTimestamp, Void>)safeTimeTracker, this.storageUpdateConfig);
            internalTbl.updatePartitionTrackers(partId, (PendingComparableValuesTracker<HybridTimestamp, Void>)safeTimeTracker, (PendingComparableValuesTracker<Long, Void>)storageIndexTracker);
            this.mvGc.addStorage(replicaGrpId, partitionUpdateHandlers.gcUpdateHandler);
            PartitionListener raftGroupListener = new PartitionListener(this.txManager, partitionDataStorage, partitionUpdateHandlers.storageUpdateHandler, partitionStorages.getTxStateStorage(), safeTimeTracker, (PendingComparableValuesTracker<Long, Void>)storageIndexTracker, this.catalogService, table.schemaView(), this.indexMetaStorage, this.topologyService.localMember().id(), this.minTimeCollectorService);
            this.minTimeCollectorService.addPartition(new TablePartitionId(tableId, partId));
            SnapshotStorageFactory snapshotStorageFactory = this.createSnapshotStorageFactory(replicaGrpId, partitionUpdateHandlers, internalTbl);
            Function<RaftGroupService, ReplicaListener> createListener = raftClient -> this.createReplicaListener(replicaGrpId, table, (PendingComparableValuesTracker<HybridTimestamp, Void>)safeTimeTracker, partitionStorages.getMvPartitionStorage(), partitionStorages.getTxStateStorage(), partitionUpdateHandlers, (RaftCommandRunner)raftClient);
            RaftGroupEventsListener raftGroupEventsListener = this.createRaftGroupEventsListener(replicaGrpId);
            MvTableStorage mvTableStorage = internalTbl.storage();
            try {
                return this.replicaMgr.startReplica(raftGroupEventsListener, (RaftGroupListener)raftGroupListener, mvTableStorage.isVolatile(), snapshotStorageFactory, createListener, storageIndexTracker, (ReplicationGroupId)replicaGrpId, stablePeersAndLearners).thenApply(ignored -> true);
            }
            catch (NodeStoppingException e) {
                throw new AssertionError("Loza was stopped before Table manager", e);
            }
        }), (Executor)this.ioExecutor);
        return this.replicaMgr.weakStartReplica((ReplicationGroupId)replicaGrpId, startReplicaSupplier, forcedAssignments).handle((res, ex) -> {
            if (ex != null) {
                LOG.warn("Unable to update raft groups on the node [tableId={}, partitionId={}]", ex, new Object[]{tableId, partId});
            }
            return null;
        });
    }

    @Nullable
    private Assignment localMemberAssignment(@Nullable Assignments assignments) {
        Assignment localMemberAssignment = Assignment.forPeer((String)this.localNode().name());
        return assignments != null && assignments.nodes().contains(localMemberAssignment) ? localMemberAssignment : null;
    }

    private PartitionMover createPartitionMover(TablePartitionId replicaGrpId) {
        return new PartitionMover(this.busyLock, () -> {
            CompletableFuture replicaFut = this.replicaMgr.replica((ReplicationGroupId)replicaGrpId);
            if (replicaFut == null) {
                return CompletableFuture.failedFuture(new IgniteInternalException("No such replica for partition " + replicaGrpId.partitionId() + " in table " + replicaGrpId.tableId()));
            }
            return replicaFut.thenApply(Replica::raftClient);
        });
    }

    private RaftGroupEventsListener createRaftGroupEventsListener(TablePartitionId replicaGrpId) {
        PartitionMover partitionMover = this.createPartitionMover(replicaGrpId);
        return new RebalanceRaftGroupEventsListener(this.metaStorageMgr, replicaGrpId, this.busyLock, partitionMover, this::calculateAssignments, this.rebalanceScheduler, this.rebalanceRetryDelayConfiguration);
    }

    private PartitionReplicaListener createReplicaListener(TablePartitionId tablePartitionId, TableImpl table, PendingComparableValuesTracker<HybridTimestamp, Void> safeTimeTracker, MvPartitionStorage mvPartitionStorage, TxStateStorage txStatePartitionStorage, PartitionUpdateHandlers partitionUpdateHandlers, RaftCommandRunner raftClient) {
        int tableId = tablePartitionId.tableId();
        int partId = tablePartitionId.partitionId();
        return new PartitionReplicaListener(mvPartitionStorage, (RaftCommandRunner)new ExecutorInclinedRaftCommandRunner(raftClient, this.partitionOperationsExecutor), this.txManager, this.lockMgr, this.scanRequestExecutor, partId, tableId, table.indexesLockers(partId), (Lazy<TableSchemaAwareIndexStorage>)new Lazy(() -> table.indexStorageAdapters(partId).get().get(table.pkId())), () -> table.indexStorageAdapters(partId).get(), this.clockService, safeTimeTracker, txStatePartitionStorage, this.transactionStateResolver, partitionUpdateHandlers.storageUpdateHandler, new CatalogValidationSchemasSource(this.catalogService, this.schemaManager), this.localNode(), this.executorInclinedSchemaSyncService, this.catalogService, this.executorInclinedPlacementDriver, (ClusterNodeResolver)this.topologyService, this.remotelyTriggeredResourceRegistry, this.schemaManager.schemaRegistry(tableId), this.indexMetaStorage, this.lowWatermark);
    }

    private CompletableFuture<Set<Assignment>> calculateAssignments(TablePartitionId tablePartitionId, Long assignmentsTimestamp) {
        return this.waitForMetadataCompleteness(assignmentsTimestamp).thenCompose(unused -> {
            int catalogVersion = this.catalogService.activeCatalogVersion(assignmentsTimestamp.longValue());
            CatalogTableDescriptor tableDescriptor = this.getTableDescriptor(tablePartitionId.tableId(), catalogVersion);
            CatalogZoneDescriptor zoneDescriptor = this.getZoneDescriptor(tableDescriptor, catalogVersion);
            return this.distributionZoneManager.dataNodes(zoneDescriptor.updateToken(), catalogVersion, tableDescriptor.zoneId()).thenApply(dataNodes -> PartitionDistributionUtils.calculateAssignmentForPartition((Collection)dataNodes, (int)tablePartitionId.partitionId(), (int)zoneDescriptor.partitions(), (int)zoneDescriptor.replicas()));
        });
    }

    private boolean isLocalNodeInAssignments(Collection<Assignment> assignments) {
        return assignments.stream().anyMatch(this.isLocalNodeAssignment);
    }

    private CompletableFuture<Boolean> isLocalNodeIsPrimary(ReplicationGroupId replicationGroupId) {
        return this.isLocalNodeIsPrimary(this.getPrimaryReplica(replicationGroupId));
    }

    private CompletableFuture<Boolean> isLocalNodeIsPrimary(CompletableFuture<ReplicaMeta> primaryReplicaFuture) {
        return primaryReplicaFuture.thenApply(primaryReplicaMeta -> primaryReplicaMeta != null && primaryReplicaMeta.getLeaseholder() != null && primaryReplicaMeta.getLeaseholder().equals(this.localNode().name()));
    }

    private CompletableFuture<ReplicaMeta> getPrimaryReplica(ReplicationGroupId replicationGroupId) {
        HybridTimestamp currentSafeTime = this.metaStorageMgr.clusterTime().currentSafeTime();
        if (HybridTimestamp.MIN_VALUE.equals((Object)currentSafeTime)) {
            return CompletableFutures.nullCompletedFuture();
        }
        long skewMs = this.clockService.maxClockSkewMillis();
        try {
            HybridTimestamp previousMetastoreSafeTime = currentSafeTime.subtractPhysicalTime(skewMs);
            return this.executorInclinedPlacementDriver.getPrimaryReplica(replicationGroupId, previousMetastoreSafeTime);
        }
        catch (IllegalArgumentException e) {
            long currentSafeTimeMs = currentSafeTime.longValue();
            throw new AssertionError("Got a negative time [currentSafeTime=" + String.valueOf(currentSafeTime) + ", currentSafeTimeMs=" + currentSafeTimeMs + ", skewMs=" + skewMs + ", internal=" + (currentSafeTimeMs + (-skewMs << 16)) + "]", e);
        }
    }

    private PartitionDataStorage partitionDataStorage(MvPartitionStorage partitionStorage, InternalTable internalTbl, int partId) {
        return new SnapshotAwarePartitionDataStorage(partitionStorage, this.outgoingSnapshotsManager, TableManager.partitionKey(internalTbl, partId));
    }

    private static PartitionKey partitionKey(InternalTable internalTbl, int partId) {
        return new PartitionKey(internalTbl.tableId(), partId);
    }

    public void beforeNodeStop() {
        if (!this.beforeStopGuard.compareAndSet(false, true)) {
            return;
        }
        this.stopManagerFuture.completeExceptionally(new NodeStoppingException());
        this.busyLock.block();
        this.metaStorageMgr.unregisterWatch(this.pendingAssignmentsRebalanceListener);
        this.metaStorageMgr.unregisterWatch(this.stableAssignmentsRebalanceListener);
        this.metaStorageMgr.unregisterWatch(this.assignmentsSwitchRebalanceListener);
        this.cleanUpTablesResources(this.tables);
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        assert (this.beforeStopGuard.get()) : "'stop' called before 'beforeNodeStop'";
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        int shutdownTimeoutSeconds = 10;
        try {
            IgniteUtils.closeAllManually((ManuallyCloseable[])new ManuallyCloseable[]{this.mvGc, this.fullStateTransferIndexChooser, this.sharedTxStateStorage, () -> IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.scanRequestExecutor, (long)shutdownTimeoutSeconds, (TimeUnit)TimeUnit.SECONDS), () -> IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.incomingSnapshotsExecutor, (long)shutdownTimeoutSeconds, (TimeUnit)TimeUnit.SECONDS), () -> IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.rebalanceScheduler, (long)shutdownTimeoutSeconds, (TimeUnit)TimeUnit.SECONDS), () -> IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.streamerFlushExecutor, (long)shutdownTimeoutSeconds, (TimeUnit)TimeUnit.SECONDS)});
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    private void cleanUpTablesResources(Map<Integer, TableImpl> tables) {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(tables.size());
        for (TableImpl table : tables.values()) {
            futures.add(CompletableFuture.supplyAsync(() -> this.tableStopFuture(table), this.ioExecutor).thenCompose(Function.identity()));
        }
        try {
            CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.error("Unable to clean table resources", (Throwable)e);
        }
    }

    private CompletableFuture<Void> tableStopFuture(TableImpl table) {
        InternalTable internalTable = table.internalTable();
        CompletableFuture[] stopReplicaFutures = new CompletableFuture[internalTable.partitions()];
        for (int p = 0; p < internalTable.partitions(); ++p) {
            TablePartitionId replicationGroupId = new TablePartitionId(table.tableId(), p);
            stopReplicaFutures[p] = this.stopPartition(replicationGroupId, table);
        }
        CompletableFuture<Void> stopPartitionReplicasFuture = CompletableFuture.allOf(stopReplicaFutures).orTimeout(10L, TimeUnit.SECONDS);
        return ((CompletableFuture)stopPartitionReplicasFuture.whenCompleteAsync((res, ex) -> {
            Stream.Builder<Object> stopping = Stream.builder();
            stopping.add(internalTable.storage());
            stopping.add(internalTable.txStateStorage());
            stopping.add(internalTable);
            try {
                IgniteUtils.closeAllManually(stopping.build());
            }
            catch (Throwable e) {
                throw new CompletionException(e);
            }
        }, (Executor)this.ioExecutor)).whenComplete((res, ex) -> {
            if (ex != null) {
                LOG.error("Unable to stop table [name={}, tableId={}]", ex, new Object[]{table.name(), table.tableId()});
            }
        });
    }

    private TableImpl createTableImpl(long causalityToken, CatalogTableDescriptor tableDescriptor, CatalogZoneDescriptor zoneDescriptor) {
        String tableName = tableDescriptor.name();
        LOG.trace("Creating local table: name={}, id={}, token={}", new Object[]{tableDescriptor.name(), tableDescriptor.id(), causalityToken});
        MvTableStorage tableStorage = this.createTableStorage(tableDescriptor, zoneDescriptor);
        TxStateTableStorage txStateStorage = this.createTxStateTableStorage(tableDescriptor, zoneDescriptor);
        int partitions = zoneDescriptor.partitions();
        InternalTableImpl internalTable = new InternalTableImpl(tableName, tableDescriptor.id(), partitions, (ClusterNodeResolver)this.topologyService, this.txManager, tableStorage, txStateStorage, this.replicaSvc, this.clockService, this.observableTimestampTracker, this.executorInclinedPlacementDriver, this.transactionInflights, this.implicitTransactionTimeout, this.attemptsObtainLock, this::streamerFlushExecutor, Objects.requireNonNull(this.streamerReceiverRunner));
        return new TableImpl((InternalTable)internalTable, this.lockMgr, this.schemaVersions, (MarshallersProvider)this.marshallers, this.sql.get(), tableDescriptor.primaryKeyIndexId());
    }

    private CompletableFuture<?> createTableLocally(long causalityToken, int catalogVersion, CatalogTableDescriptor tableDescriptor, boolean onNodeRecovery) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            int tableId = tableDescriptor.id();
            CatalogZoneDescriptor zoneDescriptor = this.getZoneDescriptor(tableDescriptor, catalogVersion);
            CompletableFuture<List<Assignments>> stableAssignmentsFuture = this.getOrCreateAssignments(tableDescriptor, zoneDescriptor, causalityToken, catalogVersion);
            List pendingAssignments = RebalanceUtil.tablePendingAssignmentsGetLocally((MetaStorageManager)this.metaStorageMgr, (int)tableId, (int)zoneDescriptor.partitions(), (long)causalityToken);
            List assignmentsChains = RebalanceUtil.tableAssignmentsChainGetLocally((MetaStorageManager)this.metaStorageMgr, (int)tableId, (int)zoneDescriptor.partitions(), (long)causalityToken);
            CompletableFuture<List<Assignments>> stableAssignmentsFutureAfterInvoke = this.writeTableAssignmentsToMetastore(tableId, zoneDescriptor.consistencyMode(), stableAssignmentsFuture);
            Catalog catalog = this.catalogService.catalog(catalogVersion);
            return this.createTableLocally(causalityToken, tableDescriptor, zoneDescriptor, stableAssignmentsFutureAfterInvoke, pendingAssignments, assignmentsChains, onNodeRecovery, catalog.time());
        });
    }

    private CompletableFuture<Void> createTableLocally(long causalityToken, CatalogTableDescriptor tableDescriptor, CatalogZoneDescriptor zoneDescriptor, CompletableFuture<List<Assignments>> stableAssignmentsFuture, List<Assignments> pendingAssignments, List<AssignmentsChain> assignmentsChains, boolean onNodeRecovery, long assignmentsTimestamp) {
        TableImpl table = this.createTableImpl(causalityToken, tableDescriptor, zoneDescriptor);
        int tableId = tableDescriptor.id();
        this.tablesVv.update(causalityToken, (ignore, e) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            if (e != null) {
                return CompletableFuture.failedFuture(e);
            }
            return this.schemaManager.schemaRegistry(causalityToken, tableId).thenAccept(table::schemaView);
        }));
        CompletableFuture localPartsUpdateFuture = this.localPartitionsVv.update(causalityToken, (ignore, throwable) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> stableAssignmentsFuture.thenComposeAsync(newAssignments -> {
            BitSetPartitionSet parts = new BitSetPartitionSet();
            for (int i = 0; i < newAssignments.size(); ++i) {
                Assignments partitionAssignments = (Assignments)newAssignments.get(i);
                if (this.localMemberAssignment(partitionAssignments) == null) continue;
                parts.set(i);
            }
            return this.getOrCreatePartitionStorages(table, parts).thenRun(() -> this.localPartsByTableId.put(tableId, parts));
        }, (Executor)this.ioExecutor)));
        CompletableFuture tablesByIdFuture = this.tablesVv.get(causalityToken);
        CompletableFuture createPartsFut = this.assignmentsUpdatedVv.update(causalityToken, (token, e) -> {
            if (e != null) {
                return CompletableFuture.failedFuture(e);
            }
            return CompletableFuture.allOf(localPartsUpdateFuture, tablesByIdFuture).thenComposeAsync(ignore -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                if (onNodeRecovery) {
                    SchemaRegistry schemaRegistry = table.schemaView();
                    PartitionSet partitionSet = this.localPartsByTableId.get(tableId);
                    HybridTimestamp lwm = this.lowWatermark.getLowWatermark();
                    IndexUtils.registerIndexesToTable(table, this.catalogService, partitionSet, schemaRegistry, lwm);
                }
                return this.startLocalPartitionsAndClients(stableAssignmentsFuture, pendingAssignments, assignmentsChains, table, onNodeRecovery, assignmentsTimestamp);
            }), (Executor)this.ioExecutor);
        });
        this.tables.put(tableId, table);
        return createPartsFut.thenAccept(ignore -> this.startedTables.put(tableId, table));
    }

    private CompletableFuture<List<Assignments>> getOrCreateAssignments(CatalogTableDescriptor tableDescriptor, CatalogZoneDescriptor zoneDescriptor, long causalityToken, int catalogVersion) {
        CompletionStage<List<Object>> assignmentsFuture;
        int tableId = tableDescriptor.id();
        if (RebalanceUtil.partitionAssignmentsGetLocally((MetaStorageManager)this.metaStorageMgr, (int)tableId, (int)0, (long)causalityToken) != null) {
            assignmentsFuture = CompletableFuture.completedFuture(RebalanceUtil.tableAssignmentsGetLocally((MetaStorageManager)this.metaStorageMgr, (int)tableId, (int)zoneDescriptor.partitions(), (long)causalityToken));
        } else {
            Catalog catalog = this.catalogService.catalog(catalogVersion);
            long assignmentsTimestamp = catalog.time();
            assignmentsFuture = this.distributionZoneManager.dataNodes(causalityToken, catalogVersion, zoneDescriptor.id()).thenApply(dataNodes -> PartitionDistributionUtils.calculateAssignments((Collection)dataNodes, (int)zoneDescriptor.partitions(), (int)zoneDescriptor.replicas()).stream().map(assignments -> Assignments.of((Set)assignments, (long)assignmentsTimestamp)).collect(Collectors.toList()));
            ((CompletableFuture)assignmentsFuture).thenAccept(assignmentsList -> LOG.info("Assignments calculated from data nodes [table={}, tableId={}, assignments={}, revision={}]", new Object[]{tableDescriptor.name(), tableId, Assignments.assignmentListToString((List)assignmentsList), causalityToken}));
        }
        return assignmentsFuture;
    }

    protected MvTableStorage createTableStorage(CatalogTableDescriptor tableDescriptor, CatalogZoneDescriptor zoneDescriptor) {
        StorageEngine engine = this.dataStorageMgr.engineByStorageProfile(tableDescriptor.storageProfile());
        if (engine == null) {
            engine = new NullStorageEngine();
        }
        return engine.createMvTable(new StorageTableDescriptor(tableDescriptor.id(), zoneDescriptor.partitions(), tableDescriptor.storageProfile()), (StorageIndexDescriptorSupplier)new CatalogStorageIndexDescriptorSupplier(this.catalogService, this.lowWatermark));
    }

    protected TxStateTableStorage createTxStateTableStorage(CatalogTableDescriptor tableDescriptor, CatalogZoneDescriptor zoneDescriptor) {
        int tableId = tableDescriptor.id();
        TxStateRocksDbTableStorage txStateTableStorage = new TxStateRocksDbTableStorage(tableId, zoneDescriptor.partitions(), this.sharedTxStateStorage);
        if (ThreadAssertions.enabled()) {
            txStateTableStorage = new ThreadAssertingTxStateTableStorage((TxStateTableStorage)txStateTableStorage);
        }
        txStateTableStorage.start();
        return txStateTableStorage;
    }

    private CompletableFuture<Void> destroyTableLocally(int tableId) {
        TableImpl table = this.startedTables.remove(tableId);
        this.localPartsByTableId.remove(tableId);
        assert (table != null) : tableId;
        InternalTable internalTable = table.internalTable();
        int partitions = internalTable.partitions();
        Set assignmentKeys = IntStream.range(0, partitions).mapToObj(p -> RebalanceUtil.stablePartAssignmentsKey((TablePartitionId)new TablePartitionId(tableId, p))).collect(Collectors.toSet());
        this.metaStorageMgr.removeAll(assignmentKeys);
        CompletableFuture[] stopReplicaAndDestroyFutures = new CompletableFuture[partitions];
        for (int partitionId = 0; partitionId < partitions; ++partitionId) {
            TablePartitionId replicationGroupId = new TablePartitionId(tableId, partitionId);
            stopReplicaAndDestroyFutures[partitionId] = this.stopAndDestroyPartition(replicationGroupId, table);
        }
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(stopReplicaAndDestroyFutures).thenComposeAsync(unused -> IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> CompletableFuture.allOf(internalTable.storage().destroy(), CompletableFuture.runAsync(() -> IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> internalTable.txStateStorage().destroy()), this.ioExecutor))), (Executor)this.ioExecutor)).thenAccept(ignore0 -> this.tables.remove(tableId))).thenAcceptAsync(ignore0 -> this.schemaManager.dropRegistryAsync(tableId), (Executor)this.ioExecutor);
    }

    public List<Table> tables() {
        return TableManager.join(this.tablesAsync());
    }

    public CompletableFuture<List<Table>> tablesAsync() {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, this::tablesAsyncInternalBusy);
    }

    private CompletableFuture<List<Table>> tablesAsyncInternalBusy() {
        HybridTimestamp now = this.clockService.now();
        return this.orStopManagerFuture(this.executorInclinedSchemaSyncService.waitForMetadataCompleteness(now)).thenCompose(unused -> IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            int catalogVersion = this.catalogService.activeCatalogVersion(now.longValue());
            Collection tableDescriptors = this.catalogService.tables(catalogVersion);
            if (tableDescriptors.isEmpty()) {
                return CompletableFutures.emptyListCompletedFuture();
            }
            CompletableFuture[] tableImplFutures = (CompletableFuture[])tableDescriptors.stream().map(tableDescriptor -> this.tableAsyncInternalBusy(tableDescriptor.id())).toArray(CompletableFuture[]::new);
            return CompletableFutures.allOfToList((CompletableFuture[])tableImplFutures);
        }));
    }

    private CompletableFuture<Map<Integer, TableImpl>> tablesById(long causalityToken) {
        return this.assignmentsUpdatedVv.get(causalityToken).thenApply(v -> Collections.unmodifiableMap(this.startedTables));
    }

    private Map<Integer, TableImpl> tablesById() {
        return Collections.unmodifiableMap(this.tables);
    }

    @TestOnly
    public Map<Integer, TableImpl> startedTables() {
        return Collections.unmodifiableMap(this.startedTables);
    }

    public Table table(String name) {
        return TableManager.join(this.tableAsync(name));
    }

    @Override
    public TableViewInternal table(int id) throws NodeStoppingException {
        return TableManager.join(this.tableAsync(id));
    }

    public CompletableFuture<Table> tableAsync(String name) {
        return this.tableAsyncInternal(IgniteNameUtils.parseSimpleName((String)name)).thenApply(Function.identity());
    }

    public CompletableFuture<TableViewInternal> tableAsync(long causalityToken, int id) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> this.tablesById(causalityToken).thenApply(tablesById -> (TableViewInternal)tablesById.get(id)));
    }

    @Override
    public CompletableFuture<TableViewInternal> tableAsync(int tableId) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            HybridTimestamp now = this.clockService.now();
            return this.orStopManagerFuture(this.executorInclinedSchemaSyncService.waitForMetadataCompleteness(now)).thenCompose(unused -> IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
                int catalogVersion = this.catalogService.activeCatalogVersion(now.longValue());
                if (this.catalogService.table(tableId, catalogVersion) == null) {
                    return CompletableFutures.nullCompletedFuture();
                }
                return this.tableAsyncInternalBusy(tableId);
            }));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<PartitionSet> localPartitionSetAsync(long causalityToken, int tableId) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.localPartitionsVv.get(causalityToken).thenApply(unused -> this.localPartsByTableId.get(tableId));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public TableViewInternal tableView(String name) {
        return TableManager.join(this.tableViewAsync(name));
    }

    @Override
    public CompletableFuture<TableViewInternal> tableViewAsync(String name) {
        return this.tableAsyncInternal(IgniteNameUtils.parseSimpleName((String)name));
    }

    private CompletableFuture<TableViewInternal> tableAsyncInternal(String name) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            HybridTimestamp now = this.clockService.now();
            return this.orStopManagerFuture(this.executorInclinedSchemaSyncService.waitForMetadataCompleteness(now)).thenCompose(unused -> IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
                CatalogTableDescriptor tableDescriptor = this.catalogService.table(name, now.longValue());
                if (tableDescriptor == null) {
                    return CompletableFutures.nullCompletedFuture();
                }
                return this.tableAsyncInternalBusy(tableDescriptor.id());
            }));
        });
    }

    private CompletableFuture<TableViewInternal> tableAsyncInternalBusy(int tableId) {
        TableImpl tableImpl = this.startedTables.get(tableId);
        if (tableImpl != null) {
            return CompletableFuture.completedFuture(tableImpl);
        }
        CompletableFuture getLatestTableFuture = new CompletableFuture();
        CompletionListener tablesListener = (token, v, th) -> {
            if (th == null) {
                CompletableFuture tablesFuture = this.tablesVv.get(token);
                tablesFuture.whenComplete((tables, e) -> {
                    if (e != null) {
                        getLatestTableFuture.completeExceptionally((Throwable)e);
                    } else {
                        getLatestTableFuture.complete((TableViewInternal)this.startedTables.get(tableId));
                    }
                });
            } else {
                getLatestTableFuture.completeExceptionally(th);
            }
        };
        this.assignmentsUpdatedVv.whenComplete(tablesListener);
        tableImpl = this.startedTables.get(tableId);
        if (tableImpl != null) {
            this.assignmentsUpdatedVv.removeWhenComplete(tablesListener);
            return CompletableFuture.completedFuture(tableImpl);
        }
        return this.orStopManagerFuture(getLatestTableFuture).whenComplete((unused, throwable) -> this.assignmentsUpdatedVv.removeWhenComplete(tablesListener));
    }

    private static <T> T join(CompletableFuture<T> future) {
        try {
            return future.join();
        }
        catch (CompletionException ex) {
            throw TableManager.convertThrowable(ex.getCause());
        }
    }

    private static RuntimeException convertThrowable(Throwable th) {
        if (th instanceof RuntimeException) {
            return (RuntimeException)th;
        }
        return new IgniteException(ErrorGroups.Common.INTERNAL_ERR, th);
    }

    private WatchListener createPendingAssignmentsRebalanceListener() {
        return evt -> {
            if (!this.busyLock.enterBusy()) {
                return CompletableFuture.failedFuture(new NodeStoppingException());
            }
            try {
                Entry newEntry = evt.entryEvent().newEntry();
                CompletableFuture<Void> completableFuture = this.handleChangePendingAssignmentEvent(newEntry, evt.revision(), false);
                return completableFuture;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        };
    }

    private CompletableFuture<Void> handleChangePendingAssignmentEvent(Entry pendingAssignmentsEntry, long revision, boolean isRecovery) {
        if (pendingAssignmentsEntry.value() == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        TablePartitionId replicaGrpId = RebalanceUtil.extractTablePartitionId((byte[])pendingAssignmentsEntry.key(), (byte[])RebalanceUtil.PENDING_ASSIGNMENTS_PREFIX_BYTES);
        Assignments stableAssignments = RebalanceUtil.stableAssignmentsGetLocally((MetaStorageManager)this.metaStorageMgr, (TablePartitionId)replicaGrpId, (long)revision);
        AssignmentsChain assignmentsChain = RebalanceUtil.assignmentsChainGetLocally((MetaStorageManager)this.metaStorageMgr, (TablePartitionId)replicaGrpId, (long)revision);
        Assignments pendingAssignments = Assignments.fromBytes((byte[])pendingAssignmentsEntry.value());
        return ((CompletableFuture)this.tablesVv.get(revision).thenApply(ignore -> {
            if (!this.busyLock.enterBusy()) {
                return CompletableFuture.failedFuture(new NodeStoppingException());
            }
            try {
                TableImpl table = this.tables.get(replicaGrpId.tableId());
                if (table == null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Skipping Pending Assignments update, because table {} does not exist", new Object[]{replicaGrpId.tableId()});
                    }
                    CompletableFuture completableFuture = CompletableFutures.nullCompletedFuture();
                    return completableFuture;
                }
                if (LOG.isInfoEnabled()) {
                    String stringKey = new String(pendingAssignmentsEntry.key(), StandardCharsets.UTF_8);
                    LOG.info("Received update on pending assignments. Check if new raft group should be started [key={}, partition={}, table={}, localMemberAddress={}, pendingAssignments={}, revision={}]", new Object[]{stringKey, replicaGrpId.partitionId(), table.name(), this.localNode().address(), pendingAssignments, revision});
                }
                CompletionStage completionStage = this.handleChangePendingAssignmentEvent(replicaGrpId, table, stableAssignments, pendingAssignments, assignmentsChain, revision, isRecovery).thenAccept(v -> this.executeIfLocalNodeIsPrimaryForGroup((ReplicationGroupId)replicaGrpId, replicaMeta -> this.sendChangePeersAndLearnersRequest((ReplicaMeta)replicaMeta, replicaGrpId, pendingAssignments, revision)));
                return completionStage;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        })).thenCompose(Function.identity());
    }

    private CompletableFuture<Void> handleChangePendingAssignmentEvent(TablePartitionId replicaGrpId, TableImpl tbl, @Nullable Assignments stableAssignments, Assignments pendingAssignments, @Nullable AssignmentsChain assignmentsChain, long revision, boolean isRecovery) {
        CompletionStage<Void> localServicesStartFuture;
        boolean shouldStartLocalGroupNode;
        boolean pendingAssignmentsAreForced = pendingAssignments.force();
        Set pendingAssignmentsNodes = pendingAssignments.nodes();
        long assignmentsTimestamp = pendingAssignments.timestamp();
        Assignment localMemberAssignmentInPending = this.localMemberAssignment(pendingAssignments);
        Assignment localMemberAssignmentInStable = this.localMemberAssignment(stableAssignments);
        if (isRecovery) {
            if (TableManager.lastRebalanceWasGraceful(assignmentsChain)) {
                shouldStartLocalGroupNode = localMemberAssignmentInPending != null;
            } else {
                LOG.warn("Recovery after a forced rebalance for table is not supported yet [tablePartitionId={}].", new Object[]{replicaGrpId});
                shouldStartLocalGroupNode = localMemberAssignmentInPending != null;
            }
        } else {
            boolean bl = shouldStartLocalGroupNode = localMemberAssignmentInPending != null && localMemberAssignmentInStable == null;
        }
        Assignments computedStableAssignments = stableAssignments == null || stableAssignments.nodes().isEmpty() ? Assignments.forced((Set)pendingAssignmentsNodes, (long)assignmentsTimestamp) : (pendingAssignmentsAreForced ? pendingAssignments : stableAssignments);
        int partitionId = replicaGrpId.partitionId();
        if (shouldStartLocalGroupNode) {
            PartitionSet singlePartitionIdSet = PartitionSet.of(partitionId);
            localServicesStartFuture = ((CompletableFuture)this.localPartitionsVv.get(revision).thenComposeAsync(unused -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.getOrCreatePartitionStorages(tbl, singlePartitionIdSet).thenRun(() -> this.localPartsByTableId.compute(replicaGrpId.tableId(), (tableId, oldPartitionSet) -> TableManager.extendPartitionSet(oldPartitionSet, partitionId)))), (Executor)this.ioExecutor)).thenComposeAsync(unused -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                this.lowWatermark.getLowWatermarkSafe(lwm -> IndexUtils.registerIndexesToTable(tbl, this.catalogService, singlePartitionIdSet, tbl.schemaView(), lwm));
                return this.waitForMetadataCompleteness(assignmentsTimestamp).thenCompose(ignored -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                    assert (localMemberAssignmentInPending != null) : "Local member assignment";
                    return this.startPartitionAndStartClient(tbl, replicaGrpId.partitionId(), localMemberAssignmentInPending, computedStableAssignments, isRecovery, assignmentsTimestamp);
                }));
            }), (Executor)this.ioExecutor);
        } else {
            localServicesStartFuture = pendingAssignmentsAreForced && localMemberAssignmentInPending != null ? CompletableFuture.runAsync(() -> IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                assert (this.replicaMgr.isReplicaStarted((ReplicationGroupId)replicaGrpId)) : "The local node is outside of the replication group: " + String.valueOf(replicaGrpId);
                this.replicaMgr.resetPeers((ReplicationGroupId)replicaGrpId, PeersAndLearners.fromAssignments((Collection)computedStableAssignments.nodes()));
            }), this.ioExecutor) : CompletableFutures.nullCompletedFuture();
        }
        return ((CompletableFuture)localServicesStartFuture.thenComposeAsync(v -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.isLocalNodeIsPrimary((ReplicationGroupId)replicaGrpId)), (Executor)this.ioExecutor)).thenAcceptAsync(isLeaseholder -> IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            boolean isLocalNodeInStableOrPending = this.isNodeInReducedStableOrPendingAssignments(replicaGrpId, stableAssignments, pendingAssignments, revision);
            if (!isLocalNodeInStableOrPending && !isLeaseholder.booleanValue()) {
                return;
            }
            assert (isLocalNodeInStableOrPending || isLeaseholder.booleanValue()) : "The local node is outside of the replication group [inStableOrPending=" + isLocalNodeInStableOrPending + ", isLeaseholder=" + isLeaseholder + "].";
            if (isRecovery && !this.replicaMgr.isReplicaStarted((ReplicationGroupId)replicaGrpId)) {
                return;
            }
            assert (this.replicaMgr.isReplicaStarted((ReplicationGroupId)replicaGrpId)) : "The local node is outside of the replication group [, stable=" + String.valueOf(stableAssignments) + ", pending=" + String.valueOf(pendingAssignments) + ", localName=" + this.localNode().name() + "].";
            Set newAssignments = pendingAssignmentsAreForced || stableAssignments == null ? pendingAssignmentsNodes : RebalanceUtil.union((Set)pendingAssignmentsNodes, (Set)stableAssignments.nodes());
            this.replicaMgr.replica((ReplicationGroupId)replicaGrpId).thenAccept(replica -> replica.updatePeersAndLearners(PeersAndLearners.fromAssignments((Collection)newAssignments)));
        }), (Executor)this.ioExecutor);
    }

    private static boolean lastRebalanceWasGraceful(@Nullable AssignmentsChain assignmentsChain) {
        return assignmentsChain == null || assignmentsChain.chain().size() == 1;
    }

    private static PartitionSet extendPartitionSet(@Nullable PartitionSet oldPartitionSet, int partitionId) {
        PartitionSet newPartitionSet = Objects.requireNonNullElseGet(oldPartitionSet, BitSetPartitionSet::new);
        newPartitionSet.set(partitionId);
        return newPartitionSet;
    }

    private void executeIfLocalNodeIsPrimaryForGroup(ReplicationGroupId groupId, Consumer<ReplicaMeta> toExecute) {
        CompletableFuture<ReplicaMeta> primaryReplicaFuture = this.getPrimaryReplica(groupId);
        this.isLocalNodeIsPrimary(primaryReplicaFuture).thenAccept(isPrimary -> {
            if (isPrimary.booleanValue()) {
                primaryReplicaFuture.thenAccept((Consumer)toExecute);
            }
        });
    }

    private void sendChangePeersAndLearnersRequest(ReplicaMeta replicaMeta, TablePartitionId replicationGroupId, Assignments pendingAssignments, long currentRevision) {
        this.metaStorageMgr.get(RebalanceUtil.pendingPartAssignmentsKey((TablePartitionId)replicationGroupId)).thenAccept(latestPendingAssignmentsEntry -> {
            if (currentRevision < latestPendingAssignmentsEntry.revision()) {
                return;
            }
            TablePartitionIdMessage partitionIdMessage = ReplicaMessageUtils.toTablePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (TablePartitionId)replicationGroupId);
            ChangePeersAndLearnersAsyncReplicaRequest request = TABLE_MESSAGES_FACTORY.changePeersAndLearnersAsyncReplicaRequest().groupId((ReplicationGroupIdMessage)partitionIdMessage).pendingAssignments(pendingAssignments.toBytes()).enlistmentConsistencyToken(Long.valueOf(replicaMeta.getStartTime().longValue())).build();
            this.replicaSvc.invoke(this.localNode(), (ReplicaRequest)request);
        });
    }

    private boolean isNodeInReducedStableOrPendingAssignments(TablePartitionId replicaGrpId, @Nullable Assignments stableAssignments, Assignments pendingAssignments, long revision) {
        Entry reduceEntry = this.metaStorageMgr.getLocally(RebalanceUtil.switchReduceKey((TablePartitionId)replicaGrpId), revision);
        Assignments reduceAssignments = reduceEntry != null ? Assignments.fromBytes((byte[])reduceEntry.value()) : null;
        Set reducedStableAssignments = reduceAssignments != null ? RebalanceUtil.subtract((Set)stableAssignments.nodes(), (Set)reduceAssignments.nodes()) : stableAssignments.nodes();
        return this.isLocalNodeInAssignments(RebalanceUtil.union((Set)reducedStableAssignments, (Set)pendingAssignments.nodes()));
    }

    private SnapshotStorageFactory createSnapshotStorageFactory(TablePartitionId replicaGrpId, PartitionUpdateHandlers partitionUpdateHandlers, InternalTable internalTable) {
        PartitionKey partitionKey = TableManager.partitionKey(internalTable, replicaGrpId.partitionId());
        return new PartitionSnapshotStorageFactory(this.topologyService, this.outgoingSnapshotsManager, new PartitionAccessImpl(partitionKey, internalTable.storage(), internalTable.txStateStorage(), this.mvGc, partitionUpdateHandlers.indexUpdateHandler, partitionUpdateHandlers.gcUpdateHandler, this.fullStateTransferIndexChooser, this.schemaManager.schemaRegistry(partitionKey.tableId()), this.lowWatermark), this.catalogService, this.incomingSnapshotsExecutor);
    }

    private WatchListener createStableAssignmentsRebalanceListener() {
        return evt -> {
            if (!this.busyLock.enterBusy()) {
                return CompletableFuture.failedFuture(new NodeStoppingException());
            }
            try {
                CompletableFuture<Void> completableFuture = this.handleChangeStableAssignmentEvent(evt);
                return completableFuture;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        };
    }

    private WatchListener createAssignmentsSwitchRebalanceListener() {
        return evt -> IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            byte[] key = evt.entryEvent().newEntry().key();
            TablePartitionId replicaGrpId = RebalanceUtil.extractTablePartitionId((byte[])key, (byte[])RebalanceUtil.ASSIGNMENTS_SWITCH_REDUCE_PREFIX_BYTES);
            return this.tablesById(evt.revision()).thenCompose(tables -> IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
                Assignments assignments = Assignments.fromBytes((byte[])evt.entryEvent().newEntry().value());
                long assignmentsTimestamp = assignments.timestamp();
                return this.waitForMetadataCompleteness(assignmentsTimestamp).thenCompose(unused -> IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
                    int catalogVersion = this.catalogService.activeCatalogVersion(assignmentsTimestamp);
                    CatalogTableDescriptor tableDescriptor = this.getTableDescriptor(replicaGrpId.tableId(), catalogVersion);
                    CatalogZoneDescriptor zoneDescriptor = this.getZoneDescriptor(tableDescriptor, catalogVersion);
                    long causalityToken = zoneDescriptor.updateToken();
                    return this.distributionZoneManager.dataNodes(causalityToken, catalogVersion, tableDescriptor.zoneId()).thenCompose(dataNodes -> RebalanceUtilEx.handleReduceChanged(this.metaStorageMgr, dataNodes, zoneDescriptor.partitions(), zoneDescriptor.replicas(), replicaGrpId, evt, assignmentsTimestamp));
                }));
            }));
        });
    }

    private static PartitionStorages getPartitionStorages(TableImpl table, int partitionId) {
        InternalTable internalTable = table.internalTable();
        MvPartitionStorage mvPartition = internalTable.storage().getMvPartition(partitionId);
        assert (mvPartition != null) : "tableId=" + table.tableId() + ", partitionId=" + partitionId;
        TxStateStorage txStateStorage = internalTable.txStateStorage().getTxStateStorage(partitionId);
        assert (txStateStorage != null) : "tableId=" + table.tableId() + ", partitionId=" + partitionId;
        return new PartitionStorages(mvPartition, txStateStorage);
    }

    private CompletableFuture<Void> getOrCreatePartitionStorages(TableImpl table, PartitionSet partitions) {
        InternalTable internalTable = table.internalTable();
        CompletableFuture[] storageFuts = (CompletableFuture[])partitions.stream().mapToObj(partitionId -> {
            MvPartitionStorage mvPartition = internalTable.storage().getMvPartition(partitionId);
            return (mvPartition != null ? CompletableFuture.completedFuture(mvPartition) : internalTable.storage().createMvPartition(partitionId)).thenComposeAsync(mvPartitionStorage -> {
                TxStateStorage txStateStorage = internalTable.txStateStorage().getOrCreateTxStateStorage(partitionId);
                if (mvPartitionStorage.lastAppliedIndex() == -1L || txStateStorage.lastAppliedIndex() == -1L) {
                    return CompletableFuture.allOf(internalTable.storage().clearPartition(partitionId), txStateStorage.clear());
                }
                return CompletableFutures.nullCompletedFuture();
            }, (Executor)this.ioExecutor);
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(storageFuts);
    }

    protected CompletableFuture<Void> handleChangeStableAssignmentEvent(WatchEvent evt) {
        if (evt.entryEvents().stream().allMatch(e -> e.oldEntry().value() == null)) {
            return CompletableFutures.nullCompletedFuture();
        }
        if (!evt.single()) {
            assert (evt.entryEvents().stream().allMatch(entryEvent -> entryEvent.newEntry().tombstone())) : evt;
            return CompletableFutures.nullCompletedFuture();
        }
        assert (evt.single()) : evt;
        if (evt.entryEvent().oldEntry() == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        Entry stableAssignmentsWatchEvent = evt.entryEvent().newEntry();
        long revision = evt.revision();
        assert (stableAssignmentsWatchEvent.revision() == revision) : stableAssignmentsWatchEvent;
        if (stableAssignmentsWatchEvent.value() == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.handleChangeStableAssignmentEvent(stableAssignmentsWatchEvent, evt.revision(), false);
    }

    protected CompletableFuture<Void> handleChangeStableAssignmentEvent(Entry stableAssignmentsWatchEvent, long revision, boolean isRecovery) {
        TablePartitionId tablePartitionId = RebalanceUtil.extractTablePartitionId((byte[])stableAssignmentsWatchEvent.key(), (byte[])RebalanceUtil.STABLE_ASSIGNMENTS_PREFIX_BYTES);
        Set stableAssignments = stableAssignmentsWatchEvent.value() == null ? Collections.emptySet() : Assignments.fromBytes((byte[])stableAssignmentsWatchEvent.value()).nodes();
        return CompletableFuture.supplyAsync(() -> {
            Assignments pendingAssignments;
            Entry pendingAssignmentsEntry = this.metaStorageMgr.getLocally(RebalanceUtil.pendingPartAssignmentsKey((TablePartitionId)tablePartitionId), revision);
            byte[] pendingAssignmentsFromMetaStorage = pendingAssignmentsEntry.value();
            Assignments assignments = pendingAssignments = pendingAssignmentsFromMetaStorage == null ? Assignments.EMPTY : Assignments.fromBytes((byte[])pendingAssignmentsFromMetaStorage);
            if (LOG.isInfoEnabled()) {
                String stringKey = new String(stableAssignmentsWatchEvent.key(), StandardCharsets.UTF_8);
                LOG.info("Received update on stable assignments [key={}, partition={}, localMemberAddress={}, stableAssignments={}, pendingAssignments={}, revision={}]", new Object[]{stringKey, tablePartitionId, this.localNode().address(), stableAssignments, pendingAssignments, revision});
            }
            return this.stopAndDestroyPartitionAndUpdateClients(tablePartitionId, stableAssignments, pendingAssignments, isRecovery, revision);
        }, this.ioExecutor).thenCompose(Function.identity());
    }

    private CompletableFuture<Void> updatePartitionClients(TablePartitionId tablePartitionId, Set<Assignment> stableAssignments) {
        return this.isLocalNodeIsPrimary((ReplicationGroupId)tablePartitionId).thenCompose(isLeaseholder -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            boolean isLocalInStable = this.isLocalNodeInAssignments(stableAssignments);
            if (!isLocalInStable && !isLeaseholder.booleanValue()) {
                return CompletableFutures.nullCompletedFuture();
            }
            assert (this.replicaMgr.isReplicaStarted((ReplicationGroupId)tablePartitionId)) : "The local node is outside of the replication group [stable=" + String.valueOf(stableAssignments) + ", isLeaseholder=" + isLeaseholder + "].";
            return this.replicaMgr.replica((ReplicationGroupId)tablePartitionId).thenAccept(replica -> replica.updatePeersAndLearners(PeersAndLearners.fromAssignments((Collection)stableAssignments)));
        }));
    }

    private CompletableFuture<Void> stopAndDestroyPartitionAndUpdateClients(TablePartitionId tablePartitionId, Set<Assignment> stableAssignments, Assignments pendingAssignments, boolean isRecovery, long revision) {
        CompletableFuture<Void> clientUpdateFuture = isRecovery ? CompletableFutures.nullCompletedFuture() : this.updatePartitionClients(tablePartitionId, stableAssignments);
        boolean shouldStopLocalServices = (pendingAssignments.force() ? pendingAssignments.nodes().stream() : Stream.concat(stableAssignments.stream(), pendingAssignments.nodes().stream())).noneMatch(this.isLocalNodeAssignment);
        if (shouldStopLocalServices) {
            return CompletableFuture.allOf(clientUpdateFuture, this.weakStopAndDestroyPartition(tablePartitionId, revision));
        }
        return clientUpdateFuture;
    }

    private CompletableFuture<Void> weakStopAndDestroyPartition(TablePartitionId tablePartitionId, long causalityToken) {
        return this.replicaMgr.weakStopReplica((ReplicationGroupId)tablePartitionId, ReplicaManager.WeakReplicaStopReason.EXCLUDED_FROM_ASSIGNMENTS, () -> this.stopAndDestroyPartition(tablePartitionId, causalityToken));
    }

    private CompletableFuture<Void> stopAndDestroyPartition(TablePartitionId tablePartitionId, long causalityToken) {
        return this.tablesVv.get(causalityToken).thenCompose(ignore -> {
            TableImpl table = this.tables.get(tablePartitionId.tableId());
            return this.stopAndDestroyPartition(tablePartitionId, table);
        });
    }

    private CompletableFuture<Void> stopAndDestroyPartition(TablePartitionId tablePartitionId, TableImpl table) {
        return this.stopPartition(tablePartitionId, table).thenComposeAsync(v -> this.destroyPartitionStorages(tablePartitionId, table), (Executor)this.ioExecutor);
    }

    private CompletableFuture<Void> stopPartitionForRestart(TablePartitionId tablePartitionId, TableImpl table) {
        return this.replicaMgr.weakStopReplica((ReplicationGroupId)tablePartitionId, ReplicaManager.WeakReplicaStopReason.RESTART, () -> this.stopPartition(tablePartitionId, table));
    }

    private CompletableFuture<Void> stopPartition(TablePartitionId tablePartitionId, TableImpl table) {
        CompletableFuture stopReplicaFuture;
        if (table != null) {
            TableManager.closePartitionTrackers(table.internalTable(), tablePartitionId.partitionId());
        }
        try {
            stopReplicaFuture = this.replicaMgr.stopReplica((ReplicationGroupId)tablePartitionId);
        }
        catch (NodeStoppingException e) {
            stopReplicaFuture = CompletableFutures.falseCompletedFuture();
        }
        return stopReplicaFuture.thenCompose(v -> {
            this.minTimeCollectorService.removePartition(tablePartitionId);
            return this.mvGc.removeStorage(tablePartitionId);
        });
    }

    private CompletableFuture<Void> destroyPartitionStorages(TablePartitionId tablePartitionId, TableImpl table) {
        if (table == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        InternalTable internalTable = table.internalTable();
        int partitionId = tablePartitionId.partitionId();
        ArrayList<CompletableFuture<Void>> destroyFutures = new ArrayList<CompletableFuture<Void>>();
        if (internalTable.storage().getMvPartition(partitionId) != null) {
            destroyFutures.add(internalTable.storage().destroyPartition(partitionId));
        }
        if (internalTable.txStateStorage().getTxStateStorage(partitionId) != null) {
            destroyFutures.add(CompletableFuture.runAsync(() -> internalTable.txStateStorage().destroyTxStateStorage(partitionId), this.ioExecutor));
        }
        destroyFutures.add(CompletableFuture.runAsync(() -> this.destroyReplicationProtocolStorages(tablePartitionId, table), this.ioExecutor));
        return CompletableFuture.allOf(destroyFutures.toArray(new CompletableFuture[0]));
    }

    private void destroyReplicationProtocolStorages(TablePartitionId tablePartitionId, TableImpl table) {
        InternalTableImpl internalTbl = (InternalTableImpl)table.internalTable();
        try {
            this.replicaMgr.destroyReplicationProtocolStorages((ReplicationGroupId)tablePartitionId, internalTbl.storage().isVolatile());
        }
        catch (NodeStoppingException e) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)e);
        }
    }

    private static void closePartitionTrackers(InternalTable internalTable, int partitionId) {
        TableManager.closeTracker(internalTable.getPartitionSafeTimeTracker(partitionId));
        TableManager.closeTracker(internalTable.getPartitionStorageIndexTracker(partitionId));
    }

    private static void closeTracker(@Nullable PendingComparableValuesTracker<?, Void> tracker) {
        if (tracker != null) {
            tracker.close();
        }
    }

    private ClusterNode localNode() {
        return this.topologyService.localMember();
    }

    private static PartitionUpdateHandlers createPartitionUpdateHandlers(int partitionId, PartitionDataStorage partitionDataStorage, TableImpl table, PendingComparableValuesTracker<HybridTimestamp, Void> safeTimeTracker, StorageUpdateConfiguration storageUpdateConfig) {
        TableIndexStoragesSupplier indexes = table.indexStorageAdapters(partitionId);
        IndexUpdateHandler indexUpdateHandler = new IndexUpdateHandler(indexes);
        GcUpdateHandler gcUpdateHandler = new GcUpdateHandler(partitionDataStorage, safeTimeTracker, indexUpdateHandler);
        StorageUpdateHandler storageUpdateHandler = new StorageUpdateHandler(partitionId, partitionDataStorage, indexUpdateHandler, storageUpdateConfig);
        return new PartitionUpdateHandlers(storageUpdateHandler, indexUpdateHandler, gcUpdateHandler);
    }

    @Override
    @Nullable
    public TableViewInternal cachedTable(int tableId) {
        return this.tables.get(tableId);
    }

    @TestOnly
    @Nullable
    public TableViewInternal cachedTable(String name) {
        return TableManager.findTableImplByName(this.tables.values(), name);
    }

    private CatalogTableDescriptor getTableDescriptor(int tableId, int catalogVersion) {
        CatalogTableDescriptor tableDescriptor = this.catalogService.table(tableId, catalogVersion);
        assert (tableDescriptor != null) : "tableId=" + tableId + ", catalogVersion=" + catalogVersion;
        return tableDescriptor;
    }

    private CatalogZoneDescriptor getZoneDescriptor(CatalogTableDescriptor tableDescriptor, int catalogVersion) {
        CatalogZoneDescriptor zoneDescriptor = this.catalogService.zone(tableDescriptor.zoneId(), catalogVersion);
        assert (zoneDescriptor != null) : "tableId=" + tableDescriptor.id() + ", zoneId=" + tableDescriptor.zoneId() + ", catalogVersion=" + catalogVersion;
        return zoneDescriptor;
    }

    @Nullable
    private static TableImpl findTableImplByName(Collection<TableImpl> tables, String name) {
        return tables.stream().filter(table -> table.name().equals(name)).findAny().orElse(null);
    }

    private void startTables(long recoveryRevision, @Nullable HybridTimestamp lwm) {
        int earliestCatalogVersion = this.catalogService.activeCatalogVersion(HybridTimestamp.hybridTimestampToLong((HybridTimestamp)lwm));
        int latestCatalogVersion = this.catalogService.latestCatalogVersion();
        IntOpenHashSet startedTables = new IntOpenHashSet();
        ArrayList startTableFutures = new ArrayList();
        for (int ver = latestCatalogVersion; ver >= earliestCatalogVersion; --ver) {
            int ver0 = ver;
            this.catalogService.tables(ver).stream().filter(tbl -> startedTables.add(tbl.id())).forEach(tableDescriptor -> {
                if (PartitionReplicaLifecycleManager.ENABLED) {
                    CatalogZoneDescriptor zoneDescriptor = this.getZoneDescriptor((CatalogTableDescriptor)tableDescriptor, ver0);
                    startTableFutures.add(this.prepareTableResourcesAndLoadToZoneReplica(recoveryRevision, zoneDescriptor, (CatalogTableDescriptor)tableDescriptor, true));
                } else {
                    startTableFutures.add(this.createTableLocally(recoveryRevision, ver0, (CatalogTableDescriptor)tableDescriptor, true));
                }
            });
        }
        this.startVv.update(recoveryRevision, (unused, throwable) -> CompletableFuture.allOf((CompletableFuture[])startTableFutures.toArray(CompletableFuture[]::new))).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                LOG.error("Error starting tables", throwable);
            } else {
                LOG.debug("Tables started successfully", new Object[0]);
            }
        });
    }

    private <T> CompletableFuture<T> orStopManagerFuture(CompletableFuture<T> future) {
        if (future.isDone()) {
            return future;
        }
        return CompletableFuture.anyOf(future, this.stopManagerFuture).thenApply(o -> o);
    }

    private void cleanUpResourcesForDroppedTablesOnRecoveryBusy() {
        for (DroppedTableInfo droppedTableInfo : TableUtils.droppedTables(this.catalogService, this.lowWatermark.getLowWatermark())) {
            int catalogVersion = droppedTableInfo.tableRemovalCatalogVersion() - 1;
            CatalogTableDescriptor tableDescriptor = this.catalogService.table(droppedTableInfo.tableId(), catalogVersion);
            assert (tableDescriptor != null) : "tableId=" + droppedTableInfo.tableId() + ", catalogVersion=" + catalogVersion;
            this.destroyTableStorageOnRecoveryBusy(tableDescriptor);
        }
    }

    private void destroyTableStorageOnRecoveryBusy(CatalogTableDescriptor tableDescriptor) {
        StorageEngine engine = this.dataStorageMgr.engineByStorageProfile(tableDescriptor.storageProfile());
        assert (engine != null) : "tableId=" + tableDescriptor.id() + ", storageProfile=" + tableDescriptor.storageProfile();
        engine.dropMvTable(tableDescriptor.id());
    }

    private synchronized ScheduledExecutorService streamerFlushExecutor() {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            if (this.streamerFlushExecutor == null) {
                this.streamerFlushExecutor = Executors.newSingleThreadScheduledExecutor(IgniteThreadFactory.create((String)this.nodeName, (String)"streamer-flush-executor", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[]{ThreadOperation.STORAGE_WRITE}));
            }
            ScheduledExecutorService scheduledExecutorService = this.streamerFlushExecutor;
            return scheduledExecutorService;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public CompletableFuture<Void> restartPartition(TablePartitionId tablePartitionId, long revision, long assignmentsTimestamp) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> this.tablesVv.get(revision).thenComposeAsync(unused -> IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            TableImpl table = this.tables.get(tablePartitionId.tableId());
            return this.stopPartitionForRestart(tablePartitionId, table).thenComposeAsync(unused1 -> {
                Assignments stableAssignments = RebalanceUtil.stableAssignmentsGetLocally((MetaStorageManager)this.metaStorageMgr, (TablePartitionId)tablePartitionId, (long)revision);
                assert (stableAssignments != null) : "tablePartitionId=" + String.valueOf(tablePartitionId) + ", revision=" + revision;
                return this.waitForMetadataCompleteness(assignmentsTimestamp).thenCompose(unused2 -> IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
                    Assignment localMemberAssignment = this.localMemberAssignment(stableAssignments);
                    if (localMemberAssignment == null) {
                        return CompletableFutures.nullCompletedFuture();
                    }
                    return this.startPartitionAndStartClient(table, tablePartitionId.partitionId(), localMemberAssignment, stableAssignments, false, assignmentsTimestamp);
                }));
            }, (Executor)this.ioExecutor);
        }), (Executor)this.ioExecutor));
    }

    @Override
    public void setStreamerReceiverRunner(StreamerReceiverRunner runner) {
        this.streamerReceiverRunner = runner;
    }

    private Set<TableImpl> zoneTables(int zoneId) {
        return this.tablesPerZone.compute(zoneId, (id, tables) -> {
            if (tables == null) {
                tables = new HashSet();
            }
            return tables;
        });
    }

    private void addTableToZone(int zoneId, TableImpl table) {
        this.tablesPerZone.compute(zoneId, (id, tbls) -> {
            if (tbls == null) {
                tbls = new HashSet<TableImpl>();
            }
            tbls.add(table);
            return tbls;
        });
    }

    private static class DestroyTableEvent {
        final int catalogVersion;
        final int tableId;

        DestroyTableEvent(int catalogVersion, int tableId) {
            this.catalogVersion = catalogVersion;
            this.tableId = tableId;
        }

        public int catalogVersion() {
            return this.catalogVersion;
        }

        public int tableId() {
            return this.tableId;
        }
    }
}

