/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import java.net.SocketAddress;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.network.NettyBootstrapFactory;
import org.apache.ignite.internal.network.configuration.NetworkView;
import org.apache.ignite.internal.network.handshake.HandshakeManager;
import org.apache.ignite.internal.network.netty.InNetworkObject;
import org.apache.ignite.internal.network.netty.NettyUtils;
import org.apache.ignite.internal.network.netty.PipelineUtils;
import org.apache.ignite.internal.network.serialization.PerSessionSerializationService;
import org.apache.ignite.internal.network.serialization.SerializationService;
import org.apache.ignite.internal.network.ssl.SslContextProvider;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class NettyServer {
    private final Object startStopLock = new Object();
    private final NettyBootstrapFactory bootstrapFactory;
    private final NetworkView configuration;
    private final SerializationService serializationService;
    private final Consumer<InNetworkObject> messageListener;
    private final Supplier<HandshakeManager> handshakeManager;
    private CompletableFuture<Void> serverStartFuture;
    @Nullable
    private volatile ServerChannel channel;
    @Nullable
    private CompletableFuture<Void> serverCloseFuture;
    private boolean stopped;

    public NettyServer(NetworkView configuration, Supplier<HandshakeManager> handshakeManager, Consumer<InNetworkObject> messageListener, SerializationService serializationService, NettyBootstrapFactory bootstrapFactory) {
        this.configuration = configuration;
        this.handshakeManager = handshakeManager;
        this.messageListener = messageListener;
        this.serializationService = serializationService;
        this.bootstrapFactory = bootstrapFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> start() {
        Object object = this.startStopLock;
        synchronized (object) {
            ChannelFuture channelFuture;
            if (this.stopped) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Attempted to start an already stopped server");
            }
            if (this.serverStartFuture != null) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Attempted to start an already started server");
            }
            ServerBootstrap bootstrap = this.bootstrapFactory.createServerBootstrap();
            bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    PerSessionSerializationService sessionSerializationService = new PerSessionSerializationService(NettyServer.this.serializationService);
                    HandshakeManager manager = NettyServer.this.handshakeManager.get();
                    if (NettyServer.this.configuration.ssl().enabled()) {
                        SslContext sslContext = SslContextProvider.createServerSslContext(NettyServer.this.configuration.ssl());
                        PipelineUtils.setup(ch.pipeline(), sessionSerializationService, manager, NettyServer.this.messageListener, sslContext);
                    } else {
                        PipelineUtils.setup(ch.pipeline(), sessionSerializationService, manager, NettyServer.this.messageListener);
                    }
                }
            });
            int port = this.configuration.port();
            String[] addresses = this.configuration.listenAddresses();
            CompletableFuture bindFuture = new CompletableFuture();
            if (addresses.length == 0) {
                channelFuture = bootstrap.bind(port);
            } else {
                if (addresses.length > 1) {
                    throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Only one listen address is allowed for now, but got " + String.valueOf(List.of(addresses)));
                }
                channelFuture = bootstrap.bind(addresses[0], port);
            }
            channelFuture.addListener(future -> {
                if (future.isSuccess()) {
                    bindFuture.complete(future.channel());
                } else if (future.isCancelled()) {
                    bindFuture.cancel(true);
                } else {
                    String errorMessage = addresses.length == 0 ? "Port " + port + " is not available." : String.format("Address %s:%d is not available", addresses[0], port);
                    bindFuture.completeExceptionally((Throwable)new IgniteException(ErrorGroups.Network.PORT_IN_USE_ERR, errorMessage, future.cause()));
                }
            });
            this.serverStartFuture = ((CompletableFuture)bindFuture.handle((channel, err) -> {
                Object object = this.startStopLock;
                synchronized (object) {
                    if (channel != null) {
                        this.serverCloseFuture = NettyUtils.toCompletableFuture(channel.closeFuture());
                    }
                    this.channel = (ServerChannel)channel;
                    if (err != null || this.stopped) {
                        Throwable stopErr = err != null ? err : new CancellationException("Server was stopped");
                        return CompletableFuture.failedFuture(stopErr);
                    }
                    return CompletableFutures.nullCompletedFuture();
                }
            })).thenCompose(Function.identity());
            return this.serverStartFuture;
        }
    }

    public SocketAddress address() {
        return Objects.requireNonNull(this.channel, "Not started yet").localAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> stop() {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.stopped) {
                return CompletableFutures.nullCompletedFuture();
            }
            this.stopped = true;
            if (this.serverStartFuture == null) {
                return CompletableFutures.nullCompletedFuture();
            }
            return ((CompletableFuture)this.serverStartFuture.handle((unused, throwable) -> {
                Object object = this.startStopLock;
                synchronized (object) {
                    ServerChannel localChannel = this.channel;
                    if (localChannel != null) {
                        localChannel.close();
                    }
                    return this.serverCloseFuture == null ? CompletableFutures.nullCompletedFuture() : this.serverCloseFuture;
                }
            })).thenCompose(Function.identity());
        }
    }

    @TestOnly
    public boolean isRunning() {
        ServerChannel channel0 = this.channel;
        return channel0 != null && channel0.isOpen();
    }
}

