/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableSchemaVersions;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.CreateTableEventParameters;
import org.apache.ignite.internal.catalog.events.TableEventParameters;
import org.apache.ignite.internal.causality.IncrementalVersionedValue;
import org.apache.ignite.internal.causality.RevisionListenerRegistry;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.SchemaUtils;
import org.apache.ignite.internal.schema.catalog.CatalogToSchemaDescriptorConverter;
import org.apache.ignite.internal.schema.registry.SchemaRegistryImpl;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.jetbrains.annotations.Nullable;

public class SchemaManager
implements IgniteComponent {
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final CatalogService catalogService;
    private final IncrementalVersionedValue<Void> registriesVv;
    private final Map<Integer, SchemaRegistryImpl> registriesById = new ConcurrentHashMap<Integer, SchemaRegistryImpl>();

    public SchemaManager(RevisionListenerRegistry registry, CatalogService catalogService) {
        this.registriesVv = new IncrementalVersionedValue(registry);
        this.catalogService = catalogService;
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.catalogService.listen((Event)CatalogEvent.TABLE_CREATE, this::onTableCreated);
        this.catalogService.listen((Event)CatalogEvent.TABLE_ALTER, this::onTableAltered);
        this.registerExistingTables();
        return CompletableFutures.nullCompletedFuture();
    }

    private void registerExistingTables() {
        for (int catalogVer = this.catalogService.latestCatalogVersion(); catalogVer >= this.catalogService.earliestCatalogVersion(); --catalogVer) {
            Collection tables = this.catalogService.tables(catalogVer);
            for (CatalogTableDescriptor tableDescriptor : tables) {
                int tableId = tableDescriptor.id();
                if (this.registriesById.containsKey(tableId)) continue;
                SchemaDescriptor prevSchema = null;
                CatalogTableSchemaVersions schemaVersions = tableDescriptor.schemaVersions();
                for (int tableVer = schemaVersions.earliestVersion(); tableVer <= schemaVersions.latestVersion(); ++tableVer) {
                    SchemaDescriptor newSchema = CatalogToSchemaDescriptorConverter.convert(tableDescriptor, tableVer);
                    if (prevSchema != null) {
                        newSchema.columnMapping(SchemaUtils.columnMapper(prevSchema, newSchema));
                    }
                    prevSchema = newSchema;
                    this.registerSchema(tableId, newSchema);
                }
            }
        }
    }

    private CompletableFuture<Boolean> onTableCreated(CatalogEventParameters event) {
        CreateTableEventParameters creationEvent = (CreateTableEventParameters)event;
        return this.onTableCreatedOrAltered(creationEvent.tableDescriptor(), creationEvent.causalityToken());
    }

    private CompletableFuture<Boolean> onTableAltered(CatalogEventParameters event) {
        assert (event instanceof TableEventParameters);
        TableEventParameters tableEvent = (TableEventParameters)event;
        CatalogTableDescriptor tableDescriptor = this.catalogService.table(tableEvent.tableId(), tableEvent.catalogVersion());
        assert (tableDescriptor != null);
        return this.onTableCreatedOrAltered(tableDescriptor, event.causalityToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private CompletableFuture<Boolean> onTableCreatedOrAltered(CatalogTableDescriptor tableDescriptor, long causalityToken) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture((Throwable)new NodeStoppingException());
        }
        try {
            int tableId = tableDescriptor.id();
            int newSchemaVersion = tableDescriptor.tableVersion();
            if (this.searchSchemaByVersion(tableId, newSchemaVersion) != null) {
                CompletableFuture completableFuture = CompletableFutures.falseCompletedFuture();
                return completableFuture;
            }
            SchemaDescriptor newSchema = SchemaUtils.prepareSchemaDescriptor(tableDescriptor);
            try {
                this.setColumnMapping(newSchema, tableId);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                CompletableFuture<Boolean> completableFuture = CompletableFuture.failedFuture(e2);
                this.busyLock.leaveBusy();
                return completableFuture;
            }
            catch (ExecutionException e3) {
                CompletableFuture<Boolean> completableFuture = CompletableFuture.failedFuture(e3);
                this.busyLock.leaveBusy();
                return completableFuture;
            }
            CompletionStage completionStage = this.registriesVv.update(causalityToken, (registries, e) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                if (e != null) {
                    return CompletableFuture.failedFuture((Throwable)new IgniteInternalException(IgniteStringFormatter.format((String)"Cannot create a schema for the table [tblId={}, ver={}]", (Object[])new Object[]{tableId, newSchemaVersion}), e));
                }
                this.registerSchema(tableId, newSchema);
                return CompletableFutures.nullCompletedFuture();
            })).thenApply(ignored -> false);
            return completionStage;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void setColumnMapping(SchemaDescriptor schema, int tableId) throws ExecutionException, InterruptedException {
        if (schema.version() == 1) {
            return;
        }
        int prevVersion = schema.version() - 1;
        SchemaDescriptor prevSchema = this.searchSchemaByVersion(tableId, prevVersion);
        if (prevSchema == null) {
            prevSchema = this.loadRequiredSchemaDescriptor(tableId, prevVersion);
        }
        schema.columnMapping(SchemaUtils.columnMapper(prevSchema, schema));
    }

    private SchemaDescriptor loadRequiredSchemaDescriptor(int tblId, int ver) {
        for (int catalogVersion = this.catalogService.latestCatalogVersion(); catalogVersion >= this.catalogService.earliestCatalogVersion(); --catalogVersion) {
            CatalogTableDescriptor tableDescriptor = this.catalogService.table(tblId, catalogVersion);
            if (tableDescriptor == null) {
                continue;
            }
            return CatalogToSchemaDescriptorConverter.convert(tableDescriptor, ver);
        }
        throw new AssertionError((Object)IgniteStringFormatter.format((String)"Schema descriptor is not found [tableId={}, schemaId={}]", (Object[])new Object[]{tblId, ver}));
    }

    @Nullable
    private SchemaDescriptor loadOptionalSchemaDescriptor(int tblId, int ver) {
        for (int catalogVersion = this.catalogService.latestCatalogVersion(); catalogVersion >= this.catalogService.earliestCatalogVersion(); --catalogVersion) {
            CatalogTableDescriptor tableDescriptor = this.catalogService.table(tblId, catalogVersion);
            if (tableDescriptor == null) {
                continue;
            }
            return CatalogToSchemaDescriptorConverter.convertIfExists(tableDescriptor, ver);
        }
        throw new AssertionError((Object)IgniteStringFormatter.format((String)"Schema descriptor is not found [tableId={}, schemaId={}]", (Object[])new Object[]{tblId, ver}));
    }

    private void registerSchema(int tableId, SchemaDescriptor schema) {
        this.registriesById.compute(tableId, (tableId0, reg) -> {
            if (reg == null) {
                return this.createSchemaRegistry((int)tableId0, schema);
            }
            reg.onSchemaRegistered(schema);
            return reg;
        });
    }

    private SchemaRegistryImpl createSchemaRegistry(int tableId, SchemaDescriptor initialSchema) {
        return new SchemaRegistryImpl(ver -> (SchemaDescriptor)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.loadOptionalSchemaDescriptor(tableId, ver)), initialSchema);
    }

    @Nullable
    private SchemaDescriptor searchSchemaByVersion(int tblId, int schemaVer) {
        SchemaRegistry registry = this.registriesById.get(tblId);
        if (registry != null && schemaVer <= registry.lastKnownSchemaVersion()) {
            return registry.schema(schemaVer);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<SchemaRegistry> schemaRegistry(long causalityToken, int tableId) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.registriesVv.get(causalityToken).thenApply(unused -> (SchemaRegistry)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.registriesById.get(tableId)));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public SchemaRegistry schemaRegistry(int tableId) {
        return this.registriesById.get(tableId);
    }

    public CompletableFuture<?> dropRegistryAsync(int tableId) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            SchemaRegistryImpl removedRegistry = this.registriesById.remove(tableId);
            removedRegistry.close();
            return CompletableFutures.falseCompletedFuture();
        });
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        try {
            IgniteUtils.closeAllManually(this.registriesById.values());
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.nullCompletedFuture();
    }
}

