/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partitiondistribution;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.partitiondistribution.AssignmentsChainSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class AssignmentsChain {
    @IgniteToStringInclude
    private final List<Assignments> chain;

    private AssignmentsChain(List<Assignments> chain) {
        this.chain = chain;
    }

    public List<Assignments> chain() {
        return this.chain;
    }

    public AssignmentsChain replaceLast(Assignments newLast) {
        assert (!this.chain.isEmpty()) : "Assignments chain is empty.";
        ArrayList<Assignments> newChain = new ArrayList<Assignments>(this.chain);
        newChain.set(newChain.size() - 1, newLast);
        return new AssignmentsChain(newChain);
    }

    public AssignmentsChain addLast(Assignments newLast) {
        assert (!this.chain.isEmpty()) : "Assignments chain is empty.";
        ArrayList<Assignments> newChain = new ArrayList<Assignments>(this.chain);
        newChain.add(newLast);
        return new AssignmentsChain(newChain);
    }

    public static AssignmentsChain of(Assignments assignments) {
        return new AssignmentsChain(List.of(assignments));
    }

    public static AssignmentsChain of(List<Assignments> assignmentsChain) {
        return new AssignmentsChain(assignmentsChain);
    }

    public byte[] toBytes() {
        return VersionedSerialization.toBytes((Object)this, (VersionedSerializer)AssignmentsChainSerializer.INSTANCE);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static AssignmentsChain fromBytes(byte @Nullable [] bytes) {
        return bytes == null ? null : (AssignmentsChain)VersionedSerialization.fromBytes((byte[])bytes, (VersionedSerializer)AssignmentsChainSerializer.INSTANCE);
    }

    public String toString() {
        return S.toString((Object)this);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignmentsChain that = (AssignmentsChain)o;
        return Objects.equals(this.chain, that.chain);
    }

    public int hashCode() {
        return this.chain.hashCode();
    }
}

