/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ignite.compute.ComputeException;
import org.apache.ignite.compute.JobExecution;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.internal.compute.CancellableJobExecution;
import org.apache.ignite.internal.compute.Cleaner;
import org.apache.ignite.internal.compute.FailSafeJobExecution;
import org.apache.ignite.internal.compute.configuration.ComputeConfiguration;
import org.apache.ignite.internal.compute.messaging.RemoteJobExecution;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ExecutionManager {
    private final ComputeConfiguration computeConfiguration;
    private final TopologyService topologyService;
    private final Cleaner<JobExecution<?>> cleaner = new Cleaner();
    private final Map<UUID, CancellableJobExecution<?>> executions = new ConcurrentHashMap();

    ExecutionManager(ComputeConfiguration computeConfiguration, TopologyService topologyService) {
        this.computeConfiguration = computeConfiguration;
        this.topologyService = topologyService;
    }

    void addExecution(UUID jobId, CancellableJobExecution<?> execution) {
        this.executions.put(jobId, execution);
        execution.resultAsync().whenComplete((r, throwable) -> this.cleaner.scheduleRemove(jobId));
    }

    void start() {
        long ttlMillis = (Long)this.computeConfiguration.statesLifetimeMillis().value();
        String nodeName = this.topologyService.localMember().name();
        this.cleaner.start(this.executions::remove, ttlMillis, nodeName);
    }

    void stop() {
        this.cleaner.stop();
    }

    public CompletableFuture<?> resultAsync(UUID jobId) {
        JobExecution execution = this.executions.get(jobId);
        if (execution != null) {
            return execution.resultAsync();
        }
        return CompletableFuture.failedFuture((Throwable)new ComputeException(ErrorGroups.Compute.RESULT_NOT_FOUND_ERR, "Job result not found for the job with ID: " + String.valueOf(jobId)));
    }

    public CompletableFuture<List<JobState>> localStatesAsync() {
        CompletableFuture[] statesFutures = (CompletableFuture[])this.executions.values().stream().filter(it -> !(it instanceof RemoteJobExecution) && !(it instanceof FailSafeJobExecution)).map(JobExecution::stateAsync).toArray(CompletableFuture[]::new);
        return CompletableFutures.allOfToList((CompletableFuture[])statesFutures).thenApply(states -> states.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public CompletableFuture<@Nullable JobState> stateAsync(UUID jobId) {
        JobExecution execution = this.executions.get(jobId);
        if (execution != null) {
            return execution.stateAsync();
        }
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<@Nullable Boolean> cancelAsync(UUID jobId) {
        CancellableJobExecution<?> execution = this.executions.get(jobId);
        if (execution != null) {
            return execution.cancelAsync();
        }
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<@Nullable Boolean> changePriorityAsync(UUID jobId, int newPriority) {
        JobExecution execution = this.executions.get(jobId);
        if (execution != null) {
            return execution.changePriorityAsync(newPriority);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @TestOnly
    Set<UUID> executions() {
        return this.executions.keySet();
    }
}

