/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.direct;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteUuid;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.direct.state.DirectMessageState;
import org.apache.ignite.internal.network.direct.state.DirectMessageStateItem;
import org.apache.ignite.internal.network.direct.stream.DirectByteBufferStream;
import org.apache.ignite.internal.network.direct.stream.DirectByteBufferStreamImplV1;
import org.apache.ignite.internal.network.serialization.MessageSerializationRegistry;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.jetbrains.annotations.Nullable;

public class DirectMessageWriter
implements MessageWriter {
    private final DirectMessageState<StateItem> state = new DirectMessageState<StateItem>(StateItem.class, () -> new StateItem(this.createStream(serializationRegistry, protoVer)));
    private StateItem stateItem = this.state.item();
    private DirectByteBufferStream stream;

    public DirectMessageWriter(MessageSerializationRegistry serializationRegistry, byte protoVer) {
        this.stream = this.stateItem.stream;
    }

    public void setBuffer(ByteBuffer buf) {
        this.stream.setBuffer(buf);
    }

    public void setCurrentWriteClass(Class<? extends NetworkMessage> msgCls) {
    }

    public boolean writeHeader(short groupType, short messageType, byte fieldCnt) {
        DirectByteBufferStream stream = this.stream;
        if (!this.stateItem.partialHdrWritten) {
            stream.writeShort(groupType);
            if (stream.lastFinished()) {
                this.stateItem.partialHdrWritten = true;
            } else {
                return false;
            }
        }
        stream.writeShort(messageType);
        return stream.lastFinished();
    }

    public boolean writeByte(String name, byte val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeByte(val);
        return stream.lastFinished();
    }

    public boolean writeBoxedByte(String name, @Nullable Byte val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeBoxedByte(val);
        return stream.lastFinished();
    }

    public boolean writeShort(String name, short val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeShort(val);
        return stream.lastFinished();
    }

    public boolean writeBoxedShort(String name, @Nullable Short val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeBoxedShort(val);
        return stream.lastFinished();
    }

    public boolean writeInt(String name, int val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeInt(val);
        return stream.lastFinished();
    }

    public boolean writeBoxedInt(String name, @Nullable Integer val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeBoxedInt(val);
        return stream.lastFinished();
    }

    public boolean writeLong(String name, long val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeLong(val);
        return stream.lastFinished();
    }

    public boolean writeBoxedLong(String name, @Nullable Long val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeBoxedLong(val);
        return stream.lastFinished();
    }

    public boolean writeFloat(String name, float val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeFloat(val);
        return stream.lastFinished();
    }

    public boolean writeBoxedFloat(String name, @Nullable Float val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeBoxedFloat(val);
        return stream.lastFinished();
    }

    public boolean writeDouble(String name, double val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeDouble(val);
        return stream.lastFinished();
    }

    public boolean writeBoxedDouble(String name, @Nullable Double val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeBoxedDouble(val);
        return stream.lastFinished();
    }

    public boolean writeChar(String name, char val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeChar(val);
        return stream.lastFinished();
    }

    public boolean writeBoxedChar(String name, @Nullable Character val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeBoxedChar(val);
        return stream.lastFinished();
    }

    public boolean writeBoolean(String name, boolean val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeBoolean(val);
        return stream.lastFinished();
    }

    public boolean writeBoxedBoolean(String name, @Nullable Boolean val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeBoxedBoolean(val);
        return stream.lastFinished();
    }

    public boolean writeByteArray(String name, @Nullable byte[] val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeByteArray(val);
        return stream.lastFinished();
    }

    public boolean writeByteArray(String name, byte[] val, long off, int len) {
        DirectByteBufferStream stream = this.stream;
        stream.writeByteArray(val, off, len);
        return stream.lastFinished();
    }

    public boolean writeShortArray(String name, @Nullable short[] val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeShortArray(val);
        return stream.lastFinished();
    }

    public boolean writeIntArray(String name, @Nullable int[] val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeIntArray(val);
        return stream.lastFinished();
    }

    public boolean writeLongArray(String name, @Nullable long[] val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeLongArray(val);
        return stream.lastFinished();
    }

    public boolean writeLongArray(String name, long[] val, int len) {
        DirectByteBufferStream stream = this.stream;
        stream.writeLongArray(val, len);
        return stream.lastFinished();
    }

    public boolean writeFloatArray(String name, @Nullable float[] val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeFloatArray(val);
        return stream.lastFinished();
    }

    public boolean writeDoubleArray(String name, @Nullable double[] val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeDoubleArray(val);
        return stream.lastFinished();
    }

    public boolean writeCharArray(String name, @Nullable char[] val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeCharArray(val);
        return stream.lastFinished();
    }

    public boolean writeBooleanArray(String name, @Nullable boolean[] val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeBooleanArray(val);
        return stream.lastFinished();
    }

    public boolean writeString(String name, String val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeString(val);
        return stream.lastFinished();
    }

    public boolean writeBitSet(String name, BitSet val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeBitSet(val);
        return stream.lastFinished();
    }

    public boolean writeByteBuffer(String name, ByteBuffer val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeByteBuffer(val);
        return stream.lastFinished();
    }

    public boolean writeUuid(String name, UUID val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeUuid(val);
        return stream.lastFinished();
    }

    public boolean writeIgniteUuid(String name, IgniteUuid val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeIgniteUuid(val);
        return stream.lastFinished();
    }

    public boolean writeHybridTimestamp(String name, @Nullable HybridTimestamp val) {
        DirectByteBufferStream stream = this.stream;
        stream.writeLong(val == null ? 0L : val.longValue());
        return stream.lastFinished();
    }

    public boolean writeMessage(String name, @Nullable NetworkMessage msg) {
        DirectByteBufferStream stream = this.stream;
        stream.writeMessage(msg, this);
        return stream.lastFinished();
    }

    public <T> boolean writeObjectArray(String name, T[] arr, MessageCollectionItemType itemType) {
        DirectByteBufferStream stream = this.stream;
        stream.writeObjectArray(arr, itemType, this);
        return stream.lastFinished();
    }

    public <T> boolean writeCollection(String name, Collection<T> col, MessageCollectionItemType itemType) {
        DirectByteBufferStream stream = this.stream;
        stream.writeCollection(col, itemType, this);
        return stream.lastFinished();
    }

    public <T> boolean writeList(String name, List<T> col, MessageCollectionItemType itemType) {
        DirectByteBufferStream stream = this.stream;
        stream.writeCollection(col, itemType, this);
        return stream.lastFinished();
    }

    public <T> boolean writeSet(String name, Set<T> col, MessageCollectionItemType itemType) {
        DirectByteBufferStream stream = this.stream;
        stream.writeSet(col, itemType, this);
        return stream.lastFinished();
    }

    public <K, V> boolean writeMap(String name, Map<K, V> map, MessageCollectionItemType keyType, MessageCollectionItemType valType) {
        DirectByteBufferStream stream = this.stream;
        stream.writeMap(map, keyType, valType, this);
        return stream.lastFinished();
    }

    public boolean isHeaderWritten() {
        return this.stateItem.hdrWritten;
    }

    public void onHeaderWritten() {
        this.stateItem.hdrWritten = true;
    }

    public int state() {
        return this.stateItem.state;
    }

    public void incrementState() {
        ++this.stateItem.state;
    }

    public void beforeInnerMessageWrite() {
        this.state.forward();
        this.stateItem = this.state.item();
        this.stream = this.stateItem.stream;
    }

    public void afterInnerMessageWrite(boolean finished) {
        this.setBuffer(ArrayUtils.EMPTY_BYTE_BUFFER);
        this.state.backward(finished);
        this.stateItem = this.state.item();
        this.stream = this.stateItem.stream;
    }

    public void reset() {
        this.state.reset();
        this.stateItem = this.state.item();
        this.stream = this.stateItem.stream;
    }

    protected DirectByteBufferStream createStream(MessageSerializationRegistry serializationRegistry, byte protoVer) {
        switch (protoVer) {
            case 1: {
                return new DirectByteBufferStreamImplV1(serializationRegistry);
            }
        }
        throw new IllegalStateException("Invalid protocol version: " + protoVer);
    }

    private static class StateItem
    implements DirectMessageStateItem {
        final DirectByteBufferStream stream;
        int state;
        boolean partialHdrWritten;
        boolean hdrWritten;

        StateItem(DirectByteBufferStream stream) {
            this.stream = stream;
        }

        @Override
        public void reset() {
            this.state = 0;
            this.partialHdrWritten = false;
            this.hdrWritten = false;
        }
    }
}

