/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery;

import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.network.recovery.StaleIds;
import org.apache.ignite.internal.vault.VaultEntry;
import org.apache.ignite.internal.vault.VaultManager;

public class VaultStaleIds
implements StaleIds {
    private static final ByteArray STALE_IDS_KEY = new ByteArray("network.staleIds");
    private static final int DEFAULT_MAX_IDS_TO_REMEMBER = 10000;
    private final VaultManager vaultManager;
    private final int maxIdsToRemember;
    private Set<UUID> staleIds;

    public VaultStaleIds(VaultManager vaultManager) {
        this(vaultManager, 10000);
    }

    public VaultStaleIds(VaultManager vaultManager, int maxIdsToRemember) {
        this.vaultManager = vaultManager;
        this.maxIdsToRemember = maxIdsToRemember;
    }

    @Override
    public synchronized boolean isIdStale(UUID nodeId) {
        this.loadFromVaultIfFirstOperation();
        return this.staleIds.contains(nodeId);
    }

    private void loadFromVaultIfFirstOperation() {
        if (this.staleIds == null) {
            this.staleIds = this.loadStaleIdsFromVault();
        }
    }

    private Set<UUID> loadStaleIdsFromVault() {
        VaultEntry entry = this.vaultManager.get(STALE_IDS_KEY);
        if (entry == null) {
            return new LinkedHashSet<UUID>();
        }
        String[] idsArray = new String(entry.value(), StandardCharsets.UTF_8).split("\n");
        LinkedHashSet<UUID> result = new LinkedHashSet<UUID>();
        for (String id : idsArray) {
            result.add(UUID.fromString(id));
        }
        return result;
    }

    @Override
    public synchronized void markAsStale(UUID nodeId) {
        this.loadFromVaultIfFirstOperation();
        this.staleIds.add(nodeId);
        int idsToRemove = this.staleIds.size() - this.maxIdsToRemember;
        Iterator<UUID> iterator = this.staleIds.iterator();
        for (int i = 0; i < idsToRemove; ++i) {
            iterator.next();
            iterator.remove();
        }
        this.saveIdsToVault();
    }

    private void saveIdsToVault() {
        String joinedIds = this.staleIds.stream().map(UUID::toString).collect(Collectors.joining("\n"));
        this.vaultManager.put(STALE_IDS_KEY, joinedIds.getBytes(StandardCharsets.UTF_8));
    }
}

