/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.disaster;

import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryRequestsSerialization;
import org.apache.ignite.internal.table.distributed.disaster.ManualGroupRestartRequest;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerializer;

class ManualGroupRestartRequestSerializer
extends VersionedSerializer<ManualGroupRestartRequest> {
    static final ManualGroupRestartRequestSerializer INSTANCE = new ManualGroupRestartRequestSerializer();

    ManualGroupRestartRequestSerializer() {
    }

    protected void writeExternalData(ManualGroupRestartRequest request, IgniteDataOutput out) throws IOException {
        out.writeUuid(request.operationId());
        out.writeVarInt((long)request.zoneId());
        out.writeVarInt((long)request.tableId());
        DisasterRecoveryRequestsSerialization.writeVarIntSet(request.partitionIds(), out);
        ManualGroupRestartRequestSerializer.writeStringSet(request.nodeNames(), (IgniteDataOutput)out);
        HybridTimestamp.hybridTimestamp((long)request.assignmentsTimestamp()).writeTo(out);
    }

    protected ManualGroupRestartRequest readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        UUID operationId = in.readUuid();
        int zoneId = in.readVarIntAsInt();
        int tableId = in.readVarIntAsInt();
        Set<Integer> partitionIds = DisasterRecoveryRequestsSerialization.readVarIntSet(in);
        Set nodeNames = ManualGroupRestartRequestSerializer.readStringSet((IgniteDataInput)in);
        HybridTimestamp assignmentsTimestamp = HybridTimestamp.readFrom((IgniteDataInput)in);
        return new ManualGroupRestartRequest(operationId, zoneId, tableId, partitionIds, nodeNames, assignmentsTimestamp.longValue());
    }
}

