/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.lang.IgniteExceptionMapper;
import org.apache.ignite.internal.lang.IgniteExceptionMappersProvider;
import org.apache.ignite.internal.sql.engine.QueryCancelledException;
import org.apache.ignite.internal.sql.engine.exec.RemoteFragmentExecutionException;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.sql.SqlException;

@AutoService(value={IgniteExceptionMappersProvider.class})
public class SqlExceptionMapperProvider
implements IgniteExceptionMappersProvider {
    private static final String NOT_NULL_CONSTRAINT_MESSAGE = "does not allow NULLs";

    public Collection<IgniteExceptionMapper<?, ?>> mappers() {
        ArrayList mappers = new ArrayList();
        mappers.add(IgniteExceptionMapper.unchecked(QueryCancelledException.class, err -> new SqlException(err.traceId(), err.code(), err.getMessage(), (Throwable)((Object)err))));
        mappers.add(IgniteExceptionMapper.unchecked(RemoteFragmentExecutionException.class, err -> {
            if (err.groupCode() == ErrorGroups.Sql.SQL_ERR_GROUP.groupCode()) {
                return new SqlException(err.traceId(), err.code(), err.getMessage(), (Throwable)((Object)err));
            }
            return new IgniteException(err.traceId(), err.code(), err.getMessage(), (Throwable)((Object)err));
        }));
        mappers.add(IgniteExceptionMapper.unchecked(CalciteContextException.class, err -> {
            String message = err.getMessage();
            if (message != null && message.contains(NOT_NULL_CONSTRAINT_MESSAGE)) {
                return new SqlException(ErrorGroups.Sql.CONSTRAINT_VIOLATION_ERR, message, (Throwable)err);
            }
            return new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Failed to validate query. " + message, (Throwable)err);
        }));
        mappers.add(IgniteExceptionMapper.unchecked(CatalogValidationException.class, err -> new SqlException(err.traceId(), ErrorGroups.Sql.STMT_VALIDATION_ERR, "Failed to validate query. " + err.getMessage(), (Throwable)err)));
        return mappers;
    }
}

