/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.MetricSource;

public class MetricRegistry {
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<String, MetricSource> sources = new HashMap<String, MetricSource>();
    private volatile IgniteBiTuple<Map<String, MetricSet>, Long> metricSnapshot = new IgniteBiTuple(Collections.emptyMap(), (Object)0L);

    public void registerSource(MetricSource src) {
        this.lock.lock();
        try {
            assert (!src.enabled()) : "Metric source shouldn't be enabled before registration in registry.";
            MetricSource old = this.sources.putIfAbsent(src.name(), src);
            if (old != null) {
                throw new IllegalStateException("Metrics source with given name already exists: " + src.name());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void unregisterSource(MetricSource src) {
        this.unregisterSource(src.name());
    }

    public void unregisterSource(String srcName) {
        this.lock.lock();
        try {
            this.disable(srcName);
            this.sources.remove(srcName);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricSet enable(MetricSource src) {
        this.lock.lock();
        try {
            MetricSource registered = this.checkAndGetRegistered(src);
            MetricSet metricSet = registered.enable();
            if (metricSet != null) {
                this.addMetricSet(src.name(), metricSet);
            }
            MetricSet metricSet2 = metricSet;
            return metricSet2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricSet enable(String srcName) {
        this.lock.lock();
        try {
            MetricSource src = this.sources.get(srcName);
            if (src == null) {
                throw new IllegalStateException("Metrics source with given name doesn't exist: " + srcName);
            }
            MetricSet metricSet = src.enable();
            if (metricSet != null) {
                this.addMetricSet(src.name(), metricSet);
            }
            MetricSet metricSet2 = metricSet;
            return metricSet2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void disable(MetricSource src) {
        this.lock.lock();
        try {
            MetricSource registered = this.checkAndGetRegistered(src);
            if (!registered.enabled()) {
                return;
            }
            registered.disable();
            this.removeMetricSet(registered.name());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void disable(String srcName) {
        this.lock.lock();
        try {
            MetricSource src = this.sources.get(srcName);
            if (src == null) {
                throw new IllegalStateException("Metrics source with given name doesn't exist: " + srcName);
            }
            if (!src.enabled()) {
                return;
            }
            src.disable();
            this.removeMetricSet(srcName);
        }
        finally {
            this.lock.unlock();
        }
    }

    private MetricSource checkAndGetRegistered(MetricSource src) {
        assert (this.lock.isHeldByCurrentThread()) : "Access to shared state from an incorrect thread " + Thread.currentThread().getName();
        Objects.requireNonNull(src);
        MetricSource registered = this.sources.get(src.name());
        if (registered == null) {
            throw new IllegalStateException("Metrics source isn't registered: " + src.name());
        }
        if (!src.equals(registered)) {
            throw new IllegalArgumentException("Given metric source is not the same as registered by the same name: " + src.name());
        }
        return registered;
    }

    private void addMetricSet(String srcName, MetricSet metricSet) {
        assert (this.lock.isHeldByCurrentThread()) : "Access to a shared state from an incorrect thread " + Thread.currentThread().getName();
        TreeMap<String, MetricSet> metricSets = new TreeMap<String, MetricSet>((Map)this.metricSnapshot.get1());
        metricSets.put(srcName, metricSet);
        this.updateMetricSnapshot(metricSets);
    }

    private void removeMetricSet(String srcName) {
        assert (this.lock.isHeldByCurrentThread()) : "Access to a shared state from an incorrect thread " + Thread.currentThread().getName();
        TreeMap<String, MetricSet> metricSets = new TreeMap<String, MetricSet>((Map)this.metricSnapshot.get1());
        metricSets.remove(srcName);
        this.updateMetricSnapshot(metricSets);
    }

    private void updateMetricSnapshot(Map<String, MetricSet> metricSets) {
        assert (this.lock.isHeldByCurrentThread()) : "Access to shared state from an incorrect thread " + Thread.currentThread().getName();
        IgniteBiTuple<Map<String, MetricSet>, Long> old = this.metricSnapshot;
        this.metricSnapshot = new IgniteBiTuple(Collections.unmodifiableMap(metricSets), (Object)((Long)old.get2() + 1L));
    }

    public IgniteBiTuple<Map<String, MetricSet>, Long> metricSnapshot() {
        return this.metricSnapshot;
    }

    public Collection<MetricSource> metricSources() {
        this.lock.lock();
        try {
            List<MetricSource> list = List.copyOf(this.sources.values());
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }
}

