/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.marshaller.reflection;

import java.util.List;
import org.apache.ignite.internal.marshaller.Marshaller;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.marshaller.MarshallerUtil;
import org.apache.ignite.internal.schema.row.RowAssembler;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypeSpec;
import org.jetbrains.annotations.Nullable;

class ObjectStatistics {
    private static final ObjectStatistics ZERO_STATISTICS = new ObjectStatistics(-1, false);
    private static final int DECIMAL_VALUE_ESTIMATED_SIZE = 26;
    private final int estimatedValueSize;
    private final boolean exactEstimation;

    private ObjectStatistics(int estimatedValueSize, boolean exactEstimation) {
        this.estimatedValueSize = estimatedValueSize;
        this.exactEstimation = exactEstimation;
    }

    private int estimatedValueSize() {
        return this.estimatedValueSize;
    }

    private boolean exactEstimation() {
        return this.exactEstimation;
    }

    private static ObjectStatistics collectObjectStats(List<Column> cols, Marshaller marsh, @Nullable Object obj) {
        if (obj == null) {
            return ZERO_STATISTICS;
        }
        int estimatedValueSize = 0;
        boolean exactEstimation = true;
        for (int i = 0; i < cols.size(); ++i) {
            Object val = marsh.value(obj, i);
            Column col = cols.get(i);
            NativeType colType = col.type();
            if (val == null) continue;
            col.validate(val);
            if (colType.spec().fixedLength()) {
                estimatedValueSize += colType.sizeInBytes();
                continue;
            }
            int valueSize = colType.spec() == NativeTypeSpec.DECIMAL ? 26 : MarshallerUtil.getValueSize(val, colType);
            exactEstimation = false;
            estimatedValueSize += valueSize;
        }
        return new ObjectStatistics(estimatedValueSize, exactEstimation);
    }

    static RowAssembler createAssembler(SchemaDescriptor schema, Marshaller keyMarsh, Object key) {
        ObjectStatistics keyStat = ObjectStatistics.collectObjectStats(schema.keyColumns(), keyMarsh, key);
        int totalValueSize = keyStat.estimatedValueSize();
        return new RowAssembler(schema.version(), schema.keyColumns(), totalValueSize, keyStat.exactEstimation());
    }

    static RowAssembler createAssembler(SchemaDescriptor schema, Marshaller keyMarsh, Marshaller valMarsh, Object key, @Nullable Object val) {
        ObjectStatistics keyStat = ObjectStatistics.collectObjectStats(schema.keyColumns(), keyMarsh, key);
        ObjectStatistics valStat = ObjectStatistics.collectObjectStats(schema.valueColumns(), valMarsh, val);
        int totalValueSize = keyStat.estimatedValueSize() < 0 || valStat.estimatedValueSize() < 0 ? -1 : keyStat.estimatedValueSize() + valStat.estimatedValueSize();
        return new RowAssembler(schema.version(), schema.columns(), totalValueSize, keyStat.exactEstimation() && valStat.exactEstimation());
    }
}

