/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.elb;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancingClientBuilder;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetDescription;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetHealthDescription;
import com.amazonaws.util.StringUtils;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinderAdapter;

public class TcpDiscoveryAlbIpFinder
extends TcpDiscoveryIpFinderAdapter {
    private AmazonElasticLoadBalancing amazonELBClient;
    private String targetGrpARN;
    private AmazonEC2 amazonEC2Client;
    private AWSCredentialsProvider credsProvider;
    private String region;

    public TcpDiscoveryAlbIpFinder() {
        this.setShared(true);
    }

    public Collection<InetSocketAddress> getRegisteredAddresses() throws IgniteSpiException {
        this.initClients();
        DescribeTargetHealthRequest req = new DescribeTargetHealthRequest().withTargetGroupArn(this.targetGrpARN);
        List desc = this.amazonELBClient.describeTargetHealth(req).getTargetHealthDescriptions();
        LinkedList<String> instanceIps = new LinkedList<String>();
        LinkedList<String> instanceIds = new LinkedList<String>();
        for (TargetHealthDescription targetHealthDesc : desc) {
            TargetDescription target = targetHealthDesc.getTarget();
            String targetId = target.getId();
            if (this.isIPAddress(targetId)) {
                instanceIps.add(targetId);
                continue;
            }
            instanceIds.add(targetId);
        }
        DescribeInstancesRequest descInstReq = new DescribeInstancesRequest().withInstanceIds(instanceIds);
        List reservations = this.amazonEC2Client.describeInstances(descInstReq).getReservations();
        for (Reservation reservation : reservations) {
            List instances = reservation.getInstances();
            for (Instance instance : instances) {
                String ip = instance.getPrivateIpAddress();
                instanceIps.add(ip);
            }
        }
        LinkedList<InetSocketAddress> addrs = new LinkedList<InetSocketAddress>();
        for (String ip : instanceIps) {
            InetSocketAddress addr = new InetSocketAddress(ip, 0);
            addrs.add(addr);
        }
        return addrs;
    }

    private boolean isIPAddress(String id) {
        return InetAddressUtils.isIPv4Address((String)id) || InetAddressUtils.isIPv4MappedIPv64Address((String)id) || InetAddressUtils.isIPv6Address((String)id) || InetAddressUtils.isIPv6HexCompressedAddress((String)id) || InetAddressUtils.isIPv6StdAddress((String)id);
    }

    private void initClients() {
        if (this.credsProvider == null || StringUtils.isNullOrEmpty((String)this.targetGrpARN) || StringUtils.isNullOrEmpty((String)this.region)) {
            throw new IgniteSpiException("One or more configuration parameters are invalid [setCredentialsProvider=" + this.credsProvider + ", setRegion=" + this.region + ", setTargetGroupARN=" + this.targetGrpARN + "]");
        }
        if (this.amazonEC2Client == null) {
            this.amazonEC2Client = (AmazonEC2)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2ClientBuilder.standard().withRegion(this.region)).withCredentials(this.credsProvider)).build();
        }
        if (this.amazonELBClient == null) {
            this.amazonELBClient = (AmazonElasticLoadBalancing)((AmazonElasticLoadBalancingClientBuilder)((AmazonElasticLoadBalancingClientBuilder)AmazonElasticLoadBalancingClientBuilder.standard().withRegion(this.region)).withCredentials(this.credsProvider)).build();
        }
    }

    @IgniteSpiConfiguration(optional=false)
    public void setTargetGrpARN(String targetGrpARN) {
        this.targetGrpARN = targetGrpARN;
    }

    @IgniteSpiConfiguration(optional=false)
    public void setRegion(String region) {
        this.region = region;
    }

    @IgniteSpiConfiguration(optional=false)
    public void setCredentialsProvider(AWSCredentialsProvider credsProvider) {
        this.credsProvider = credsProvider;
    }

    public void registerAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
    }

    public void unregisterAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
    }
}

