/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.compute.gridify.aop;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeLoadBalancer;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.compute.gridify.GridifyArgument;
import org.apache.ignite.internal.util.gridify.GridifyJobAdapter;
import org.apache.ignite.internal.util.lang.GridPeerDeployAware;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoadBalancerResource;
import org.jetbrains.annotations.NotNull;

public class GridifyDefaultTask
extends ComputeTaskAdapter<GridifyArgument, Object>
implements GridPeerDeployAware {
    private static final long serialVersionUID = 0L;
    private final transient Class<?> p2pCls;
    private final transient ClassLoader clsLdr;
    @IgniteInstanceResource
    private Ignite ignite;
    @LoadBalancerResource
    private ComputeLoadBalancer balancer;

    public GridifyDefaultTask(Class<?> cls) {
        assert (cls != null);
        this.p2pCls = cls;
        this.clsLdr = U.detectClassLoader(cls);
    }

    @Override
    public Class<?> deployClass() {
        return this.p2pCls;
    }

    @Override
    public ClassLoader classLoader() {
        return this.clsLdr;
    }

    @Override
    @NotNull
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, GridifyArgument arg) {
        assert (!subgrid.isEmpty()) : "Subgrid should not be empty: " + subgrid;
        assert (this.ignite != null) : "Grid instance could not be injected";
        assert (this.balancer != null) : "Load balancer could not be injected";
        GridifyJobAdapter job = new GridifyJobAdapter(arg);
        ClusterNode node = this.balancer.getBalancedNode(job, Collections.singletonList(this.ignite.cluster().localNode()));
        if (node != null) {
            return Collections.singletonMap(job, node);
        }
        return Collections.singletonMap(job, this.balancer.getBalancedNode(job, null));
    }

    @Override
    public final Object reduce(List<ComputeJobResult> results) {
        assert (results.size() == 1);
        ComputeJobResult res = results.get(0);
        if (res.getException() != null) {
            throw res.getException();
        }
        return res.getData();
    }
}

