/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.NearTxFinishFuture;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.transactions.TransactionState;

public class GridNearTxFinishAndAckFuture
extends GridFutureAdapter<IgniteInternalTx>
implements NearTxFinishFuture {
    private final NearTxFinishFuture finishFut;

    GridNearTxFinishAndAckFuture(NearTxFinishFuture finishFut) {
        finishFut.listen(this::onFinishFutureDone);
        this.finishFut = finishFut;
    }

    @Override
    public boolean commit() {
        return this.finishFut.commit();
    }

    @Override
    public GridNearTxLocal tx() {
        return this.finishFut.tx();
    }

    @Override
    public void onNodeStop(IgniteCheckedException e) {
        this.finishFut.onNodeStop(e);
    }

    @Override
    public void finish(boolean commit, boolean clearThreadMap, boolean onTimeout) {
        this.finishFut.finish(commit, clearThreadMap, onTimeout);
    }

    private void onFinishFutureDone(IgniteInternalFuture<IgniteInternalTx> fut) {
        GridNearTxLocal tx = this.tx();
        Throwable err = fut.error();
        if (tx.state() == TransactionState.COMMITTED) {
            tx.context().coordinators().ackTxCommit(tx.mvccSnapshot()).listen(fut0 -> this.onDone(tx, this.addSuppressed(err, fut0.error())));
        } else {
            tx.context().coordinators().ackTxRollback(tx.mvccSnapshot());
            this.onDone(tx, err);
        }
    }

    private Throwable addSuppressed(Throwable to, Throwable ex) {
        if (ex == null) {
            return to;
        }
        if (to == null) {
            return ex;
        }
        to.addSuppressed(ex);
        return to;
    }

    @Override
    public String toString() {
        return S.toString(GridNearTxFinishAndAckFuture.class, this);
    }
}

