/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.DataRegionMetricsProvider;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.HitRateMetric;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.metric.Metric;

public class DataRegionMetricsImpl
implements DataRegionMetrics {
    public static final String DATAREGION_METRICS_PREFIX = MetricUtils.metricName("io", "dataregion");
    private final DataRegionMetricsProvider dataRegionMetricsProvider;
    private final LongAdderMetric totalAllocatedPages;
    private final ConcurrentMap<String, LongAdderMetric> grpAllocationTrackers = new ConcurrentHashMap<String, LongAdderMetric>();
    private final LongAdderMetric largeEntriesPages;
    private final LongAdderMetric dirtyPages;
    private final LongAdderMetric readPages;
    private final LongAdderMetric writtenPages;
    private final LongAdderMetric replacedPages;
    private final AtomicLongMetric offHeapSize;
    private final AtomicLongMetric checkpointBufferSize;
    private volatile boolean metricsEnabled;
    private boolean persistenceEnabled;
    private volatile int subInts;
    private final HitRateMetric allocRate;
    private final HitRateMetric evictRate;
    private final HitRateMetric pageReplaceRate;
    private final HitRateMetric pageReplaceAge;
    private final LongAdderMetric totalThrottlingTime;
    private final DataRegionConfiguration memPlcCfg;
    private PageMemory pageMem;
    private final GridMetricManager mmgr;
    private volatile long rateTimeInterval;

    public DataRegionMetricsImpl(DataRegionConfiguration memPlcCfg, GridMetricManager mmgr, DataRegionMetricsProvider dataRegionMetricsProvider) {
        this.memPlcCfg = memPlcCfg;
        this.dataRegionMetricsProvider = dataRegionMetricsProvider;
        this.mmgr = mmgr;
        this.metricsEnabled = memPlcCfg.isMetricsEnabled();
        this.persistenceEnabled = memPlcCfg.isPersistenceEnabled();
        this.rateTimeInterval = memPlcCfg.getMetricsRateTimeInterval();
        this.subInts = memPlcCfg.getMetricsSubIntervalCount();
        MetricRegistry mreg = mmgr.registry(MetricUtils.metricName(DATAREGION_METRICS_PREFIX, memPlcCfg.getName()));
        this.allocRate = mreg.hitRateMetric("AllocationRate", "Allocation rate (pages per second) averaged across rateTimeInternal.", 60000L, 5);
        this.totalAllocatedPages = mreg.longAdderMetric("TotalAllocatedPages", this::updateAllocRate, "Total number of allocated pages.");
        this.evictRate = mreg.hitRateMetric("EvictionRate", "Eviction rate (pages per second).", 60000L, 5);
        this.pageReplaceRate = mreg.hitRateMetric("PagesReplaceRate", "Rate at which pages in memory are replaced with pages from persistent storage (pages per second).", 60000L, 5);
        this.pageReplaceAge = mreg.hitRateMetric("PagesReplaceAge", "Average age at which pages in memory are replaced with pages from persistent storage (milliseconds).", 60000L, 5);
        this.largeEntriesPages = mreg.longAdderMetric("LargeEntriesPagesCount", "Count of pages that fully ocupied by large entries that go beyond page size");
        this.dirtyPages = mreg.longAdderMetric("DirtyPages", "Number of pages in memory not yet synchronized with persistent storage.");
        this.readPages = mreg.longAdderMetric("PagesRead", "Number of pages read from last restart.");
        this.writtenPages = mreg.longAdderMetric("PagesWritten", "Number of pages written from last restart.");
        this.replacedPages = mreg.longAdderMetric("PagesReplaced", "Number of pages replaced from last restart.");
        this.offHeapSize = mreg.longMetric("OffHeapSize", "Offheap size in bytes.");
        this.checkpointBufferSize = mreg.longMetric("CheckpointBufferSize", "Checkpoint buffer size in bytes.");
        mreg.register("EmptyDataPages", dataRegionMetricsProvider::emptyDataPages, "Calculates empty data pages count for region. It counts only totally free pages that can be reused (e. g. pages that are contained in reuse bucket of free list).");
        this.totalThrottlingTime = mreg.longAdderMetric("TotalThrottlingTime", "Total throttling threads time in milliseconds. The Ignite throttles threads that generate dirty pages during the ongoing checkpoint.");
        mreg.longMetric("InitialSize", "Initial memory region size in bytes defined by its data region.").value(memPlcCfg.getInitialSize());
        mreg.longMetric("MaxSize", "Maximum memory region size in bytes defined by its data region.").value(memPlcCfg.getMaxSize());
    }

    @Override
    public String getName() {
        return U.maskName(this.memPlcCfg.getName());
    }

    @Override
    public long getTotalAllocatedPages() {
        return this.totalAllocatedPages.value();
    }

    @Override
    public long getTotalUsedPages() {
        return this.getTotalAllocatedPages() - this.dataRegionMetricsProvider.emptyDataPages();
    }

    @Override
    public long getTotalAllocatedSize() {
        return this.getTotalAllocatedPages() * (long)(this.persistenceEnabled ? this.pageMem.pageSize() : this.pageMem.systemPageSize());
    }

    @Override
    public float getAllocationRate() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        return (float)this.allocRate.value() * 1000.0f / (float)this.rateTimeInterval;
    }

    @Override
    public float getEvictionRate() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        return (float)this.evictRate.value() * 1000.0f / (float)this.rateTimeInterval;
    }

    @Override
    public float getLargeEntriesPagesPercentage() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        return this.totalAllocatedPages.value() != 0L ? (float)this.largeEntriesPages.value() / (float)this.totalAllocatedPages.value() : 0.0f;
    }

    @Override
    public float getPagesFillFactor() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        long freeSpace = this.dataRegionMetricsProvider.partiallyFilledPagesFreeSpace();
        long totalAllocated = (long)this.getPageSize() * this.totalAllocatedPages.value();
        return totalAllocated != 0L ? (float)(totalAllocated - freeSpace) / (float)totalAllocated : 0.0f;
    }

    @Override
    public long getDirtyPages() {
        if (!this.metricsEnabled || !this.persistenceEnabled) {
            return 0L;
        }
        return this.dirtyPages.value();
    }

    @Override
    public float getPagesReplaceRate() {
        if (!this.metricsEnabled || !this.persistenceEnabled) {
            return 0.0f;
        }
        return (float)this.pageReplaceRate.value() * 1000.0f / (float)this.rateTimeInterval;
    }

    @Override
    public float getPagesReplaceAge() {
        if (!this.metricsEnabled || !this.persistenceEnabled) {
            return 0.0f;
        }
        long rep = this.pageReplaceRate.value();
        return rep == 0L ? 0.0f : (float)this.pageReplaceAge.value() / (float)rep;
    }

    @Override
    public long getPhysicalMemoryPages() {
        if (!this.persistenceEnabled) {
            return this.getTotalAllocatedPages();
        }
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.pageMem.loadedPages();
    }

    @Override
    public long getPhysicalMemorySize() {
        return this.getPhysicalMemoryPages() * (long)this.pageMem.systemPageSize();
    }

    @Override
    public long getUsedCheckpointBufferPages() {
        if (!this.metricsEnabled || !this.persistenceEnabled) {
            return 0L;
        }
        return this.pageMem.checkpointBufferPagesCount();
    }

    @Override
    public long getUsedCheckpointBufferSize() {
        return this.getUsedCheckpointBufferPages() * (long)this.pageMem.systemPageSize();
    }

    @Override
    public long getCheckpointBufferSize() {
        if (!this.metricsEnabled || !this.persistenceEnabled) {
            return 0L;
        }
        return this.checkpointBufferSize.value();
    }

    @Override
    public int getPageSize() {
        if (!this.metricsEnabled) {
            return 0;
        }
        return this.pageMem.pageSize();
    }

    @Override
    public long getPagesRead() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.readPages.value();
    }

    @Override
    public long getPagesWritten() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.writtenPages.value();
    }

    @Override
    public long getPagesReplaced() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.replacedPages.value();
    }

    @Override
    public long getOffHeapSize() {
        return this.offHeapSize.value();
    }

    @Override
    public long getOffheapUsedSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.pageMem.loadedPages() * (long)this.pageMem.systemPageSize();
    }

    public void updateOffHeapSize(long size) {
        this.offHeapSize.add(size);
    }

    public void updateCheckpointBufferSize(long size) {
        this.checkpointBufferSize.add(size);
    }

    public void updatePageReplaceRate(long pageAge) {
        if (this.metricsEnabled) {
            this.pageReplaceRate.increment();
            this.pageReplaceAge.add(pageAge);
            this.replacedPages.increment();
        }
    }

    public void onPageRead() {
        if (this.metricsEnabled) {
            this.readPages.increment();
        }
    }

    public void onPageWritten() {
        if (this.metricsEnabled) {
            this.writtenPages.increment();
        }
    }

    public void incrementDirtyPages() {
        if (this.metricsEnabled) {
            this.dirtyPages.increment();
        }
    }

    public void decrementDirtyPages() {
        if (this.metricsEnabled) {
            this.dirtyPages.decrement();
        }
    }

    public void resetDirtyPages() {
        if (this.metricsEnabled) {
            this.dirtyPages.reset();
        }
    }

    public LongAdderMetric totalAllocatedPages() {
        return this.totalAllocatedPages;
    }

    public LongAdderMetric getOrAllocateGroupPageAllocationTracker(String grpName) {
        return this.grpAllocationTrackers.computeIfAbsent(grpName, id -> this.mmgr.registry(MetricUtils.metricName("cacheGroups", grpName)).longAdderMetric("TotalAllocatedPages", this.totalAllocatedPages::add, "Cache group total allocated pages."));
    }

    public void updateEvictionRate() {
        if (this.metricsEnabled) {
            this.evictRate.increment();
        }
    }

    public void incrementLargeEntriesPages() {
        if (this.metricsEnabled) {
            this.largeEntriesPages.increment();
        }
    }

    public void decrementLargeEntriesPages() {
        if (this.metricsEnabled) {
            this.largeEntriesPages.decrement();
        }
    }

    public void enableMetrics() {
        this.metricsEnabled = true;
    }

    public void disableMetrics() {
        this.metricsEnabled = false;
    }

    public void persistenceEnabled(boolean persistenceEnabled) {
        this.persistenceEnabled = persistenceEnabled;
    }

    public void pageMemory(PageMemory pageMem) {
        this.pageMem = pageMem;
        MetricRegistry mreg = this.mmgr.registry(MetricUtils.metricName(DATAREGION_METRICS_PREFIX, this.memPlcCfg.getName()));
        mreg.register("PagesFillFactor", this::getPagesFillFactor, "The percentage of the used space.");
        mreg.register("PhysicalMemoryPages", this::getPhysicalMemoryPages, "Number of pages residing in physical RAM.");
        mreg.register("OffheapUsedSize", this::getOffheapUsedSize, "Offheap used size in bytes.");
        mreg.register("TotalAllocatedSize", this::getTotalAllocatedSize, "Gets a total size of memory allocated in the data region, in bytes");
        mreg.register("PhysicalMemorySize", this::getPhysicalMemorySize, "Gets total size of pages loaded to the RAM, in bytes");
        mreg.register("UsedCheckpointBufferSize", this::getUsedCheckpointBufferSize, "Gets used checkpoint buffer size in bytes");
    }

    @Deprecated
    public void rateTimeInterval(long rateTimeInterval) {
        this.rateTimeInterval = rateTimeInterval;
        this.allocRate.reset(rateTimeInterval, this.subInts);
        this.evictRate.reset(rateTimeInterval, this.subInts);
        this.pageReplaceRate.reset(rateTimeInterval, this.subInts);
        this.pageReplaceAge.reset(rateTimeInterval, this.subInts);
    }

    @Deprecated
    public void subIntervals(int subInts) {
        assert (subInts > 0);
        if (this.subInts == subInts) {
            return;
        }
        if (this.rateTimeInterval / (long)subInts < 10L) {
            subInts = (int)this.rateTimeInterval / 10;
        }
        this.allocRate.reset(this.rateTimeInterval, subInts);
        this.evictRate.reset(this.rateTimeInterval, subInts);
        this.pageReplaceRate.reset(this.rateTimeInterval, subInts);
        this.pageReplaceAge.reset(this.rateTimeInterval, subInts);
    }

    public void clear() {
        this.totalAllocatedPages.reset();
        this.grpAllocationTrackers.values().forEach(Metric::reset);
        this.largeEntriesPages.reset();
        this.dirtyPages.reset();
        this.readPages.reset();
        this.writtenPages.reset();
        this.replacedPages.reset();
        this.offHeapSize.reset();
        this.checkpointBufferSize.reset();
        this.allocRate.reset();
        this.evictRate.reset();
        this.pageReplaceRate.reset();
        this.pageReplaceAge.reset();
    }

    public void addThrottlingTime(long time) {
        if (this.metricsEnabled) {
            this.totalThrottlingTime.add(time);
        }
    }

    private void updateAllocRate(long delta) {
        if (this.metricsEnabled && delta > 0L) {
            this.allocRate.add(delta);
        }
    }
}

