/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.ipc.shmem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IpcSharedMemoryNativeLoader {
    private static final String LIB_NAME_BASE = "igniteshmem";
    private static final String JAR_NAME_BASE = "shmem";
    static final String LIB_NAME = "igniteshmem-" + IgniteVersionUtils.VER_STR;
    private static volatile boolean loaded;

    private static String os() {
        String name = System.getProperty("os.name").toLowerCase().trim();
        if (name.startsWith("win")) {
            throw new IllegalStateException("IPC shared memory native loader should not be called on windows.");
        }
        if (name.startsWith("linux")) {
            return "linux";
        }
        if (name.startsWith("mac os x")) {
            return "osx";
        }
        return name.replaceAll("\\W+", "_");
    }

    private static String platform() {
        return IpcSharedMemoryNativeLoader.os() + IpcSharedMemoryNativeLoader.bitModel();
    }

    private static int bitModel() {
        String prop = System.getProperty("sun.arch.data.model");
        if (prop == null) {
            prop = System.getProperty("com.ibm.vm.bitmode");
        }
        if (prop != null) {
            return Integer.parseInt(prop);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(IgniteLogger log) throws IgniteCheckedException {
        if (loaded) {
            return;
        }
        Class<IpcSharedMemoryNativeLoader> clazz = IpcSharedMemoryNativeLoader.class;
        synchronized (IpcSharedMemoryNativeLoader.class) {
            if (loaded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            IpcSharedMemoryNativeLoader.doLoad(log);
            loaded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private static void doLoad(IgniteLogger log) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static File findShmemJar(Collection<Throwable> errs, String igniteHome) {
        File libs = new File(igniteHome, "libs");
        if (!libs.exists() || libs.isFile()) {
            errs.add(new IllegalStateException("Failed to find libs folder in resolved IGNITE_HOME: " + igniteHome));
            return null;
        }
        for (File lib : libs.listFiles()) {
            if (!lib.getName().endsWith(".jar") || !lib.getName().contains(JAR_NAME_BASE)) continue;
            return lib;
        }
        errs.add(new IllegalStateException("Failed to find shmem jar in resolved IGNITE_HOME: " + igniteHome));
        return null;
    }

    private static File getUserSpecificTempDir() throws IgniteCheckedException {
        String userName;
        String tmp = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmp, userName = System.getProperty("user.name"));
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        if (!tmpDir.exists() || !tmpDir.isDirectory()) {
            throw new IgniteCheckedException("Failed to create temporary directory [dir=" + tmpDir + ']');
        }
        return tmpDir;
    }

    private static String osSpecificResourcePath() {
        return "META-INF/native/" + IpcSharedMemoryNativeLoader.os() + "/" + IpcSharedMemoryNativeLoader.mapLibraryName(LIB_NAME_BASE);
    }

    private static String platformSpecificResourcePath() {
        return "META-INF/native/" + IpcSharedMemoryNativeLoader.platform() + "/" + IpcSharedMemoryNativeLoader.mapLibraryName(LIB_NAME_BASE);
    }

    private static String resourcePath() {
        return "META-INF/native/" + IpcSharedMemoryNativeLoader.mapLibraryName(LIB_NAME_BASE);
    }

    private static String mapLibraryName(String name) {
        String libName = System.mapLibraryName(name);
        if (U.isMacOs() && libName.endsWith(".jnilib")) {
            return libName.substring(0, libName.length() - "jnilib".length()) + "dylib";
        }
        return libName;
    }

    private static boolean extractAndLoad(Collection<Throwable> errs, File tmpDir, String rsrcPath) {
        ClassLoader clsLdr = U.detectClassLoader(IpcSharedMemoryNativeLoader.class);
        URL rsrc = clsLdr.getResource(rsrcPath);
        if (rsrc != null) {
            return IpcSharedMemoryNativeLoader.extract(errs, rsrc, new File(tmpDir, IpcSharedMemoryNativeLoader.mapLibraryName(LIB_NAME)));
        }
        errs.add(new IllegalStateException("Failed to find resource with specified class loader [rsrc=" + rsrcPath + ", clsLdr=" + clsLdr + ']'));
        return false;
    }

    private static boolean extractAndLoad(Collection<Throwable> errs, JarFile jar, File tmpDir, String rsrcPath) {
        ZipEntry rsrc = jar.getEntry(rsrcPath);
        if (rsrc != null) {
            return IpcSharedMemoryNativeLoader.extract(errs, rsrc, jar, new File(tmpDir, IpcSharedMemoryNativeLoader.mapLibraryName(LIB_NAME)));
        }
        errs.add(new IllegalStateException("Failed to find resource within specified jar file [rsrc=" + rsrcPath + ", jar=" + jar.getName() + ']'));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean extract(Collection<Throwable> errs, URL src, File target) {
        block8: {
            int read;
            FileOutputStream os = null;
            InputStream is = null;
            try {
                if (!(target.exists() && IpcSharedMemoryNativeLoader.haveEqualMD5(target, src.openStream()) || (is = src.openStream()) == null)) {
                    os = new FileOutputStream(target);
                    byte[] buf = new byte[4096];
                    while ((read = is.read(buf)) != -1) {
                        os.write(buf, 0, read);
                    }
                }
                if (!U.isWindows()) {
                    Runtime.getRuntime().exec(new String[]{"chmod", "775", target.getCanonicalPath()}).waitFor();
                }
                System.load(target.getPath());
                read = 1;
                U.closeQuiet(os);
            }
            catch (IOException | InterruptedException | UnsatisfiedLinkError | NoSuchAlgorithmException e) {
                errs.add(e);
                break block8;
            }
            finally {
                U.closeQuiet(os);
                U.closeQuiet(is);
            }
            U.closeQuiet(is);
            return read != 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean extract(Collection<Throwable> errs, ZipEntry src, JarFile jar, File target) {
        int read;
        FileOutputStream os = null;
        InputStream is = null;
        try {
            if (!(target.exists() && IpcSharedMemoryNativeLoader.haveEqualMD5(target, jar.getInputStream(src)) || (is = jar.getInputStream(src)) == null)) {
                os = new FileOutputStream(target);
                byte[] buf = new byte[4096];
                while ((read = is.read(buf)) != -1) {
                    os.write(buf, 0, read);
                }
            }
            if (!U.isWindows()) {
                Runtime.getRuntime().exec(new String[]{"chmod", "775", target.getCanonicalPath()}).waitFor();
            }
            System.load(target.getPath());
            read = 1;
        }
        catch (IOException | InterruptedException | UnsatisfiedLinkError | NoSuchAlgorithmException e) {
            try {
                errs.add(e);
            }
            catch (Throwable throwable) {
                U.closeQuiet(os);
                U.closeQuiet(is);
                throw throwable;
            }
            U.closeQuiet(os);
            U.closeQuiet(is);
            return false;
        }
        U.closeQuiet(os);
        U.closeQuiet(is);
        return read != 0;
    }

    /*
     * Loose catch block
     */
    private static boolean haveEqualMD5(File target, InputStream srcIS) throws NoSuchAlgorithmException, IOException {
        try {
            try (FileInputStream targetIS = new FileInputStream(target);){
                String targetMD5 = U.calculateMD5(targetIS);
                String srcMD5 = U.calculateMD5(srcIS);
                boolean bl = targetMD5.equals(srcMD5);
                return bl;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            srcIS.close();
        }
    }
}

