/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.services.ServiceConfiguration;

public class VisorServiceConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String name;
    private String svc;
    private int totalCnt;
    private int maxPerNodeCnt;
    private String cacheName;
    private String affKey;
    private String nodeFilter;

    public static List<VisorServiceConfiguration> list(ServiceConfiguration[] cfgs) {
        ArrayList<VisorServiceConfiguration> res = new ArrayList<VisorServiceConfiguration>();
        if (!F.isEmpty(cfgs)) {
            for (ServiceConfiguration cfg : cfgs) {
                res.add(new VisorServiceConfiguration(cfg));
            }
        }
        return res;
    }

    public VisorServiceConfiguration() {
    }

    public VisorServiceConfiguration(ServiceConfiguration src) {
        this.name = src.getName();
        this.svc = VisorTaskUtils.compactClass(src.getService());
        this.totalCnt = src.getTotalCount();
        this.maxPerNodeCnt = src.getMaxPerNodeCount();
        this.cacheName = src.getCacheName();
        this.affKey = VisorTaskUtils.compactClass(src.getAffinityKey());
        this.nodeFilter = VisorTaskUtils.compactClass(src.getNodeFilter());
    }

    public String getName() {
        return this.name;
    }

    public String getService() {
        return this.svc;
    }

    public int getTotalCount() {
        return this.totalCnt;
    }

    public int getMaxPerNodeCount() {
        return this.maxPerNodeCnt;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String getAffinityKey() {
        return this.affKey;
    }

    public String getNodeFilter() {
        return this.nodeFilter;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        U.writeString(out, this.svc);
        out.writeInt(this.totalCnt);
        out.writeInt(this.maxPerNodeCnt);
        U.writeString(out, this.cacheName);
        U.writeString(out, this.affKey);
        U.writeString(out, this.nodeFilter);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.svc = U.readString(in);
        this.totalCnt = in.readInt();
        this.maxPerNodeCnt = in.readInt();
        this.cacheName = U.readString(in);
        this.affKey = U.readString(in);
        this.nodeFilter = U.readString(in);
    }

    public String toString() {
        return S.toString(VisorServiceConfiguration.class, this);
    }
}

