---
title: "Trino"
url: trino
aliases:
    - "trino"
menu:
    main:
        weight: 800
---
<!--
 - Licensed to the Apache Software Foundation (ASF) under one or more
 - contributor license agreements.  See the NOTICE file distributed with
 - this work for additional information regarding copyright ownership.
 - The ASF licenses this file to You under the Apache License, Version 2.0
 - (the "License"); you may not use this file except in compliance with
 - the License.  You may obtain a copy of the License at
 -
 -   http://www.apache.org/licenses/LICENSE-2.0
 -
 - Unless required by applicable law or agreed to in writing, software
 - distributed under the License is distributed on an "AS IS" BASIS,
 - WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 - See the License for the specific language governing permissions and
 - limitations under the License.
 -->
# Trino

## Iceberg format
Iceberg format can be accessed using the Iceberg Connector provided by Trino.
please refer to the documentation at [Iceberg Trino user manual](https://trino.io/docs/current/connector/iceberg.html#) for more information.

## Paimon format
Paimon format can be accessed using the Paimon Connector provided by Trino.
please refer to the documentation at [Paimon Trino user manual](https://paimon.apache.org/docs/master/engines/trino/) for more information.

## Mixed format
### Install

- Create the {trino_home}/plugin/amoro directory in the Trino installation package,
  and extract the contents of the amoro-trino package amoro-mixed-format-trino-xx.tar.gz to the {trino_home}/plugin/amoro directory.
- Configure the Catalog configuration file for Amoro in the {trino_home}/etc/catalog directory, for example:
```tex
connector.name=mixed-format
amoro.url=thrift://{ip}:{port}/{catalogName}
```
- Configure the JVM configuration file for Trino in the {trino_home}/etc directory named `jvm.config` :
```tex
--add-exports=java.security.jgss/sun.security.krb5=ALL-UNNAMED
```

### Support SQL statement

#### Query Table

By adopting the Merge-On-Read approach to read Mixed Format, the latest data of the table can be read, for example:

```sql
SELECT * FROM "{TABLE_NAME}"
```



#### Query BaseStore of Table

Directly querying the BaseStore in a table with a primary key is supported. The BaseStore stores the stock data of the table, which is usually generated by batch job or optimization.
The queried data is static, and the query efficiency is very high, but the timeliness is not good. The syntax is as follows:

```sql
SELECT * FROM "{TABLE_NAME}#BASE"
```



#### Query ChangeStore of Table

Directly querying the ChangeStore in a table with a primary key is supported. The ChangeStore stores the stream and change data of the table, which is usually written in real time by stream job.
The change records of the table can be queried through the ChangeStore, and the expiry time of the data in the ChangeStore determines how long ago the change records can be queried.

```sql
SELECT * FROM "{TABLE_NAME}#CHANGE"
```

Three additional columns will be included in the query result, which are:

- _transaction_id: The transaction ID allocated by AMS when the data is written. In batch mode, it is allocated for each SQL execution, and in stream mode, it is allocated for each checkpoint.
- _file_offset：Indicates the order in which the data was written in the same batch of _transaction_id.
- _change_action：Indicates the type of data, which can be either INSERT or DELETE.

#### Trino and Amoro Type Mapping:

| Amoro type   | Trino type                    |
| :------------- | :---------------------------- |
| `BOOLEAN`      | `BOOLEAN`                     |
| `INT`          | `INTEGER`                     |
| `LONG`         | `BIGINT`                      |
| `FLOAT`        | `REAL`                        |
| `DOUBLE`       | `DOUBLE`                      |
| `DECIMAL(p,s)` | `DECIMAL(p,s)`                |
| `DATE`         | `DATE`                        |
| `TIME`         | `TIME(6)`                     |
| `TIMESTAMP`    | `TIMESTAMP(6)`                |
| `TIMESTAMPTZ`  | `TIMESTAMP(6) WITH TIME ZONE` |
| `STRING`       | `VARCHAR`                     |
| `UUID`         | `UUID`                        |
| `BINARY`       | `VARBINARY`                   |
| `STRUCT(...)`  | `ROW(...)`                    |
| `LIST(e)`      | `ARRAY(e)`                    |
| `MAP(k,v)`     | `MAP(k,v)`                    |

### Trino uses proxy user to access Hadoop cluster.
By default, when Trino queries Amoro, it uses the Hadoop user configured in the [catalog creation](../managing-catalogs/#create-catalog) to access the Hadoop cluster.
To use Trino's user to access the Hadoop cluster, you need enable Hadoop impersonation by adding the mixed-format.hdfs.impersonation.enabled=true parameter in the Amoro catalog configuration file located in the {trino_home}/etc/catalog directory, as follows.

```tex
connector.name=mixed-format
amoro.url=thrift://{ip}:{port}/{catalogName}
mixed-format.hdfs.impersonation.enabled=true
```
`mixed-format.hdfs.impersonation.enabled` default false

{{< hint info >}}
To use Hadoop impersonation, you need to enable the proxy feature for the Hadoop user configured in the [catalog creation](../managing-catalogs/#create-catalog) in the Hadoop cluster beforehand，
and make sure that it can proxy the Trino querying user. Please refer to [Hadoop Proxy User](https://hadoop.apache.org/docs/current/hadoop-project-dist/hadoop-common/Superusers.html#Configurations) for more information.
{{</hint>}}