package org.apache.baremaps.api;

import org.apache.baremaps.model.MbStyle;
import org.apache.baremaps.model.StyleSet;
import java.util.UUID;

import javax.ws.rs.*;
import javax.ws.rs.core.Response;

import io.swagger.annotations.*;

import java.io.InputStream;
import java.util.Map;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/styles")
@Api(description = "the styles API")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-03-14T17:37:24.176539752Z[Etc/UTC]")public interface StylesApi {

    @POST
    @Consumes({ "application/vnd.mapbox.style+json" })
    @ApiOperation(value = "adds a new style", notes = "Adds a style to the style repository.  In case, a new style is created, the following rules apply.  If the style submitted in the request body includes an identifier (this depends on the style encoding), that identifier will be used. If a style with that identifier already exists, an error is returned.  If no identifier can be determined from the submitted style, the server will assign a new identifier to the style.  The URI of the new style is returned in the header `Location`.", tags={ "Styles" })
    @ApiResponses(value = { 
        @ApiResponse(code = 201, message = "style created", response = Void.class),
        @ApiResponse(code = 409, message = "a style with that id already exists", response = Void.class) })
    Response addStyle(@Valid MbStyle mbStyle);

    @DELETE
    @Path("/{styleId}")
    @ApiOperation(value = "delete a style", notes = "Delete an existing style with the id `styleId`. If no such style exists, an error is returned.", tags={ "Styles" })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "style deleted", response = Void.class),
        @ApiResponse(code = 404, message = "style not found", response = Void.class) })
    Response deleteStyle(@PathParam("styleId") @ApiParam("Local identifier of a style. \\ A list of all available styles can be found under the /styles path.") UUID styleId);

    @GET
    @Path("/{styleId}")
    @Produces({ "application/vnd.mapbox.style+json" })
    @ApiOperation(value = "fetch a style by id", notes = "Fetches the style with identifier `styleId`. The set of available styles can be retrieved at `/styles`.  Not all styles are available in all style encodings.", tags={ "Styles" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The style", response = MbStyle.class),
        @ApiResponse(code = 404, message = "style not found", response = Void.class) })
    Response getStyle(@PathParam("styleId") @ApiParam("Local identifier of a style. \\ A list of all available styles can be found under the /styles path.") UUID styleId);

    @GET
    @Produces({ "application/json" })
    @ApiOperation(value = "information about the available styles", notes = "This operation fetches the set of styles available. For each style the id, a title, links to the stylesheet of the style in each supported encoding, and the link to the metadata is provided.  For a small number of the styles the currently simple approach is sufficient, but in general the operation should support paging (using a parameter `limit` and links to the `next` page in responses).", tags={ "Styles" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "the set of available styles", response = StyleSet.class),
        @ApiResponse(code = 406, message = "The media types accepted by the client are not supported for this resource", response = Void.class) })
    Response getStyleSet();

    @PUT
    @Path("/{styleId}")
    @Consumes({ "application/vnd.mapbox.style+json" })
    @ApiOperation(value = "replace a style or add a new style", notes = "Replace an existing style with the id `styleId`. If no such style exists, a new style with that id is added.", tags={ "Styles" })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "style updated or created successfully", response = Void.class) })
    Response updateStyle(@PathParam("styleId") @ApiParam("Local identifier of a style. \\ A list of all available styles can be found under the /styles path.") UUID styleId,@Valid MbStyle mbStyle);
}
