/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.calcite;

import org.apache.baremaps.database.calcite.SqlTypeConversion;
import org.apache.baremaps.database.collection.DataCollectionAdapter;
import org.apache.baremaps.database.schema.DataColumn;
import org.apache.baremaps.database.schema.DataRow;
import org.apache.baremaps.database.schema.DataTable;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.impl.AbstractTable;

class SqlDataTable
extends AbstractTable
implements ScannableTable {
    private final DataTable table;
    private RelDataType rowType;

    public SqlDataTable(DataTable table) {
        this.table = table;
    }

    public Enumerable<Object[]> scan(DataContext root) {
        DataCollectionAdapter<DataRow, Object[]> collection = new DataCollectionAdapter<DataRow, Object[]>(this.table, row -> row.values().toArray());
        return Linq4j.asEnumerable(collection);
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.rowType == null) {
            this.rowType = this.createRowType(typeFactory);
        }
        return this.rowType;
    }

    private RelDataType createRowType(RelDataTypeFactory typeFactory) {
        RelDataTypeFactory.Builder rowType = new RelDataTypeFactory.Builder(typeFactory);
        for (DataColumn column : this.table.rowType().columns()) {
            rowType.add(column.name(), SqlTypeConversion.types.get((Object)column.type()));
        }
        return rowType.build();
    }
}

