/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.TileStoreException;

public class TileChannel
implements Consumer<TileCoord> {
    public final TileStore source;
    public final TileStore target;
    public final boolean deleteEmptyTiles;

    public TileChannel(TileStore source, TileStore target) {
        this(source, target, false);
    }

    public TileChannel(TileStore source, TileStore target, boolean deleteEmptyTiles) {
        this.source = source;
        this.target = target;
        this.deleteEmptyTiles = deleteEmptyTiles;
    }

    @Override
    public void accept(TileCoord tileCoord) {
        try {
            ByteBuffer blob = this.source.read(tileCoord);
            if (blob != null) {
                this.target.write(tileCoord, blob);
            } else if (this.deleteEmptyTiles) {
                this.target.delete(tileCoord);
            }
        }
        catch (TileStoreException ex) {
            throw new RuntimeException("An error occurred while creating the tiles", ex);
        }
    }
}

