/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.WorkflowException;

public record ExecuteSql(Object database, Path file, boolean parallel) implements Task
{
    @Override
    public void execute(WorkflowContext context) throws Exception {
        String script = ExecuteSql.clean(Files.readString(this.file));
        Stream queries = ExecuteSql.split(script);
        if (this.parallel) {
            queries = (Stream)queries.parallel();
        }
        queries.forEach(query -> {
            DataSource dataSource = context.getDataSource(this.database);
            try (Connection connection = dataSource.getConnection();
                 Statement statement = connection.createStatement();){
                statement.execute((String)query);
            }
            catch (SQLException e) {
                throw new WorkflowException(e);
            }
        });
    }

    public static Stream<String> split(String sql) {
        return Arrays.stream(sql.split("\\s*;\\s*(?=(?:[^']*'[^']*')*[^']*$)"));
    }

    public static String clean(String sql) {
        String result = sql;
        Pattern singleLineCommentPattern = Pattern.compile("--.*", 8);
        Matcher singleLineCommentMatcher = singleLineCommentPattern.matcher(result);
        result = singleLineCommentMatcher.replaceAll("");
        Pattern multiLineCommentPattern = Pattern.compile("/\\*.*?\\*/", 32);
        Matcher multiLineMatcher = multiLineCommentPattern.matcher(result);
        result = multiLineMatcher.replaceAll("");
        return result;
    }
}

