/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import mil.nga.geopackage.db.CoreSQLUtils;

public class SQLiteQueryBuilder {
    public static String buildQueryString(boolean distinct, String table, String[] columns, String[] columnsAs, String where, String groupBy, String having, String orderBy, String limit) {
        return SQLiteQueryBuilder.buildQueryString(distinct, new String[]{table}, columns, columnsAs, where, groupBy, having, orderBy, limit);
    }

    public static String buildQueryString(boolean distinct, String[] tables, String[] columns, String[] columnsAs, String where, String groupBy, String having, String orderBy, String limit) {
        if (SQLiteQueryBuilder.isEmpty(groupBy) && !SQLiteQueryBuilder.isEmpty(having)) {
            throw new IllegalArgumentException("HAVING clauses are only permitted when using a groupBy clause");
        }
        StringBuilder query = new StringBuilder(120);
        query.append("SELECT ");
        if (distinct) {
            query.append("DISTINCT ");
        }
        if (columns != null && columns.length != 0) {
            SQLiteQueryBuilder.appendColumns(query, columns, columnsAs);
        } else {
            query.append("* ");
        }
        query.append("FROM ");
        for (int i = 0; i < tables.length; ++i) {
            String table = tables[i];
            if (i > 0) {
                query.append(", ");
            }
            query.append(CoreSQLUtils.quoteWrap(table));
        }
        SQLiteQueryBuilder.appendClause(query, " WHERE ", where);
        SQLiteQueryBuilder.appendClause(query, " GROUP BY ", groupBy);
        SQLiteQueryBuilder.appendClause(query, " HAVING ", having);
        SQLiteQueryBuilder.appendClause(query, " ORDER BY ", orderBy);
        SQLiteQueryBuilder.appendClause(query, " LIMIT ", limit);
        return query.toString();
    }

    private static void appendClause(StringBuilder s, String name, String clause) {
        if (!SQLiteQueryBuilder.isEmpty(clause)) {
            s.append(name);
            s.append(clause);
        }
    }

    public static void appendColumns(StringBuilder s, String[] columns, String[] columnsAs) {
        String[] wrappedColumns = CoreSQLUtils.quoteWrap(columns);
        wrappedColumns = CoreSQLUtils.buildColumnsAs(wrappedColumns, columnsAs);
        for (int i = 0; i < wrappedColumns.length; ++i) {
            String column = wrappedColumns[i];
            if (column == null) continue;
            if (i > 0) {
                s.append(", ");
            }
            s.append(column);
        }
        s.append(' ');
    }

    private static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }
}

