/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.ErrorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class ErrorPrototypeBuiltins
extends JSBuiltinsContainer.Switch {
    public static final JSBuiltinsContainer BUILTINS = new ErrorPrototypeBuiltins();

    protected ErrorPrototypeBuiltins() {
        super(JSError.PROTOTYPE_NAME);
        this.defineFunction(Strings.TO_STRING, 0);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget) {
        if (Strings.equals(Strings.TO_STRING, builtin.getName())) {
            return ErrorPrototypeBuiltinsFactory.ErrorPrototypeToStringNodeGen.create(context, builtin, ErrorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
        }
        return null;
    }

    @ImportStatic(value={Strings.class})
    public static abstract class ErrorPrototypeToStringNode
    extends JSBuiltinNode {
        public ErrorPrototypeToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isObjectNode.executeBoolean(thisObj)"}, limit="1")
        protected final Object toStringNonObject(Object thisObj, @Cached @Cached.Shared IsObjectNode isObjectNode) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }

        @Specialization(guards={"isObjectNode.executeBoolean(errorObj)"}, limit="1")
        protected static Object toStringObject(Object errorObj, @Cached @Cached.Shared IsObjectNode isObjectNode, @Cached(value="create(NAME, false, getContext())") PropertyGetNode getNameNode, @Cached(value="create(MESSAGE, false, getContext())") PropertyGetNode getMessageNode, @Cached JSToStringNode toStringNode) {
            TruffleString strMessage;
            Object objName = getNameNode.getValue(errorObj);
            TruffleString strName = objName == Undefined.instance ? Strings.UC_ERROR : toStringNode.executeString(objName);
            Object objMessage = getMessageNode.getValue(errorObj);
            TruffleString truffleString = strMessage = objMessage == Undefined.instance ? Strings.EMPTY_STRING : toStringNode.executeString(objMessage);
            if (Strings.length(strName) == 0) {
                return strMessage;
            }
            if (Strings.length(strMessage) == 0) {
                return strName;
            }
            return ErrorPrototypeToStringNode.concatNameAndMessage(strName, strMessage);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object concatNameAndMessage(TruffleString strName, TruffleString strMessage) {
            return Strings.concatAll(strName, Strings.COLON_SPACE, strMessage);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class ForeignErrorPrototypeCauseNode
    extends JSBuiltinNode {
        public ForeignErrorPrototypeCauseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object getCause(Object error, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached ImportValueNode importNode, @Cached InlinedBranchProfile errorBranch) {
            if (interop.hasExceptionCause(error)) {
                try {
                    Object cause = interop.getExceptionCause(error);
                    return importNode.executeWithTarget(cause);
                }
                catch (UnsupportedMessageException umex) {
                    errorBranch.enter((Node)this);
                    throw Errors.createTypeErrorInteropException(error, (InteropException)((Object)umex), "getExceptionCause", this);
                }
            }
            return Undefined.instance;
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class ForeignErrorPrototypeStackNode
    extends JSBuiltinNode {
        public ForeignErrorPrototypeStackNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object getStack(Object error, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interopStr, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            if (interop.hasExceptionStackTrace(error)) {
                String stack = JSInteropUtil.formatError(error, interop, interopStr);
                return Strings.fromJavaString(fromJavaStringNode, stack);
            }
            return Undefined.instance;
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class ForeignErrorPrototypeNameNode
    extends JSBuiltinNode {
        public ForeignErrorPrototypeNameNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(limit="InteropLibraryLimit")
        protected Object getName(Object error, @CachedLibrary(value="error") InteropLibrary interop, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interopMeta, @Cached ImportValueNode importNode) {
            block3: {
                try {
                    if (interop.isException(error) && interop.hasMetaObject(error)) {
                        return importNode.executeWithTarget(interopMeta.getMetaQualifiedName(interop.getMetaObject(error)));
                    }
                }
                catch (UnsupportedMessageException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e);
                }
            }
            return Strings.UC_ERROR;
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class ForeignErrorPrototypeMessageNode
    extends JSBuiltinNode {
        public ForeignErrorPrototypeMessageNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object getMessage(Object error, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached ImportValueNode importNode, @Cached InlinedBranchProfile errorBranch) {
            if (interop.hasExceptionMessage(error)) {
                try {
                    Object message = interop.getExceptionMessage(error);
                    return importNode.executeWithTarget(message);
                }
                catch (UnsupportedMessageException umex) {
                    errorBranch.enter((Node)this);
                    throw Errors.createTypeErrorInteropException(error, (InteropException)((Object)umex), "getExceptionMessage", this);
                }
            }
            return Strings.EMPTY_STRING;
        }
    }

    public static final class ForeignErrorPrototypeBuiltins
    extends JSBuiltinsContainer.SwitchEnum<ForeignError> {
        public static final JSBuiltinsContainer BUILTINS = new ForeignErrorPrototypeBuiltins();

        protected ForeignErrorPrototypeBuiltins() {
            super(JSError.PROTOTYPE_NAME, ForeignError.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ForeignError builtinEnum) {
            switch (builtinEnum) {
                case cause: {
                    return ErrorPrototypeBuiltinsFactory.ForeignErrorPrototypeCauseNodeGen.create(context, builtin, ForeignErrorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
                }
                case message: {
                    return ErrorPrototypeBuiltinsFactory.ForeignErrorPrototypeMessageNodeGen.create(context, builtin, ForeignErrorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
                }
                case name: {
                    return ErrorPrototypeBuiltinsFactory.ForeignErrorPrototypeNameNodeGen.create(context, builtin, ForeignErrorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
                }
                case stack: {
                    return ErrorPrototypeBuiltinsFactory.ForeignErrorPrototypeStackNodeGen.create(context, builtin, ForeignErrorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
                }
            }
            return null;
        }

        public static enum ForeignError implements BuiltinEnum<ForeignError>
        {
            cause(0),
            message(0),
            name(0),
            stack(0);

            private final int length;

            private ForeignError(int length) {
                this.length = length;
            }

            @Override
            public int getLength() {
                return this.length;
            }

            @Override
            public boolean isGetter() {
                return true;
            }
        }
    }

    public static abstract class ErrorPrototypeGetStackTraceNode
    extends JSBuiltinNode {
        public ErrorPrototypeGetStackTraceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"!isJSObject(thisObj)"})
        protected JSDynamicObject getStackTrace(Object thisObj) {
            throw Errors.createTypeErrorNotAnObject(thisObj);
        }

        @Specialization(guards={"isJSObject(thisObj)"})
        protected JSDynamicObject getStackTrace(JSDynamicObject thisObj) {
            Object exception = JSDynamicObject.getOrNull(thisObj, JSError.EXCEPTION_PROPERTY_NAME);
            Object[] stackTrace = ErrorPrototypeGetStackTraceNode.getStackTraceFromThrowable(exception);
            return JSArray.createConstant(this.getContext(), this.getRealm(), stackTrace);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object[] getStackTraceFromThrowable(Object exception) {
            if (exception instanceof GraalJSException) {
                return ((GraalJSException)((Object)exception)).getJSStackTrace();
            }
            return new StackTraceElement[0];
        }
    }

    public static final class ErrorPrototypeNashornCompatBuiltins
    extends JSBuiltinsContainer.SwitchEnum<ErrorNashornCompat> {
        public static final JSBuiltinsContainer BUILTINS = new ErrorPrototypeNashornCompatBuiltins();

        protected ErrorPrototypeNashornCompatBuiltins() {
            super(JSError.PROTOTYPE_NAME, ErrorNashornCompat.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ErrorNashornCompat builtinEnum) {
            switch (builtinEnum) {
                case getStackTrace: {
                    return ErrorPrototypeBuiltinsFactory.ErrorPrototypeGetStackTraceNodeGen.create(context, builtin, ErrorPrototypeNashornCompatBuiltins.args().withThis().createArgumentNodes(context));
                }
            }
            return null;
        }

        public static enum ErrorNashornCompat implements BuiltinEnum<ErrorNashornCompat>
        {
            getStackTrace(0);

            private final int length;

            private ErrorNashornCompat(int length) {
                this.length = length;
            }

            @Override
            public int getLength() {
                return this.length;
            }
        }
    }
}

